# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FFTEST_METADATA = Metadata(
    id="1928ae0343683e1c41b9b191dc62899dbf26932f.boutiques",
    name="fftest",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FftestParameters = typing.TypedDict('FftestParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/fftest"]],
    "length": float,
    "num_tests": float,
    "vector_size": float,
    "quiet_mode": bool,
})
FftestParametersTagged = typing.TypedDict('FftestParametersTagged', {
    "@type": typing.Literal["afni/fftest"],
    "length": float,
    "num_tests": float,
    "vector_size": float,
    "quiet_mode": bool,
})


class FftestOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FftestParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def fftest_params(
    length: float,
    num_tests: float,
    vector_size: float,
    quiet_mode: bool = False,
) -> FftestParametersTagged:
    """
    Build parameters.
    
    Args:
        length: Length of the test.
        num_tests: Number of tests to run.
        vector_size: Vector size for the test.
        quiet_mode: Quiet mode.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/fftest",
        "length": length,
        "num_tests": num_tests,
        "vector_size": vector_size,
        "quiet_mode": quiet_mode,
    }
    return params


def fftest_cargs(
    params: FftestParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("fftest")
    cargs.append(str(params.get("length", None)))
    cargs.append(str(params.get("num_tests", None)))
    cargs.append(str(params.get("vector_size", None)))
    if params.get("quiet_mode", False):
        cargs.append("-q")
    return cargs


def fftest_outputs(
    params: FftestParameters,
    execution: Execution,
) -> FftestOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FftestOutputs(
        root=execution.output_file("."),
    )
    return ret


def fftest_execute(
    params: FftestParameters,
    runner: Runner | None = None,
) -> FftestOutputs:
    """
    fftest
    
    A command line tool for testing purposes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FftestOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FFTEST_METADATA)
    params = execution.params(params)
    cargs = fftest_cargs(params, execution)
    ret = fftest_outputs(params, execution)
    execution.run(cargs)
    return ret


def fftest(
    length: float,
    num_tests: float,
    vector_size: float,
    quiet_mode: bool = False,
    runner: Runner | None = None,
) -> FftestOutputs:
    """
    fftest
    
    A command line tool for testing purposes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        length: Length of the test.
        num_tests: Number of tests to run.
        vector_size: Vector size for the test.
        quiet_mode: Quiet mode.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FftestOutputs`).
    """
    params = fftest_params(
        length=length,
        num_tests=num_tests,
        vector_size=vector_size,
        quiet_mode=quiet_mode,
    )
    return fftest_execute(params, runner)


__all__ = [
    "FFTEST_METADATA",
    "FftestOutputs",
    "fftest",
    "fftest_execute",
    "fftest_params",
]
