# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FIND_VARIANCE_LINES_TCSH_METADATA = Metadata(
    id="3447eee105e11d76e6ca8bbc5dda2062c2674033.boutiques",
    name="find_variance_lines.tcsh",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FindVarianceLinesTcshParameters = typing.TypedDict('FindVarianceLinesTcshParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/find_variance_lines.tcsh"]],
    "input_files": list[InputPathType],
    "mask": typing.NotRequired[str | None],
    "min_cvox": typing.NotRequired[int | None],
    "min_nt": typing.NotRequired[int | None],
    "nerode": typing.NotRequired[int | None],
    "nfirst": typing.NotRequired[int | None],
    "percentile": typing.NotRequired[int | None],
    "polort": typing.NotRequired[str | None],
    "output_dir": typing.NotRequired[str | None],
    "do_clean": typing.NotRequired[int | None],
    "do_img": typing.NotRequired[int | None],
    "echo": bool,
    "help": bool,
    "hist": bool,
    "ver": bool,
})
FindVarianceLinesTcshParametersTagged = typing.TypedDict('FindVarianceLinesTcshParametersTagged', {
    "@type": typing.Literal["afni/find_variance_lines.tcsh"],
    "input_files": list[InputPathType],
    "mask": typing.NotRequired[str | None],
    "min_cvox": typing.NotRequired[int | None],
    "min_nt": typing.NotRequired[int | None],
    "nerode": typing.NotRequired[int | None],
    "nfirst": typing.NotRequired[int | None],
    "percentile": typing.NotRequired[int | None],
    "polort": typing.NotRequired[str | None],
    "output_dir": typing.NotRequired[str | None],
    "do_clean": typing.NotRequired[int | None],
    "do_img": typing.NotRequired[int | None],
    "echo": bool,
    "help": bool,
    "hist": bool,
    "ver": bool,
})


class FindVarianceLinesTcshOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FindVarianceLinesTcshParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_directory: OutputPathType | None
    """Output directory containing maps and reports."""


def find_variance_lines_tcsh_params(
    input_files: list[InputPathType],
    mask: str | None = None,
    min_cvox: int | None = None,
    min_nt: int | None = None,
    nerode: int | None = None,
    nfirst: int | None = None,
    percentile: int | None = None,
    polort: str | None = None,
    output_dir: str | None = None,
    do_clean: int | None = None,
    do_img: int | None = None,
    echo: bool = False,
    help_: bool = False,
    hist: bool = False,
    ver: bool = False,
) -> FindVarianceLinesTcshParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: Input EPI datasets.
        mask: Mask for computations (default=AUTO).
        min_cvox: Minimum voxels for valid mask column (default=5).
        min_nt: Minimum number of time points required (default=10).
        nerode: How much to erode input or auto-mask (default=0).
        nfirst: Discard the first VAL time points (default=0).
        percentile: Percentile of variance values to scale to (default=90).
        polort: Polynomial detrending degree (default=A).
        output_dir: Name of the output directory (default=vlines.result).
        do_clean: Do we clean up a little? (default=1).
        do_img: Make vline images? (default=1).
        echo: Run script with shell 'echo' set (default=no).
        help_: Show this help.
        hist: Show the version history.
        ver: Show the current version.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/find_variance_lines.tcsh",
        "input_files": input_files,
        "echo": echo,
        "help": help_,
        "hist": hist,
        "ver": ver,
    }
    if mask is not None:
        params["mask"] = mask
    if min_cvox is not None:
        params["min_cvox"] = min_cvox
    if min_nt is not None:
        params["min_nt"] = min_nt
    if nerode is not None:
        params["nerode"] = nerode
    if nfirst is not None:
        params["nfirst"] = nfirst
    if percentile is not None:
        params["percentile"] = percentile
    if polort is not None:
        params["polort"] = polort
    if output_dir is not None:
        params["output_dir"] = output_dir
    if do_clean is not None:
        params["do_clean"] = do_clean
    if do_img is not None:
        params["do_img"] = do_img
    return params


def find_variance_lines_tcsh_cargs(
    params: FindVarianceLinesTcshParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("find_variance_lines.tcsh")
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    if params.get("mask", None) is not None:
        cargs.extend([
            "-mask",
            params.get("mask", None)
        ])
    if params.get("min_cvox", None) is not None:
        cargs.extend([
            "-min_cvox",
            str(params.get("min_cvox", None))
        ])
    if params.get("min_nt", None) is not None:
        cargs.extend([
            "-min_nt",
            str(params.get("min_nt", None))
        ])
    if params.get("nerode", None) is not None:
        cargs.extend([
            "-nerode",
            str(params.get("nerode", None))
        ])
    if params.get("nfirst", None) is not None:
        cargs.extend([
            "-nfirst",
            str(params.get("nfirst", None))
        ])
    if params.get("percentile", None) is not None:
        cargs.extend([
            "-perc",
            str(params.get("percentile", None))
        ])
    if params.get("polort", None) is not None:
        cargs.extend([
            "-polort",
            params.get("polort", None)
        ])
    if params.get("output_dir", None) is not None:
        cargs.extend([
            "-rdir",
            params.get("output_dir", None)
        ])
    if params.get("do_clean", None) is not None:
        cargs.extend([
            "-do_clean",
            str(params.get("do_clean", None))
        ])
    if params.get("do_img", None) is not None:
        cargs.extend([
            "-do_img",
            str(params.get("do_img", None))
        ])
    if params.get("echo", False):
        cargs.append("-echo")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("hist", False):
        cargs.append("-hist")
    if params.get("ver", False):
        cargs.append("-ver")
    return cargs


def find_variance_lines_tcsh_outputs(
    params: FindVarianceLinesTcshParameters,
    execution: Execution,
) -> FindVarianceLinesTcshOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FindVarianceLinesTcshOutputs(
        root=execution.output_file("."),
        output_directory=execution.output_file(params.get("output_dir", None)) if (params.get("output_dir") is not None) else None,
    )
    return ret


def find_variance_lines_tcsh_execute(
    params: FindVarianceLinesTcshParameters,
    runner: Runner | None = None,
) -> FindVarianceLinesTcshOutputs:
    """
    find_variance_lines.tcsh
    
    Look for bars of high variance that might suggest scanner interference in
    EPI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FindVarianceLinesTcshOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FIND_VARIANCE_LINES_TCSH_METADATA)
    params = execution.params(params)
    cargs = find_variance_lines_tcsh_cargs(params, execution)
    ret = find_variance_lines_tcsh_outputs(params, execution)
    execution.run(cargs)
    return ret


def find_variance_lines_tcsh(
    input_files: list[InputPathType],
    mask: str | None = None,
    min_cvox: int | None = None,
    min_nt: int | None = None,
    nerode: int | None = None,
    nfirst: int | None = None,
    percentile: int | None = None,
    polort: str | None = None,
    output_dir: str | None = None,
    do_clean: int | None = None,
    do_img: int | None = None,
    echo: bool = False,
    help_: bool = False,
    hist: bool = False,
    ver: bool = False,
    runner: Runner | None = None,
) -> FindVarianceLinesTcshOutputs:
    """
    find_variance_lines.tcsh
    
    Look for bars of high variance that might suggest scanner interference in
    EPI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input EPI datasets.
        mask: Mask for computations (default=AUTO).
        min_cvox: Minimum voxels for valid mask column (default=5).
        min_nt: Minimum number of time points required (default=10).
        nerode: How much to erode input or auto-mask (default=0).
        nfirst: Discard the first VAL time points (default=0).
        percentile: Percentile of variance values to scale to (default=90).
        polort: Polynomial detrending degree (default=A).
        output_dir: Name of the output directory (default=vlines.result).
        do_clean: Do we clean up a little? (default=1).
        do_img: Make vline images? (default=1).
        echo: Run script with shell 'echo' set (default=no).
        help_: Show this help.
        hist: Show the version history.
        ver: Show the current version.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FindVarianceLinesTcshOutputs`).
    """
    params = find_variance_lines_tcsh_params(
        input_files=input_files,
        mask=mask,
        min_cvox=min_cvox,
        min_nt=min_nt,
        nerode=nerode,
        nfirst=nfirst,
        percentile=percentile,
        polort=polort,
        output_dir=output_dir,
        do_clean=do_clean,
        do_img=do_img,
        echo=echo,
        help_=help_,
        hist=hist,
        ver=ver,
    )
    return find_variance_lines_tcsh_execute(params, runner)


__all__ = [
    "FIND_VARIANCE_LINES_TCSH_METADATA",
    "FindVarianceLinesTcshOutputs",
    "find_variance_lines_tcsh",
    "find_variance_lines_tcsh_execute",
    "find_variance_lines_tcsh_params",
]
