# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FIRDESIGN_METADATA = Metadata(
    id="0c4ea34db1930ae230e4105a67970c789ca0a3f2.boutiques",
    name="FIRdesign",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FirdesignParameters = typing.TypedDict('FirdesignParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/FIRdesign"]],
    "fbot": float,
    "ftop": float,
    "ntap": float,
    "tr": typing.NotRequired[float | None],
    "alternative_band": typing.NotRequired[list[float] | None],
    "alternative_ntap": typing.NotRequired[float | None],
})
FirdesignParametersTagged = typing.TypedDict('FirdesignParametersTagged', {
    "@type": typing.Literal["afni/FIRdesign"],
    "fbot": float,
    "ftop": float,
    "ntap": float,
    "tr": typing.NotRequired[float | None],
    "alternative_band": typing.NotRequired[list[float] | None],
    "alternative_ntap": typing.NotRequired[float | None],
})


class FirdesignOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FirdesignParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def firdesign_params(
    fbot: float,
    ftop: float,
    ntap: float,
    tr: float | None = None,
    alternative_band: list[float] | None = None,
    alternative_ntap: float | None = None,
) -> FirdesignParametersTagged:
    """
    Build parameters.
    
    Args:
        fbot: Lowest frequency in the pass band.
        ftop: Highest frequency in the pass band, must be higher than fbot and\
            <= 0.5/TR.
        ntap: Number of filter weights (AKA 'taps') to use, must be in the\
            range 8..2000 (inclusive).
        tr: Set time grid spacing to 'dd' [default is 1.0].
        alternative_band: Alternative way to specify the passband.
        alternative_ntap: Alternative way to specify the number of taps.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/FIRdesign",
        "fbot": fbot,
        "ftop": ftop,
        "ntap": ntap,
    }
    if tr is not None:
        params["tr"] = tr
    if alternative_band is not None:
        params["alternative_band"] = alternative_band
    if alternative_ntap is not None:
        params["alternative_ntap"] = alternative_ntap
    return params


def firdesign_cargs(
    params: FirdesignParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("FIRdesign")
    cargs.append(str(params.get("fbot", None)))
    cargs.append(str(params.get("ftop", None)))
    cargs.append(str(params.get("ntap", None)))
    if params.get("tr", None) is not None:
        cargs.extend([
            "-TR",
            str(params.get("tr", None))
        ])
    if params.get("alternative_band", None) is not None:
        cargs.extend([
            "-band",
            *map(str, params.get("alternative_band", None))
        ])
    if params.get("alternative_ntap", None) is not None:
        cargs.extend([
            "-ntap",
            str(params.get("alternative_ntap", None))
        ])
    return cargs


def firdesign_outputs(
    params: FirdesignParameters,
    execution: Execution,
) -> FirdesignOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FirdesignOutputs(
        root=execution.output_file("."),
    )
    return ret


def firdesign_execute(
    params: FirdesignParameters,
    runner: Runner | None = None,
) -> FirdesignOutputs:
    """
    FIRdesign
    
    Uses the Remez algorithm to calculate the FIR filter weights for a bandpass
    filter; results are written to stdout in an unadorned (no header) column of
    numbers.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FirdesignOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FIRDESIGN_METADATA)
    params = execution.params(params)
    cargs = firdesign_cargs(params, execution)
    ret = firdesign_outputs(params, execution)
    execution.run(cargs)
    return ret


def firdesign(
    fbot: float,
    ftop: float,
    ntap: float,
    tr: float | None = None,
    alternative_band: list[float] | None = None,
    alternative_ntap: float | None = None,
    runner: Runner | None = None,
) -> FirdesignOutputs:
    """
    FIRdesign
    
    Uses the Remez algorithm to calculate the FIR filter weights for a bandpass
    filter; results are written to stdout in an unadorned (no header) column of
    numbers.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        fbot: Lowest frequency in the pass band.
        ftop: Highest frequency in the pass band, must be higher than fbot and\
            <= 0.5/TR.
        ntap: Number of filter weights (AKA 'taps') to use, must be in the\
            range 8..2000 (inclusive).
        tr: Set time grid spacing to 'dd' [default is 1.0].
        alternative_band: Alternative way to specify the passband.
        alternative_ntap: Alternative way to specify the number of taps.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FirdesignOutputs`).
    """
    params = firdesign_params(
        fbot=fbot,
        ftop=ftop,
        ntap=ntap,
        tr=tr,
        alternative_band=alternative_band,
        alternative_ntap=alternative_ntap,
    )
    return firdesign_execute(params, runner)


__all__ = [
    "FIRDESIGN_METADATA",
    "FirdesignOutputs",
    "firdesign",
    "firdesign_execute",
    "firdesign_params",
]
