# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FLOAT_SCAN_METADATA = Metadata(
    id="736559794aec1b67724d54af3dc33b4693f7d27e.boutiques",
    name="float_scan",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


FloatScanParameters = typing.TypedDict('FloatScanParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/float_scan"]],
    "fix_illegal_values": bool,
    "verbose_mode": bool,
    "skip_count": typing.NotRequired[int | None],
    "input_file": InputPathType,
})
FloatScanParametersTagged = typing.TypedDict('FloatScanParametersTagged', {
    "@type": typing.Literal["afni/float_scan"],
    "fix_illegal_values": bool,
    "verbose_mode": bool,
    "skip_count": typing.NotRequired[int | None],
    "input_file": InputPathType,
})


class FloatScanOutputs(typing.NamedTuple):
    """
    Output object returned when calling `FloatScanParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    stdout_file: OutputPathType
    """Output file with illegal values replaced by 0 when -fix flag is used"""


def float_scan_params(
    input_file: InputPathType,
    fix_illegal_values: bool = False,
    verbose_mode: bool = False,
    skip_count: int | None = None,
) -> FloatScanParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Input file containing IEEE floating point numbers.
        fix_illegal_values: Writes a copy of the input file to stdout,\
            replacing illegal values with 0.
        verbose_mode: Verbose mode: print out index of each illegal value.
        skip_count: Skip the first n floating point locations (i.e., the first\
            4*n bytes) in the file.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/float_scan",
        "fix_illegal_values": fix_illegal_values,
        "verbose_mode": verbose_mode,
        "input_file": input_file,
    }
    if skip_count is not None:
        params["skip_count"] = skip_count
    return params


def float_scan_cargs(
    params: FloatScanParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("float_scan")
    if params.get("fix_illegal_values", False):
        cargs.append("-fix")
    if params.get("verbose_mode", False):
        cargs.append("-v")
    if params.get("skip_count", None) is not None:
        cargs.extend([
            "-skip",
            str(params.get("skip_count", None))
        ])
    cargs.append(execution.input_file(params.get("input_file", None)))
    return cargs


def float_scan_outputs(
    params: FloatScanParameters,
    execution: Execution,
) -> FloatScanOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = FloatScanOutputs(
        root=execution.output_file("."),
        stdout_file=execution.output_file("stdout"),
    )
    return ret


def float_scan_execute(
    params: FloatScanParameters,
    runner: Runner | None = None,
) -> FloatScanOutputs:
    """
    float_scan
    
    Scans the input file of IEEE floating point numbers for illegal values:
    infinities and not-a-number (NaN) values.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FloatScanOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FLOAT_SCAN_METADATA)
    params = execution.params(params)
    cargs = float_scan_cargs(params, execution)
    ret = float_scan_outputs(params, execution)
    execution.run(cargs)
    return ret


def float_scan(
    input_file: InputPathType,
    fix_illegal_values: bool = False,
    verbose_mode: bool = False,
    skip_count: int | None = None,
    runner: Runner | None = None,
) -> FloatScanOutputs:
    """
    float_scan
    
    Scans the input file of IEEE floating point numbers for illegal values:
    infinities and not-a-number (NaN) values.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Input file containing IEEE floating point numbers.
        fix_illegal_values: Writes a copy of the input file to stdout,\
            replacing illegal values with 0.
        verbose_mode: Verbose mode: print out index of each illegal value.
        skip_count: Skip the first n floating point locations (i.e., the first\
            4*n bytes) in the file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `FloatScanOutputs`).
    """
    params = float_scan_params(
        fix_illegal_values=fix_illegal_values,
        verbose_mode=verbose_mode,
        skip_count=skip_count,
        input_file=input_file,
    )
    return float_scan_execute(params, runner)


__all__ = [
    "FLOAT_SCAN_METADATA",
    "FloatScanOutputs",
    "float_scan",
    "float_scan_execute",
    "float_scan_params",
]
