# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

FROM3D_METADATA = Metadata(
    id="350eb8e371fbf27418afd1384aa7ae411057de32.boutiques",
    name="from3d",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


From3dParameters = typing.TypedDict('From3dParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/from3d"]],
    "verbose": bool,
    "nsize": bool,
    "raw": bool,
    "float": bool,
    "zfirst": typing.NotRequired[float | None],
    "zlast": typing.NotRequired[float | None],
    "tfirst": typing.NotRequired[float | None],
    "tlast": typing.NotRequired[float | None],
    "input": InputPathType,
    "prefix": str,
})
From3dParametersTagged = typing.TypedDict('From3dParametersTagged', {
    "@type": typing.Literal["afni/from3d"],
    "verbose": bool,
    "nsize": bool,
    "raw": bool,
    "float": bool,
    "zfirst": typing.NotRequired[float | None],
    "zlast": typing.NotRequired[float | None],
    "tfirst": typing.NotRequired[float | None],
    "tlast": typing.NotRequired[float | None],
    "input": InputPathType,
    "prefix": str,
})


class From3dOutputs(typing.NamedTuple):
    """
    Output object returned when calling `From3dParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def from3d_params(
    input_: InputPathType,
    prefix: str,
    verbose: bool = False,
    nsize: bool = False,
    raw: bool = False,
    float_: bool = False,
    zfirst: float | None = None,
    zlast: float | None = None,
    tfirst: float | None = None,
    tlast: float | None = None,
) -> From3dParametersTagged:
    """
    Build parameters.
    
    Args:
        input_: Read 3D dataset from file 'fname'.
        prefix: Write 2D images using prefix 'rname'.
        verbose: Print out verbose information during the run.
        nsize: Adjust size of 2D data file to be NxN, by padding with zeros,\
            where N is a power of 2.
        raw: Write images in 'raw' format (just the data bytes). There will be\
            no header information saying what the image dimensions are.
        float_: Write images as floats, no matter what they are in the dataset\
            itself.
        zfirst: Set 'num' = number of first z slice to be extracted (default =\
            1).
        zlast: Set 'num' = number of last z slice to be extracted (default =\
            largest).
        tfirst: Set 'num' = number of first time slice to be extracted (default\
            = 1).
        tlast: Set 'num' = number of last time slice to be extracted (default =\
            largest).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/from3d",
        "verbose": verbose,
        "nsize": nsize,
        "raw": raw,
        "float": float_,
        "input": input_,
        "prefix": prefix,
    }
    if zfirst is not None:
        params["zfirst"] = zfirst
    if zlast is not None:
        params["zlast"] = zlast
    if tfirst is not None:
        params["tfirst"] = tfirst
    if tlast is not None:
        params["tlast"] = tlast
    return params


def from3d_cargs(
    params: From3dParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("from3d")
    if params.get("verbose", False):
        cargs.append("-v")
    if params.get("nsize", False):
        cargs.append("-nsize")
    if params.get("raw", False):
        cargs.append("-raw")
    if params.get("float", False):
        cargs.append("-float")
    if params.get("zfirst", None) is not None:
        cargs.extend([
            "-zfirst",
            str(params.get("zfirst", None))
        ])
    if params.get("zlast", None) is not None:
        cargs.extend([
            "-zlast",
            str(params.get("zlast", None))
        ])
    if params.get("tfirst", None) is not None:
        cargs.extend([
            "-tfirst",
            str(params.get("tfirst", None))
        ])
    if params.get("tlast", None) is not None:
        cargs.extend([
            "-tlast",
            str(params.get("tlast", None))
        ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("input", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    return cargs


def from3d_outputs(
    params: From3dParameters,
    execution: Execution,
) -> From3dOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = From3dOutputs(
        root=execution.output_file("."),
    )
    return ret


def from3d_execute(
    params: From3dParameters,
    runner: Runner | None = None,
) -> From3dOutputs:
    """
    from3d
    
    Extract 2D image files from a 3D AFNI dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `From3dOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(FROM3D_METADATA)
    params = execution.params(params)
    cargs = from3d_cargs(params, execution)
    ret = from3d_outputs(params, execution)
    execution.run(cargs)
    return ret


def from3d(
    input_: InputPathType,
    prefix: str,
    verbose: bool = False,
    nsize: bool = False,
    raw: bool = False,
    float_: bool = False,
    zfirst: float | None = None,
    zlast: float | None = None,
    tfirst: float | None = None,
    tlast: float | None = None,
    runner: Runner | None = None,
) -> From3dOutputs:
    """
    from3d
    
    Extract 2D image files from a 3D AFNI dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Read 3D dataset from file 'fname'.
        prefix: Write 2D images using prefix 'rname'.
        verbose: Print out verbose information during the run.
        nsize: Adjust size of 2D data file to be NxN, by padding with zeros,\
            where N is a power of 2.
        raw: Write images in 'raw' format (just the data bytes). There will be\
            no header information saying what the image dimensions are.
        float_: Write images as floats, no matter what they are in the dataset\
            itself.
        zfirst: Set 'num' = number of first z slice to be extracted (default =\
            1).
        zlast: Set 'num' = number of last z slice to be extracted (default =\
            largest).
        tfirst: Set 'num' = number of first time slice to be extracted (default\
            = 1).
        tlast: Set 'num' = number of last time slice to be extracted (default =\
            largest).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `From3dOutputs`).
    """
    params = from3d_params(
        verbose=verbose,
        nsize=nsize,
        raw=raw,
        float_=float_,
        zfirst=zfirst,
        zlast=zlast,
        tfirst=tfirst,
        tlast=tlast,
        input_=input_,
        prefix=prefix,
    )
    return from3d_execute(params, runner)


__all__ = [
    "FROM3D_METADATA",
    "From3dOutputs",
    "from3d",
    "from3d_execute",
    "from3d_params",
]
