# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

GEN_EPI_REVIEW_PY_METADATA = Metadata(
    id="6789f4ee958948df08713dc79f981e6501a16f41.boutiques",
    name="gen_epi_review.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


GenEpiReviewPyParameters = typing.TypedDict('GenEpiReviewPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/gen_epi_review.py"]],
    "datasets": list[str],
    "script_name": typing.NotRequired[str | None],
    "windows": typing.NotRequired[list[str] | None],
    "verbosity": typing.NotRequired[float | None],
    "image_size": typing.NotRequired[list[float] | None],
    "image_xoffset": typing.NotRequired[float | None],
    "image_yoffset": typing.NotRequired[float | None],
    "graph_size": typing.NotRequired[list[float] | None],
    "graph_xoffset": typing.NotRequired[float | None],
    "graph_yoffset": typing.NotRequired[float | None],
})
GenEpiReviewPyParametersTagged = typing.TypedDict('GenEpiReviewPyParametersTagged', {
    "@type": typing.Literal["afni/gen_epi_review.py"],
    "datasets": list[str],
    "script_name": typing.NotRequired[str | None],
    "windows": typing.NotRequired[list[str] | None],
    "verbosity": typing.NotRequired[float | None],
    "image_size": typing.NotRequired[list[float] | None],
    "image_xoffset": typing.NotRequired[float | None],
    "image_yoffset": typing.NotRequired[float | None],
    "graph_size": typing.NotRequired[list[float] | None],
    "graph_xoffset": typing.NotRequired[float | None],
    "graph_yoffset": typing.NotRequired[float | None],
})


class GenEpiReviewPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `GenEpiReviewPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def gen_epi_review_py_params(
    datasets: list[str],
    script_name: str | None = None,
    windows: list[str] | None = None,
    verbosity: float | None = None,
    image_size: list[float] | None = None,
    image_xoffset: float | None = None,
    image_yoffset: float | None = None,
    graph_size: list[float] | None = None,
    graph_xoffset: float | None = None,
    graph_yoffset: float | None = None,
) -> GenEpiReviewPyParametersTagged:
    """
    Build parameters.
    
    Args:
        datasets: Specify input datasets for processing.
        script_name: Specify the name of the generated script.
        windows: Specify the image windows to open.
        verbosity: Specify a verbosity level.
        image_size: Set image dimensions, in pixels.
        image_xoffset: Set the X-offset for the image, in pixels.
        image_yoffset: Set the Y-offset for the image, in pixels.
        graph_size: Set graph dimensions, in pixels.
        graph_xoffset: Set the X-offset for the graph, in pixels.
        graph_yoffset: Set the Y-offset for the graph, in pixels.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/gen_epi_review.py",
        "datasets": datasets,
    }
    if script_name is not None:
        params["script_name"] = script_name
    if windows is not None:
        params["windows"] = windows
    if verbosity is not None:
        params["verbosity"] = verbosity
    if image_size is not None:
        params["image_size"] = image_size
    if image_xoffset is not None:
        params["image_xoffset"] = image_xoffset
    if image_yoffset is not None:
        params["image_yoffset"] = image_yoffset
    if graph_size is not None:
        params["graph_size"] = graph_size
    if graph_xoffset is not None:
        params["graph_xoffset"] = graph_xoffset
    if graph_yoffset is not None:
        params["graph_yoffset"] = graph_yoffset
    return params


def gen_epi_review_py_cargs(
    params: GenEpiReviewPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("gen_epi_review.py")
    cargs.extend([
        "-dsets",
        *params.get("datasets", None)
    ])
    if params.get("script_name", None) is not None:
        cargs.extend([
            "-script",
            params.get("script_name", None)
        ])
    if params.get("windows", None) is not None:
        cargs.extend([
            "-windows",
            *params.get("windows", None)
        ])
    if params.get("verbosity", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbosity", None))
        ])
    if params.get("image_size", None) is not None:
        cargs.extend([
            "-im_size",
            *map(str, params.get("image_size", None))
        ])
    if params.get("image_xoffset", None) is not None:
        cargs.extend([
            "-im_xoff",
            str(params.get("image_xoffset", None))
        ])
    if params.get("image_yoffset", None) is not None:
        cargs.extend([
            "-im_yoff",
            str(params.get("image_yoffset", None))
        ])
    if params.get("graph_size", None) is not None:
        cargs.extend([
            "-gr_size",
            *map(str, params.get("graph_size", None))
        ])
    if params.get("graph_xoffset", None) is not None:
        cargs.extend([
            "-gr_xoff",
            str(params.get("graph_xoffset", None))
        ])
    if params.get("graph_yoffset", None) is not None:
        cargs.extend([
            "-gr_yoff",
            str(params.get("graph_yoffset", None))
        ])
    return cargs


def gen_epi_review_py_outputs(
    params: GenEpiReviewPyParameters,
    execution: Execution,
) -> GenEpiReviewPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = GenEpiReviewPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def gen_epi_review_py_execute(
    params: GenEpiReviewPyParameters,
    runner: Runner | None = None,
) -> GenEpiReviewPyOutputs:
    """
    gen_epi_review.py
    
    Generate an AFNI processing script to review EPI data.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GenEpiReviewPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(GEN_EPI_REVIEW_PY_METADATA)
    params = execution.params(params)
    cargs = gen_epi_review_py_cargs(params, execution)
    ret = gen_epi_review_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def gen_epi_review_py(
    datasets: list[str],
    script_name: str | None = None,
    windows: list[str] | None = None,
    verbosity: float | None = None,
    image_size: list[float] | None = None,
    image_xoffset: float | None = None,
    image_yoffset: float | None = None,
    graph_size: list[float] | None = None,
    graph_xoffset: float | None = None,
    graph_yoffset: float | None = None,
    runner: Runner | None = None,
) -> GenEpiReviewPyOutputs:
    """
    gen_epi_review.py
    
    Generate an AFNI processing script to review EPI data.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        datasets: Specify input datasets for processing.
        script_name: Specify the name of the generated script.
        windows: Specify the image windows to open.
        verbosity: Specify a verbosity level.
        image_size: Set image dimensions, in pixels.
        image_xoffset: Set the X-offset for the image, in pixels.
        image_yoffset: Set the Y-offset for the image, in pixels.
        graph_size: Set graph dimensions, in pixels.
        graph_xoffset: Set the X-offset for the graph, in pixels.
        graph_yoffset: Set the Y-offset for the graph, in pixels.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GenEpiReviewPyOutputs`).
    """
    params = gen_epi_review_py_params(
        datasets=datasets,
        script_name=script_name,
        windows=windows,
        verbosity=verbosity,
        image_size=image_size,
        image_xoffset=image_xoffset,
        image_yoffset=image_yoffset,
        graph_size=graph_size,
        graph_xoffset=graph_xoffset,
        graph_yoffset=graph_yoffset,
    )
    return gen_epi_review_py_execute(params, runner)


__all__ = [
    "GEN_EPI_REVIEW_PY_METADATA",
    "GenEpiReviewPyOutputs",
    "gen_epi_review_py",
    "gen_epi_review_py_execute",
    "gen_epi_review_py_params",
]
