# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

GEN_GROUP_COMMAND_PY_METADATA = Metadata(
    id="a50fced0bad2328ced816377a295b47a238138e1.boutiques",
    name="gen_group_command.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


GenGroupCommandPyParameters = typing.TypedDict('GenGroupCommandPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/gen_group_command.py"]],
    "command_name": str,
    "datasets": list[str],
    "prefix": typing.NotRequired[str | None],
    "set_labels": typing.NotRequired[list[str] | None],
    "subj_prefix": typing.NotRequired[str | None],
    "subj_suffix": typing.NotRequired[str | None],
    "subs_betas": typing.NotRequired[list[str] | None],
    "subs_tstats": typing.NotRequired[list[str] | None],
    "type": typing.NotRequired[str | None],
    "verb": typing.NotRequired[str | None],
    "write_script": typing.NotRequired[str | None],
    "other_options": typing.NotRequired[list[str] | None],
})
GenGroupCommandPyParametersTagged = typing.TypedDict('GenGroupCommandPyParametersTagged', {
    "@type": typing.Literal["afni/gen_group_command.py"],
    "command_name": str,
    "datasets": list[str],
    "prefix": typing.NotRequired[str | None],
    "set_labels": typing.NotRequired[list[str] | None],
    "subj_prefix": typing.NotRequired[str | None],
    "subj_suffix": typing.NotRequired[str | None],
    "subs_betas": typing.NotRequired[list[str] | None],
    "subs_tstats": typing.NotRequired[list[str] | None],
    "type": typing.NotRequired[str | None],
    "verb": typing.NotRequired[str | None],
    "write_script": typing.NotRequired[str | None],
    "other_options": typing.NotRequired[list[str] | None],
})


class GenGroupCommandPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `GenGroupCommandPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_script: OutputPathType | None
    """The generated command script file"""


def gen_group_command_py_params(
    command_name: str,
    datasets: list[str],
    prefix: str | None = None,
    set_labels: list[str] | None = None,
    subj_prefix: str | None = None,
    subj_suffix: str | None = None,
    subs_betas: list[str] | None = None,
    subs_tstats: list[str] | None = None,
    type_: str | None = None,
    verb: str | None = None,
    write_script: str | None = None,
    other_options: list[str] | None = None,
) -> GenGroupCommandPyParametersTagged:
    """
    Build parameters.
    
    Args:
        command_name: Resulting command, such as 3dttest++.
        datasets: List of datasets, can be used multiple times for different\
            groups.
        prefix: Prefix for the output file names.
        set_labels: Labels corresponding to datasets entries.
        subj_prefix: Prefix for subject names.
        subj_suffix: Suffix for subject names.
        subs_betas: Sub-bricks for beta weights.
        subs_tstats: Sub-bricks for t-stats (3dMEMA).
        type_: Specify the type of test to perform.
        verb: Set the verbosity level.
        write_script: Write command script to specified file name.
        other_options: List of options to pass along to result.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/gen_group_command.py",
        "command_name": command_name,
        "datasets": datasets,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if set_labels is not None:
        params["set_labels"] = set_labels
    if subj_prefix is not None:
        params["subj_prefix"] = subj_prefix
    if subj_suffix is not None:
        params["subj_suffix"] = subj_suffix
    if subs_betas is not None:
        params["subs_betas"] = subs_betas
    if subs_tstats is not None:
        params["subs_tstats"] = subs_tstats
    if type_ is not None:
        params["type"] = type_
    if verb is not None:
        params["verb"] = verb
    if write_script is not None:
        params["write_script"] = write_script
    if other_options is not None:
        params["other_options"] = other_options
    return params


def gen_group_command_py_cargs(
    params: GenGroupCommandPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("gen_group_command.py")
    cargs.extend([
        "-command",
        params.get("command_name", None)
    ])
    cargs.extend([
        "-dsets",
        *params.get("datasets", None)
    ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("set_labels", None) is not None:
        cargs.extend([
            "-set_labels",
            *params.get("set_labels", None)
        ])
    if params.get("subj_prefix", None) is not None:
        cargs.extend([
            "-subj_prefix",
            params.get("subj_prefix", None)
        ])
    if params.get("subj_suffix", None) is not None:
        cargs.extend([
            "-subj_suffix",
            params.get("subj_suffix", None)
        ])
    if params.get("subs_betas", None) is not None:
        cargs.extend([
            "-subs_betas",
            *params.get("subs_betas", None)
        ])
    if params.get("subs_tstats", None) is not None:
        cargs.extend([
            "-subs_tstats",
            *params.get("subs_tstats", None)
        ])
    if params.get("type", None) is not None:
        cargs.extend([
            "-type",
            params.get("type", None)
        ])
    if params.get("verb", None) is not None:
        cargs.extend([
            "-verb",
            params.get("verb", None)
        ])
    if params.get("write_script", None) is not None:
        cargs.extend([
            "-write_script",
            params.get("write_script", None)
        ])
    if params.get("other_options", None) is not None:
        cargs.extend([
            "-options",
            *params.get("other_options", None)
        ])
    return cargs


def gen_group_command_py_outputs(
    params: GenGroupCommandPyParameters,
    execution: Execution,
) -> GenGroupCommandPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = GenGroupCommandPyOutputs(
        root=execution.output_file("."),
        output_script=execution.output_file(params.get("write_script", None)) if (params.get("write_script") is not None) else None,
    )
    return ret


def gen_group_command_py_execute(
    params: GenGroupCommandPyParameters,
    runner: Runner | None = None,
) -> GenGroupCommandPyOutputs:
    """
    gen_group_command.py
    
    Generate group analysis command scripts by parsing wildcard-based lists of
    input datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GenGroupCommandPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(GEN_GROUP_COMMAND_PY_METADATA)
    params = execution.params(params)
    cargs = gen_group_command_py_cargs(params, execution)
    ret = gen_group_command_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def gen_group_command_py(
    command_name: str,
    datasets: list[str],
    prefix: str | None = None,
    set_labels: list[str] | None = None,
    subj_prefix: str | None = None,
    subj_suffix: str | None = None,
    subs_betas: list[str] | None = None,
    subs_tstats: list[str] | None = None,
    type_: str | None = None,
    verb: str | None = None,
    write_script: str | None = None,
    other_options: list[str] | None = None,
    runner: Runner | None = None,
) -> GenGroupCommandPyOutputs:
    """
    gen_group_command.py
    
    Generate group analysis command scripts by parsing wildcard-based lists of
    input datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        command_name: Resulting command, such as 3dttest++.
        datasets: List of datasets, can be used multiple times for different\
            groups.
        prefix: Prefix for the output file names.
        set_labels: Labels corresponding to datasets entries.
        subj_prefix: Prefix for subject names.
        subj_suffix: Suffix for subject names.
        subs_betas: Sub-bricks for beta weights.
        subs_tstats: Sub-bricks for t-stats (3dMEMA).
        type_: Specify the type of test to perform.
        verb: Set the verbosity level.
        write_script: Write command script to specified file name.
        other_options: List of options to pass along to result.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GenGroupCommandPyOutputs`).
    """
    params = gen_group_command_py_params(
        command_name=command_name,
        datasets=datasets,
        prefix=prefix,
        set_labels=set_labels,
        subj_prefix=subj_prefix,
        subj_suffix=subj_suffix,
        subs_betas=subs_betas,
        subs_tstats=subs_tstats,
        type_=type_,
        verb=verb,
        write_script=write_script,
        other_options=other_options,
    )
    return gen_group_command_py_execute(params, runner)


__all__ = [
    "GEN_GROUP_COMMAND_PY_METADATA",
    "GenGroupCommandPyOutputs",
    "gen_group_command_py",
    "gen_group_command_py_execute",
    "gen_group_command_py_params",
]
