# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

GEN_SS_REVIEW_TABLE_PY_METADATA = Metadata(
    id="86e0a4a60a7307fdbdac8e970d36b74509c7924f.boutiques",
    name="gen_ss_review_table.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


GenSsReviewTablePyParameters = typing.TypedDict('GenSsReviewTablePyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/gen_ss_review_table.py"]],
    "infiles": list[InputPathType],
    "write_table": typing.NotRequired[InputPathType | None],
    "write_outliers": typing.NotRequired[InputPathType | None],
    "overwrite": bool,
    "empty_is_outlier": bool,
    "outlier_sep": typing.NotRequired[str | None],
    "separator": typing.NotRequired[str | None],
    "showlabs": bool,
    "show_infiles": bool,
    "show_keepers": bool,
    "report_outliers": typing.NotRequired[list[str] | None],
    "report_outliers_fill_style": typing.NotRequired[str | None],
    "show_missing": bool,
    "verbosity": typing.NotRequired[int | None],
})
GenSsReviewTablePyParametersTagged = typing.TypedDict('GenSsReviewTablePyParametersTagged', {
    "@type": typing.Literal["afni/gen_ss_review_table.py"],
    "infiles": list[InputPathType],
    "write_table": typing.NotRequired[InputPathType | None],
    "write_outliers": typing.NotRequired[InputPathType | None],
    "overwrite": bool,
    "empty_is_outlier": bool,
    "outlier_sep": typing.NotRequired[str | None],
    "separator": typing.NotRequired[str | None],
    "showlabs": bool,
    "show_infiles": bool,
    "show_keepers": bool,
    "report_outliers": typing.NotRequired[list[str] | None],
    "report_outliers_fill_style": typing.NotRequired[str | None],
    "show_missing": bool,
    "verbosity": typing.NotRequired[int | None],
})


class GenSsReviewTablePyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `GenSsReviewTablePyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_table: OutputPathType | None
    """Final table output file"""
    output_outliers: OutputPathType | None
    """Outliers table output file"""


def gen_ss_review_table_py_params(
    infiles: list[InputPathType],
    write_table: InputPathType | None = None,
    write_outliers: InputPathType | None = None,
    overwrite: bool = False,
    empty_is_outlier: bool = False,
    outlier_sep: str | None = None,
    separator: str | None = None,
    showlabs: bool = False,
    show_infiles: bool = False,
    show_keepers: bool = False,
    report_outliers: list[str] | None = None,
    report_outliers_fill_style: str | None = None,
    show_missing: bool = False,
    verbosity: int | None = None,
) -> GenSsReviewTablePyParametersTagged:
    """
    Build parameters.
    
    Args:
        infiles: Input ss_review_basic output text files to process.
        write_table: Write final table to the given file.
        write_outliers: Write outlier table to the given file.
        overwrite: Overwrite the output -write_table, if it exists.
        empty_is_outlier: Treat empty tests as outliers.
        outlier_sep: Use SEP for the outlier table separator.
        separator: Use SEP for the label/vals separator (default = ':').
        showlabs: Display counts of all labels found, with parents.
        show_infiles: Include input files in reviewtable result.
        show_keepers: Show a table of subjects kept rather than dropped.
        report_outliers: Report outliers where the comparison holds.
        report_outliers_fill_style: How to fill non-outliers in the table.
        show_missing: Display all missing keys.
        verbosity: Verbosity level.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/gen_ss_review_table.py",
        "infiles": infiles,
        "overwrite": overwrite,
        "empty_is_outlier": empty_is_outlier,
        "showlabs": showlabs,
        "show_infiles": show_infiles,
        "show_keepers": show_keepers,
        "show_missing": show_missing,
    }
    if write_table is not None:
        params["write_table"] = write_table
    if write_outliers is not None:
        params["write_outliers"] = write_outliers
    if outlier_sep is not None:
        params["outlier_sep"] = outlier_sep
    if separator is not None:
        params["separator"] = separator
    if report_outliers is not None:
        params["report_outliers"] = report_outliers
    if report_outliers_fill_style is not None:
        params["report_outliers_fill_style"] = report_outliers_fill_style
    if verbosity is not None:
        params["verbosity"] = verbosity
    return params


def gen_ss_review_table_py_cargs(
    params: GenSsReviewTablePyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("gen_ss_review_table.py")
    cargs.extend([execution.input_file(f) for f in params.get("infiles", None)])
    if params.get("write_table", None) is not None:
        cargs.extend([
            "-write_table",
            execution.input_file(params.get("write_table", None))
        ])
    if params.get("write_outliers", None) is not None:
        cargs.extend([
            "-write_outliers",
            execution.input_file(params.get("write_outliers", None))
        ])
    if params.get("overwrite", False):
        cargs.append("-overwrite")
    if params.get("empty_is_outlier", False):
        cargs.append("-empty_is_outlier")
    if params.get("outlier_sep", None) is not None:
        cargs.extend([
            "-outlier_sep",
            params.get("outlier_sep", None)
        ])
    if params.get("separator", None) is not None:
        cargs.extend([
            "-separator",
            params.get("separator", None)
        ])
    if params.get("showlabs", False):
        cargs.append("-showlabs")
    if params.get("show_infiles", False):
        cargs.append("-show_infiles")
    if params.get("show_keepers", False):
        cargs.append("-show_keepers")
    if params.get("report_outliers", None) is not None:
        cargs.extend([
            "-report_outliers",
            *params.get("report_outliers", None)
        ])
    if params.get("report_outliers_fill_style", None) is not None:
        cargs.extend([
            "-report_outliers_fill_style",
            params.get("report_outliers_fill_style", None)
        ])
    if params.get("show_missing", False):
        cargs.append("-show_missing")
    if params.get("verbosity", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbosity", None))
        ])
    return cargs


def gen_ss_review_table_py_outputs(
    params: GenSsReviewTablePyParameters,
    execution: Execution,
) -> GenSsReviewTablePyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = GenSsReviewTablePyOutputs(
        root=execution.output_file("."),
        output_table=execution.output_file(pathlib.Path(params.get("write_table", None)).name) if (params.get("write_table") is not None) else None,
        output_outliers=execution.output_file(pathlib.Path(params.get("write_outliers", None)).name) if (params.get("write_outliers") is not None) else None,
    )
    return ret


def gen_ss_review_table_py_execute(
    params: GenSsReviewTablePyParameters,
    runner: Runner | None = None,
) -> GenSsReviewTablePyOutputs:
    """
    gen_ss_review_table.py
    
    Generate a table from ss_review_basic output files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GenSsReviewTablePyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(GEN_SS_REVIEW_TABLE_PY_METADATA)
    params = execution.params(params)
    cargs = gen_ss_review_table_py_cargs(params, execution)
    ret = gen_ss_review_table_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def gen_ss_review_table_py(
    infiles: list[InputPathType],
    write_table: InputPathType | None = None,
    write_outliers: InputPathType | None = None,
    overwrite: bool = False,
    empty_is_outlier: bool = False,
    outlier_sep: str | None = None,
    separator: str | None = None,
    showlabs: bool = False,
    show_infiles: bool = False,
    show_keepers: bool = False,
    report_outliers: list[str] | None = None,
    report_outliers_fill_style: str | None = None,
    show_missing: bool = False,
    verbosity: int | None = None,
    runner: Runner | None = None,
) -> GenSsReviewTablePyOutputs:
    """
    gen_ss_review_table.py
    
    Generate a table from ss_review_basic output files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infiles: Input ss_review_basic output text files to process.
        write_table: Write final table to the given file.
        write_outliers: Write outlier table to the given file.
        overwrite: Overwrite the output -write_table, if it exists.
        empty_is_outlier: Treat empty tests as outliers.
        outlier_sep: Use SEP for the outlier table separator.
        separator: Use SEP for the label/vals separator (default = ':').
        showlabs: Display counts of all labels found, with parents.
        show_infiles: Include input files in reviewtable result.
        show_keepers: Show a table of subjects kept rather than dropped.
        report_outliers: Report outliers where the comparison holds.
        report_outliers_fill_style: How to fill non-outliers in the table.
        show_missing: Display all missing keys.
        verbosity: Verbosity level.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GenSsReviewTablePyOutputs`).
    """
    params = gen_ss_review_table_py_params(
        infiles=infiles,
        write_table=write_table,
        write_outliers=write_outliers,
        overwrite=overwrite,
        empty_is_outlier=empty_is_outlier,
        outlier_sep=outlier_sep,
        separator=separator,
        showlabs=showlabs,
        show_infiles=show_infiles,
        show_keepers=show_keepers,
        report_outliers=report_outliers,
        report_outliers_fill_style=report_outliers_fill_style,
        show_missing=show_missing,
        verbosity=verbosity,
    )
    return gen_ss_review_table_py_execute(params, runner)


__all__ = [
    "GEN_SS_REVIEW_TABLE_PY_METADATA",
    "GenSsReviewTablePyOutputs",
    "gen_ss_review_table_py",
    "gen_ss_review_table_py_execute",
    "gen_ss_review_table_py_params",
]
