# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

GET_AFNI_MODEL_PRF_METADATA = Metadata(
    id="ebc3a97876ea91513851294dd4aef0b244cab5d4.boutiques",
    name="get_afni_model_PRF",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


GetAfniModelPrfParameters = typing.TypedDict('GetAfniModelPrfParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/get_afni_model_PRF"]],
    "amplitude": float,
    "x_coord": float,
    "y_coord": float,
    "sigma": float,
})
GetAfniModelPrfParametersTagged = typing.TypedDict('GetAfniModelPrfParametersTagged', {
    "@type": typing.Literal["afni/get_afni_model_PRF"],
    "amplitude": float,
    "x_coord": float,
    "y_coord": float,
    "sigma": float,
})


class GetAfniModelPrfOutputs(typing.NamedTuple):
    """
    Output object returned when calling `GetAfniModelPrfParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def get_afni_model_prf_params(
    amplitude: float,
    x_coord: float,
    y_coord: float,
    sigma: float,
) -> GetAfniModelPrfParametersTagged:
    """
    Build parameters.
    
    Args:
        amplitude: Amplitude for the AFNI model.
        x_coord: X-coordinate for the AFNI model.
        y_coord: Y-coordinate for the AFNI model.
        sigma: Sigma value for the AFNI model.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/get_afni_model_PRF",
        "amplitude": amplitude,
        "x_coord": x_coord,
        "y_coord": y_coord,
        "sigma": sigma,
    }
    return params


def get_afni_model_prf_cargs(
    params: GetAfniModelPrfParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("get_afni_model_PRF")
    cargs.append(str(params.get("amplitude", None)))
    cargs.append(str(params.get("x_coord", None)))
    cargs.append(str(params.get("y_coord", None)))
    cargs.append(str(params.get("sigma", None)))
    return cargs


def get_afni_model_prf_outputs(
    params: GetAfniModelPrfParameters,
    execution: Execution,
) -> GetAfniModelPrfOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = GetAfniModelPrfOutputs(
        root=execution.output_file("."),
    )
    return ret


def get_afni_model_prf_execute(
    params: GetAfniModelPrfParameters,
    runner: Runner | None = None,
) -> GetAfniModelPrfOutputs:
    """
    get_afni_model_PRF
    
    A tool to get AFNI model parameters assuming a PRF framework.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GetAfniModelPrfOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(GET_AFNI_MODEL_PRF_METADATA)
    params = execution.params(params)
    cargs = get_afni_model_prf_cargs(params, execution)
    ret = get_afni_model_prf_outputs(params, execution)
    execution.run(cargs)
    return ret


def get_afni_model_prf(
    amplitude: float,
    x_coord: float,
    y_coord: float,
    sigma: float,
    runner: Runner | None = None,
) -> GetAfniModelPrfOutputs:
    """
    get_afni_model_PRF
    
    A tool to get AFNI model parameters assuming a PRF framework.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        amplitude: Amplitude for the AFNI model.
        x_coord: X-coordinate for the AFNI model.
        y_coord: Y-coordinate for the AFNI model.
        sigma: Sigma value for the AFNI model.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GetAfniModelPrfOutputs`).
    """
    params = get_afni_model_prf_params(
        amplitude=amplitude,
        x_coord=x_coord,
        y_coord=y_coord,
        sigma=sigma,
    )
    return get_afni_model_prf_execute(params, runner)


__all__ = [
    "GET_AFNI_MODEL_PRF_METADATA",
    "GetAfniModelPrfOutputs",
    "get_afni_model_prf",
    "get_afni_model_prf_execute",
    "get_afni_model_prf_params",
]
