# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

GET_AFNI_MODEL_PRF_6_BAD_METADATA = Metadata(
    id="333b33932df510597bb63337686868fddcc93a33.boutiques",
    name="get_afni_model_PRF_6_BAD",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


GetAfniModelPrf6BadParameters = typing.TypedDict('GetAfniModelPrf6BadParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/get_afni_model_PRF_6_BAD"]],
    "amplitude": float,
    "x_coord": float,
    "y_coord": float,
    "sigma": float,
    "sigrat": float,
    "theta": float,
})
GetAfniModelPrf6BadParametersTagged = typing.TypedDict('GetAfniModelPrf6BadParametersTagged', {
    "@type": typing.Literal["afni/get_afni_model_PRF_6_BAD"],
    "amplitude": float,
    "x_coord": float,
    "y_coord": float,
    "sigma": float,
    "sigrat": float,
    "theta": float,
})


class GetAfniModelPrf6BadOutputs(typing.NamedTuple):
    """
    Output object returned when calling `GetAfniModelPrf6BadParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def get_afni_model_prf_6_bad_params(
    amplitude: float,
    x_coord: float,
    y_coord: float,
    sigma: float,
    sigrat: float,
    theta: float,
) -> GetAfniModelPrf6BadParametersTagged:
    """
    Build parameters.
    
    Args:
        amplitude: Amplitude parameter A.
        x_coord: X coordinate parameter x.
        y_coord: Y coordinate parameter y.
        sigma: Sigma parameter sigma.
        sigrat: Sigma ratio parameter sigrat.
        theta: Theta parameter theta (in radians).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/get_afni_model_PRF_6_BAD",
        "amplitude": amplitude,
        "x_coord": x_coord,
        "y_coord": y_coord,
        "sigma": sigma,
        "sigrat": sigrat,
        "theta": theta,
    }
    return params


def get_afni_model_prf_6_bad_cargs(
    params: GetAfniModelPrf6BadParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("get_afni_model_PRF_6_BAD")
    cargs.append(str(params.get("amplitude", None)))
    cargs.append(str(params.get("x_coord", None)))
    cargs.append(str(params.get("y_coord", None)))
    cargs.append(str(params.get("sigma", None)))
    cargs.append(str(params.get("sigrat", None)))
    cargs.append(str(params.get("theta", None)))
    return cargs


def get_afni_model_prf_6_bad_outputs(
    params: GetAfniModelPrf6BadParameters,
    execution: Execution,
) -> GetAfniModelPrf6BadOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = GetAfniModelPrf6BadOutputs(
        root=execution.output_file("."),
    )
    return ret


def get_afni_model_prf_6_bad_execute(
    params: GetAfniModelPrf6BadParameters,
    runner: Runner | None = None,
) -> GetAfniModelPrf6BadOutputs:
    """
    get_afni_model_PRF_6_BAD
    
    Command line tool for obtaining AFNI pRF model.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GetAfniModelPrf6BadOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(GET_AFNI_MODEL_PRF_6_BAD_METADATA)
    params = execution.params(params)
    cargs = get_afni_model_prf_6_bad_cargs(params, execution)
    ret = get_afni_model_prf_6_bad_outputs(params, execution)
    execution.run(cargs)
    return ret


def get_afni_model_prf_6_bad(
    amplitude: float,
    x_coord: float,
    y_coord: float,
    sigma: float,
    sigrat: float,
    theta: float,
    runner: Runner | None = None,
) -> GetAfniModelPrf6BadOutputs:
    """
    get_afni_model_PRF_6_BAD
    
    Command line tool for obtaining AFNI pRF model.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        amplitude: Amplitude parameter A.
        x_coord: X coordinate parameter x.
        y_coord: Y coordinate parameter y.
        sigma: Sigma parameter sigma.
        sigrat: Sigma ratio parameter sigrat.
        theta: Theta parameter theta (in radians).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GetAfniModelPrf6BadOutputs`).
    """
    params = get_afni_model_prf_6_bad_params(
        amplitude=amplitude,
        x_coord=x_coord,
        y_coord=y_coord,
        sigma=sigma,
        sigrat=sigrat,
        theta=theta,
    )
    return get_afni_model_prf_6_bad_execute(params, runner)


__all__ = [
    "GET_AFNI_MODEL_PRF_6_BAD_METADATA",
    "GetAfniModelPrf6BadOutputs",
    "get_afni_model_prf_6_bad",
    "get_afni_model_prf_6_bad_execute",
    "get_afni_model_prf_6_bad_params",
]
