# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

GLTSYMTEST_METADATA = Metadata(
    id="a1f6825f5f2c006c71df619ba8e2a9e407a6dc79.boutiques",
    name="GLTsymtest",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


GltsymtestParameters = typing.TypedDict('GltsymtestParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/GLTsymtest"]],
    "badonly": bool,
    "varlist": str,
    "expr": list[str],
})
GltsymtestParametersTagged = typing.TypedDict('GltsymtestParametersTagged', {
    "@type": typing.Literal["afni/GLTsymtest"],
    "badonly": bool,
    "varlist": str,
    "expr": list[str],
})


class GltsymtestOutputs(typing.NamedTuple):
    """
    Output object returned when calling `GltsymtestParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def gltsymtest_params(
    varlist: str,
    expr: list[str],
    badonly: bool = False,
) -> GltsymtestParametersTagged:
    """
    Build parameters.
    
    Args:
        varlist: A list of allowed variable names in the expression, separated\
            by commas, semicolons, and/or spaces.
        expr: GLT symbolic expression(s), enclosed in quotes.
        badonly: A flag to only output BAD messages rather than all messages.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/GLTsymtest",
        "badonly": badonly,
        "varlist": varlist,
        "expr": expr,
    }
    return params


def gltsymtest_cargs(
    params: GltsymtestParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("GLTsymtest")
    if params.get("badonly", False):
        cargs.append("-badonly")
    cargs.append(params.get("varlist", None))
    cargs.extend(params.get("expr", None))
    return cargs


def gltsymtest_outputs(
    params: GltsymtestParameters,
    execution: Execution,
) -> GltsymtestOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = GltsymtestOutputs(
        root=execution.output_file("."),
    )
    return ret


def gltsymtest_execute(
    params: GltsymtestParameters,
    runner: Runner | None = None,
) -> GltsymtestOutputs:
    """
    GLTsymtest
    
    A tool to test the validity of '-gltsym' strings for use with 3dDeconvolve
    or 3dREMLfit.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GltsymtestOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(GLTSYMTEST_METADATA)
    params = execution.params(params)
    cargs = gltsymtest_cargs(params, execution)
    ret = gltsymtest_outputs(params, execution)
    execution.run(cargs)
    return ret


def gltsymtest(
    varlist: str,
    expr: list[str],
    badonly: bool = False,
    runner: Runner | None = None,
) -> GltsymtestOutputs:
    """
    GLTsymtest
    
    A tool to test the validity of '-gltsym' strings for use with 3dDeconvolve
    or 3dREMLfit.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        varlist: A list of allowed variable names in the expression, separated\
            by commas, semicolons, and/or spaces.
        expr: GLT symbolic expression(s), enclosed in quotes.
        badonly: A flag to only output BAD messages rather than all messages.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `GltsymtestOutputs`).
    """
    params = gltsymtest_params(
        badonly=badonly,
        varlist=varlist,
        expr=expr,
    )
    return gltsymtest_execute(params, runner)


__all__ = [
    "GLTSYMTEST_METADATA",
    "GltsymtestOutputs",
    "gltsymtest",
    "gltsymtest_execute",
    "gltsymtest_params",
]
