# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

HELP_FORMAT_METADATA = Metadata(
    id="64e26d5d8479285f3b0f689c7f6ac596a8fab073.boutiques",
    name="help_format",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


HelpFormatParameters = typing.TypedDict('HelpFormatParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/help_format"]],
    "stdin": str,
})
HelpFormatParametersTagged = typing.TypedDict('HelpFormatParametersTagged', {
    "@type": typing.Literal["afni/help_format"],
    "stdin": str,
})


class HelpFormatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `HelpFormatParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    formatted_output: OutputPathType
    """The formatted text with hyperlinks"""


def help_format_params(
    stdin: str,
) -> HelpFormatParametersTagged:
    """
    Build parameters.
    
    Args:
        stdin: Standard input text to be formatted.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/help_format",
        "stdin": stdin,
    }
    return params


def help_format_cargs(
    params: HelpFormatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("help_format")
    cargs.append(params.get("stdin", None))
    return cargs


def help_format_outputs(
    params: HelpFormatParameters,
    execution: Execution,
) -> HelpFormatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = HelpFormatOutputs(
        root=execution.output_file("."),
        formatted_output=execution.output_file("formatted_output.html"),
    )
    return ret


def help_format_execute(
    params: HelpFormatParameters,
    runner: Runner | None = None,
) -> HelpFormatOutputs:
    """
    help_format
    
    Formats text by converting URLs into HTML hyperlinks.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `HelpFormatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(HELP_FORMAT_METADATA)
    params = execution.params(params)
    cargs = help_format_cargs(params, execution)
    ret = help_format_outputs(params, execution)
    execution.run(cargs)
    return ret


def help_format(
    stdin: str,
    runner: Runner | None = None,
) -> HelpFormatOutputs:
    """
    help_format
    
    Formats text by converting URLs into HTML hyperlinks.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        stdin: Standard input text to be formatted.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `HelpFormatOutputs`).
    """
    params = help_format_params(
        stdin=stdin,
    )
    return help_format_execute(params, runner)


__all__ = [
    "HELP_FORMAT_METADATA",
    "HelpFormatOutputs",
    "help_format",
    "help_format_execute",
    "help_format_params",
]
