# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

IMAGES_EQUAL_METADATA = Metadata(
    id="56cce9d5304404daa9e4fb664f00f690b28c9d64.boutiques",
    name="images_equal",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ImagesEqualParameters = typing.TypedDict('ImagesEqualParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/images_equal"]],
    "file_a": InputPathType,
    "file_b": InputPathType,
    "all_flag": bool,
})
ImagesEqualParametersTagged = typing.TypedDict('ImagesEqualParametersTagged', {
    "@type": typing.Literal["afni/images_equal"],
    "file_a": InputPathType,
    "file_b": InputPathType,
    "all_flag": bool,
})


class ImagesEqualOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ImagesEqualParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    comparison_result: OutputPathType
    """Result of the image comparison: 1 if equal, 0 if not."""


def images_equal_params(
    file_a: InputPathType,
    file_b: InputPathType,
    all_flag: bool = False,
) -> ImagesEqualParametersTagged:
    """
    Build parameters.
    
    Args:
        file_a: First image file to compare.
        file_b: Second image file to compare.
        all_flag: Compare all images in the files; all must be equal for exit\
            status to be 1.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/images_equal",
        "file_a": file_a,
        "file_b": file_b,
        "all_flag": all_flag,
    }
    return params


def images_equal_cargs(
    params: ImagesEqualParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("images_equal")
    cargs.append(execution.input_file(params.get("file_a", None)))
    cargs.append(execution.input_file(params.get("file_b", None)))
    if params.get("all_flag", False):
        cargs.append("-all")
    return cargs


def images_equal_outputs(
    params: ImagesEqualParameters,
    execution: Execution,
) -> ImagesEqualOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ImagesEqualOutputs(
        root=execution.output_file("."),
        comparison_result=execution.output_file("comparison_result.txt"),
    )
    return ret


def images_equal_execute(
    params: ImagesEqualParameters,
    runner: Runner | None = None,
) -> ImagesEqualOutputs:
    """
    images_equal
    
    A simple program to test if two 2D images are identical.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImagesEqualOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(IMAGES_EQUAL_METADATA)
    params = execution.params(params)
    cargs = images_equal_cargs(params, execution)
    ret = images_equal_outputs(params, execution)
    execution.run(cargs)
    return ret


def images_equal(
    file_a: InputPathType,
    file_b: InputPathType,
    all_flag: bool = False,
    runner: Runner | None = None,
) -> ImagesEqualOutputs:
    """
    images_equal
    
    A simple program to test if two 2D images are identical.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        file_a: First image file to compare.
        file_b: Second image file to compare.
        all_flag: Compare all images in the files; all must be equal for exit\
            status to be 1.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImagesEqualOutputs`).
    """
    params = images_equal_params(
        file_a=file_a,
        file_b=file_b,
        all_flag=all_flag,
    )
    return images_equal_execute(params, runner)


__all__ = [
    "IMAGES_EQUAL_METADATA",
    "ImagesEqualOutputs",
    "images_equal",
    "images_equal_execute",
    "images_equal_params",
]
