# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

IMCUTUP_METADATA = Metadata(
    id="530ef006832ca6e8fa5ddd054e9840a9b18311a2.boutiques",
    name="imcutup",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ImcutupParameters = typing.TypedDict('ImcutupParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/imcutup"]],
    "prefix": typing.NotRequired[str | None],
    "xynum": bool,
    "yxnum": bool,
    "xynum_format": bool,
    "yxnum_format": bool,
    "nx": int,
    "ny": int,
    "input_file": InputPathType,
})
ImcutupParametersTagged = typing.TypedDict('ImcutupParametersTagged', {
    "@type": typing.Literal["afni/imcutup"],
    "prefix": typing.NotRequired[str | None],
    "xynum": bool,
    "yxnum": bool,
    "xynum_format": bool,
    "yxnum_format": bool,
    "nx": int,
    "ny": int,
    "input_file": InputPathType,
})


class ImcutupOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ImcutupParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def imcutup_params(
    nx: int,
    ny: int,
    input_file: InputPathType,
    prefix: str | None = None,
    xynum: bool = False,
    yxnum: bool = False,
    xynum_format: bool = False,
    yxnum_format: bool = False,
) -> ImcutupParametersTagged:
    """
    Build parameters.
    
    Args:
        nx: Number of pixels along the x-dimension for the smaller images.
        ny: Number of pixels along the y-dimension for the smaller images.
        input_file: Input image filename. Must be a single 2D image.
        prefix: Prefix the output files with the provided string.
        xynum: Number the output images in x-first, then y (default behavior).
        yxnum: Number the output images in y-first, then x.
        xynum_format: 2D numbering in x.y format.
        yxnum_format: 2D numbering in y.x format.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/imcutup",
        "xynum": xynum,
        "yxnum": yxnum,
        "xynum_format": xynum_format,
        "yxnum_format": yxnum_format,
        "nx": nx,
        "ny": ny,
        "input_file": input_file,
    }
    if prefix is not None:
        params["prefix"] = prefix
    return params


def imcutup_cargs(
    params: ImcutupParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("imcutup")
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("xynum", False):
        cargs.append("-xynum")
    if params.get("yxnum", False):
        cargs.append("-yxnum")
    if params.get("xynum_format", False):
        cargs.append("-x.ynum")
    if params.get("yxnum_format", False):
        cargs.append("-y.xnum")
    cargs.append(str(params.get("nx", None)))
    cargs.append(str(params.get("ny", None)))
    cargs.append(execution.input_file(params.get("input_file", None)))
    return cargs


def imcutup_outputs(
    params: ImcutupParameters,
    execution: Execution,
) -> ImcutupOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ImcutupOutputs(
        root=execution.output_file("."),
    )
    return ret


def imcutup_execute(
    params: ImcutupParameters,
    runner: Runner | None = None,
) -> ImcutupOutputs:
    """
    imcutup
    
    Breaks up larger images into smaller image files of user-defined size.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImcutupOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(IMCUTUP_METADATA)
    params = execution.params(params)
    cargs = imcutup_cargs(params, execution)
    ret = imcutup_outputs(params, execution)
    execution.run(cargs)
    return ret


def imcutup(
    nx: int,
    ny: int,
    input_file: InputPathType,
    prefix: str | None = None,
    xynum: bool = False,
    yxnum: bool = False,
    xynum_format: bool = False,
    yxnum_format: bool = False,
    runner: Runner | None = None,
) -> ImcutupOutputs:
    """
    imcutup
    
    Breaks up larger images into smaller image files of user-defined size.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        nx: Number of pixels along the x-dimension for the smaller images.
        ny: Number of pixels along the y-dimension for the smaller images.
        input_file: Input image filename. Must be a single 2D image.
        prefix: Prefix the output files with the provided string.
        xynum: Number the output images in x-first, then y (default behavior).
        yxnum: Number the output images in y-first, then x.
        xynum_format: 2D numbering in x.y format.
        yxnum_format: 2D numbering in y.x format.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImcutupOutputs`).
    """
    params = imcutup_params(
        prefix=prefix,
        xynum=xynum,
        yxnum=yxnum,
        xynum_format=xynum_format,
        yxnum_format=yxnum_format,
        nx=nx,
        ny=ny,
        input_file=input_file,
    )
    return imcutup_execute(params, runner)


__all__ = [
    "IMCUTUP_METADATA",
    "ImcutupOutputs",
    "imcutup",
    "imcutup_execute",
    "imcutup_params",
]
