# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

IMMASK_METADATA = Metadata(
    id="57311f15962ed9c7aa9e6d43abb977925968463e.boutiques",
    name="immask",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ImmaskParameters = typing.TypedDict('ImmaskParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/immask"]],
    "threshold": typing.NotRequired[float | None],
    "mask_image": typing.NotRequired[InputPathType | None],
    "positive_only": bool,
    "input_image": InputPathType,
    "output_image": str,
})
ImmaskParametersTagged = typing.TypedDict('ImmaskParametersTagged', {
    "@type": typing.Literal["afni/immask"],
    "threshold": typing.NotRequired[float | None],
    "mask_image": typing.NotRequired[InputPathType | None],
    "positive_only": bool,
    "input_image": InputPathType,
    "output_image": str,
})


class ImmaskOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ImmaskParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Masked output image"""


def immask_params(
    input_image: InputPathType,
    output_image: str,
    threshold: float | None = None,
    mask_image: InputPathType | None = None,
    positive_only: bool = False,
) -> ImmaskParametersTagged:
    """
    Build parameters.
    
    Args:
        input_image: Input image to be masked.
        output_image: Output image after masking.
        threshold: Threshold value; all pixels with absolute value below this\
            will be set to zero in the output image.
        mask_image: Mask image; only locations that are nonzero in the mask\
            image will be nonzero in the output image.
        positive_only: Use only positive pixels from input image.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/immask",
        "positive_only": positive_only,
        "input_image": input_image,
        "output_image": output_image,
    }
    if threshold is not None:
        params["threshold"] = threshold
    if mask_image is not None:
        params["mask_image"] = mask_image
    return params


def immask_cargs(
    params: ImmaskParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("immask")
    if params.get("threshold", None) is not None:
        cargs.extend([
            "-thresh",
            str(params.get("threshold", None))
        ])
    if params.get("mask_image", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_image", None))
        ])
    if params.get("positive_only", False):
        cargs.append("-pos")
    cargs.append(execution.input_file(params.get("input_image", None)))
    cargs.append(params.get("output_image", None))
    return cargs


def immask_outputs(
    params: ImmaskParameters,
    execution: Execution,
) -> ImmaskOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ImmaskOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_image", None)),
    )
    return ret


def immask_execute(
    params: ImmaskParameters,
    runner: Runner | None = None,
) -> ImmaskOutputs:
    """
    immask
    
    Masks the input image based on specified criteria and produces the output
    image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImmaskOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(IMMASK_METADATA)
    params = execution.params(params)
    cargs = immask_cargs(params, execution)
    ret = immask_outputs(params, execution)
    execution.run(cargs)
    return ret


def immask(
    input_image: InputPathType,
    output_image: str,
    threshold: float | None = None,
    mask_image: InputPathType | None = None,
    positive_only: bool = False,
    runner: Runner | None = None,
) -> ImmaskOutputs:
    """
    immask
    
    Masks the input image based on specified criteria and produces the output
    image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_image: Input image to be masked.
        output_image: Output image after masking.
        threshold: Threshold value; all pixels with absolute value below this\
            will be set to zero in the output image.
        mask_image: Mask image; only locations that are nonzero in the mask\
            image will be nonzero in the output image.
        positive_only: Use only positive pixels from input image.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImmaskOutputs`).
    """
    params = immask_params(
        threshold=threshold,
        mask_image=mask_image,
        positive_only=positive_only,
        input_image=input_image,
        output_image=output_image,
    )
    return immask_execute(params, runner)


__all__ = [
    "IMMASK_METADATA",
    "ImmaskOutputs",
    "immask",
    "immask_execute",
    "immask_params",
]
