# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

IMROTATE_METADATA = Metadata(
    id="68a8a871a455385d9e6b357b30b75c0ea9b3cc6d.boutiques",
    name="imrotate",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ImrotateParameters = typing.TypedDict('ImrotateParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/imrotate"]],
    "linear_interpolation": bool,
    "fourier_interpolation": bool,
    "dx": float,
    "dy": float,
    "phi": float,
    "input_image": InputPathType,
    "output_image": str,
})
ImrotateParametersTagged = typing.TypedDict('ImrotateParametersTagged', {
    "@type": typing.Literal["afni/imrotate"],
    "linear_interpolation": bool,
    "fourier_interpolation": bool,
    "dx": float,
    "dy": float,
    "phi": float,
    "input_image": InputPathType,
    "output_image": str,
})


class ImrotateOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ImrotateParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_image_file: OutputPathType
    """Path to the output image file"""


def imrotate_params(
    dx: float,
    dy: float,
    phi: float,
    input_image: InputPathType,
    output_image: str,
    linear_interpolation: bool = False,
    fourier_interpolation: bool = False,
) -> ImrotateParametersTagged:
    """
    Build parameters.
    
    Args:
        dx: Pixels to shift rightwards (can be non-integer).
        dy: Pixels to shift downwards (can be non-integer).
        phi: Degrees to rotate clockwise.
        input_image: Input image file.
        output_image: Output image file.
        linear_interpolation: Use bilinear interpolation (default is bicubic).
        fourier_interpolation: Use Fourier interpolation.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/imrotate",
        "linear_interpolation": linear_interpolation,
        "fourier_interpolation": fourier_interpolation,
        "dx": dx,
        "dy": dy,
        "phi": phi,
        "input_image": input_image,
        "output_image": output_image,
    }
    return params


def imrotate_cargs(
    params: ImrotateParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("imrotate")
    if params.get("linear_interpolation", False):
        cargs.append("-linear")
    if params.get("fourier_interpolation", False):
        cargs.append("-Fourier")
    cargs.append(str(params.get("dx", None)))
    cargs.append(str(params.get("dy", None)))
    cargs.append(str(params.get("phi", None)))
    cargs.append(execution.input_file(params.get("input_image", None)))
    cargs.append(params.get("output_image", None))
    return cargs


def imrotate_outputs(
    params: ImrotateParameters,
    execution: Execution,
) -> ImrotateOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ImrotateOutputs(
        root=execution.output_file("."),
        output_image_file=execution.output_file(params.get("output_image", None)),
    )
    return ret


def imrotate_execute(
    params: ImrotateParameters,
    runner: Runner | None = None,
) -> ImrotateOutputs:
    """
    imrotate
    
    Shifts and rotates an image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImrotateOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(IMROTATE_METADATA)
    params = execution.params(params)
    cargs = imrotate_cargs(params, execution)
    ret = imrotate_outputs(params, execution)
    execution.run(cargs)
    return ret


def imrotate(
    dx: float,
    dy: float,
    phi: float,
    input_image: InputPathType,
    output_image: str,
    linear_interpolation: bool = False,
    fourier_interpolation: bool = False,
    runner: Runner | None = None,
) -> ImrotateOutputs:
    """
    imrotate
    
    Shifts and rotates an image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dx: Pixels to shift rightwards (can be non-integer).
        dy: Pixels to shift downwards (can be non-integer).
        phi: Degrees to rotate clockwise.
        input_image: Input image file.
        output_image: Output image file.
        linear_interpolation: Use bilinear interpolation (default is bicubic).
        fourier_interpolation: Use Fourier interpolation.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImrotateOutputs`).
    """
    params = imrotate_params(
        linear_interpolation=linear_interpolation,
        fourier_interpolation=fourier_interpolation,
        dx=dx,
        dy=dy,
        phi=phi,
        input_image=input_image,
        output_image=output_image,
    )
    return imrotate_execute(params, runner)


__all__ = [
    "IMROTATE_METADATA",
    "ImrotateOutputs",
    "imrotate",
    "imrotate_execute",
    "imrotate_params",
]
