# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

IMSTACK_METADATA = Metadata(
    id="903eb8f0f9425899a698dfbbbf982f858818717b.boutiques",
    name="imstack",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ImstackParameters = typing.TypedDict('ImstackParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/imstack"]],
    "image_files": list[InputPathType],
    "data_type": typing.NotRequired[typing.Literal["short", "float"] | None],
    "output_prefix": typing.NotRequired[str | None],
})
ImstackParametersTagged = typing.TypedDict('ImstackParametersTagged', {
    "@type": typing.Literal["afni/imstack"],
    "image_files": list[InputPathType],
    "data_type": typing.NotRequired[typing.Literal["short", "float"] | None],
    "output_prefix": typing.NotRequired[str | None],
})


class ImstackOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ImstackParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_data_file: OutputPathType | None
    """Output data file"""
    output_header_file: OutputPathType | None
    """Output header file"""


def imstack_params(
    image_files: list[InputPathType],
    data_type: typing.Literal["short", "float"] | None = None,
    output_prefix: str | None = None,
) -> ImstackParametersTagged:
    """
    Build parameters.
    
    Args:
        image_files: Input image filenames.
        data_type: Converts the output data file to be 'type', which is either\
            'short' or 'float'. The default type is the type of the first image.
        output_prefix: Names the output files to be 'name'.b'type' and\
            'name'.hdr. The default name is 'obi-wan-kenobi'.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/imstack",
        "image_files": image_files,
    }
    if data_type is not None:
        params["data_type"] = data_type
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    return params


def imstack_cargs(
    params: ImstackParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("imstack")
    cargs.extend([execution.input_file(f) for f in params.get("image_files", None)])
    if params.get("data_type", None) is not None:
        cargs.extend([
            "-datum",
            params.get("data_type", None)
        ])
    if params.get("output_prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("output_prefix", None)
        ])
    return cargs


def imstack_outputs(
    params: ImstackParameters,
    execution: Execution,
) -> ImstackOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ImstackOutputs(
        root=execution.output_file("."),
        output_data_file=execution.output_file(params.get("output_prefix", None) + ".b" + params.get("data_type", None)) if (params.get("output_prefix") is not None and params.get("data_type") is not None) else None,
        output_header_file=execution.output_file(params.get("output_prefix", None) + ".hdr") if (params.get("output_prefix") is not None) else None,
    )
    return ret


def imstack_execute(
    params: ImstackParameters,
    runner: Runner | None = None,
) -> ImstackOutputs:
    """
    imstack
    
    Stacks up a set of 2D images into one big file (a la MGH).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImstackOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(IMSTACK_METADATA)
    params = execution.params(params)
    cargs = imstack_cargs(params, execution)
    ret = imstack_outputs(params, execution)
    execution.run(cargs)
    return ret


def imstack(
    image_files: list[InputPathType],
    data_type: typing.Literal["short", "float"] | None = None,
    output_prefix: str | None = None,
    runner: Runner | None = None,
) -> ImstackOutputs:
    """
    imstack
    
    Stacks up a set of 2D images into one big file (a la MGH).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        image_files: Input image filenames.
        data_type: Converts the output data file to be 'type', which is either\
            'short' or 'float'. The default type is the type of the first image.
        output_prefix: Names the output files to be 'name'.b'type' and\
            'name'.hdr. The default name is 'obi-wan-kenobi'.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ImstackOutputs`).
    """
    params = imstack_params(
        image_files=image_files,
        data_type=data_type,
        output_prefix=output_prefix,
    )
    return imstack_execute(params, runner)


__all__ = [
    "IMSTACK_METADATA",
    "ImstackOutputs",
    "imstack",
    "imstack_execute",
    "imstack_params",
]
