# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

INIT_USER_DOTFILES_PY_METADATA = Metadata(
    id="c50e66cb3d9bf43cacbd6da9a67ba68c68f7904d.boutiques",
    name="init_user_dotfiles.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


InitUserDotfilesPyParameters = typing.TypedDict('InitUserDotfilesPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/init_user_dotfiles.py"]],
    "help": bool,
    "help_dotfiles_all": bool,
    "help_dotfiles_mod": bool,
    "help_shells": bool,
    "hist": bool,
    "show_valid_opts": bool,
    "ver": bool,
    "dot_files_list": typing.NotRequired[list[str] | None],
    "dir_bin": typing.NotRequired[str | None],
    "dir_dot": typing.NotRequired[str | None],
    "do_updates": typing.NotRequired[list[str] | None],
    "dry_run": bool,
    "force": bool,
    "make_backup": typing.NotRequired[str | None],
    "shell_list": typing.NotRequired[list[str] | None],
    "test": bool,
    "verbosity_level": typing.NotRequired[int | None],
})
InitUserDotfilesPyParametersTagged = typing.TypedDict('InitUserDotfilesPyParametersTagged', {
    "@type": typing.Literal["afni/init_user_dotfiles.py"],
    "help": bool,
    "help_dotfiles_all": bool,
    "help_dotfiles_mod": bool,
    "help_shells": bool,
    "hist": bool,
    "show_valid_opts": bool,
    "ver": bool,
    "dot_files_list": typing.NotRequired[list[str] | None],
    "dir_bin": typing.NotRequired[str | None],
    "dir_dot": typing.NotRequired[str | None],
    "do_updates": typing.NotRequired[list[str] | None],
    "dry_run": bool,
    "force": bool,
    "make_backup": typing.NotRequired[str | None],
    "shell_list": typing.NotRequired[list[str] | None],
    "test": bool,
    "verbosity_level": typing.NotRequired[int | None],
})


class InitUserDotfilesPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `InitUserDotfilesPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def init_user_dotfiles_py_params(
    help_: bool = False,
    help_dotfiles_all: bool = False,
    help_dotfiles_mod: bool = False,
    help_shells: bool = False,
    hist: bool = False,
    show_valid_opts: bool = False,
    ver: bool = False,
    dot_files_list: list[str] | None = None,
    dir_bin: str | None = None,
    dir_dot: str | None = None,
    do_updates: list[str] | None = None,
    dry_run: bool = False,
    force: bool = False,
    make_backup: str | None = None,
    shell_list: list[str] | None = None,
    test: bool = False,
    verbosity_level: int | None = None,
) -> InitUserDotfilesPyParametersTagged:
    """
    Build parameters.
    
    Args:
        help_: Show this help.
        help_dotfiles_all: Display dot files known by the program.
        help_dotfiles_mod: Display modifiable dot files.
        help_shells: Display shells known by the program.
        hist: Show module history.
        show_valid_opts: List valid options.
        ver: Show current version.
        dot_files_list: Specify dot files to focus on (default from\
            -help_dotfiles_mod).
        dir_bin: Specify bin directory to add to PATH (default comes from\
            `which afni_proc.py`).
        dir_dot: Specify directory containing dot files.
        do_updates: Specify which updates to make (default is nothing).
        dry_run: Do not modify files, but see what would happen.
        force: Force edits, whether they seem needed or not.
        make_backup: Specify whether to make backups of originals (default is\
            yes).
        shell_list: Specify shells instead of using -dflist.
        test: Just test the files for potential changes.
        verbosity_level: Set the verbosity level (default 1).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/init_user_dotfiles.py",
        "help": help_,
        "help_dotfiles_all": help_dotfiles_all,
        "help_dotfiles_mod": help_dotfiles_mod,
        "help_shells": help_shells,
        "hist": hist,
        "show_valid_opts": show_valid_opts,
        "ver": ver,
        "dry_run": dry_run,
        "force": force,
        "test": test,
    }
    if dot_files_list is not None:
        params["dot_files_list"] = dot_files_list
    if dir_bin is not None:
        params["dir_bin"] = dir_bin
    if dir_dot is not None:
        params["dir_dot"] = dir_dot
    if do_updates is not None:
        params["do_updates"] = do_updates
    if make_backup is not None:
        params["make_backup"] = make_backup
    if shell_list is not None:
        params["shell_list"] = shell_list
    if verbosity_level is not None:
        params["verbosity_level"] = verbosity_level
    return params


def init_user_dotfiles_py_cargs(
    params: InitUserDotfilesPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("init_user_dotfiles.py")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("help_dotfiles_all", False):
        cargs.append("-help_dotfiles_all")
    if params.get("help_dotfiles_mod", False):
        cargs.append("-help_dotfiles_mod")
    if params.get("help_shells", False):
        cargs.append("-help_shells")
    if params.get("hist", False):
        cargs.append("-hist")
    if params.get("show_valid_opts", False):
        cargs.append("-show_valid_opts")
    if params.get("ver", False):
        cargs.append("-ver")
    if params.get("dot_files_list", None) is not None:
        cargs.extend([
            "-dflist",
            *params.get("dot_files_list", None)
        ])
    if params.get("dir_bin", None) is not None:
        cargs.extend([
            "-dir_bin",
            params.get("dir_bin", None)
        ])
    if params.get("dir_dot", None) is not None:
        cargs.extend([
            "-dir_dot",
            params.get("dir_dot", None)
        ])
    if params.get("do_updates", None) is not None:
        cargs.extend([
            "-do_updates",
            *params.get("do_updates", None)
        ])
    if params.get("dry_run", False):
        cargs.append("-dry_run")
    if params.get("force", False):
        cargs.append("-force")
    if params.get("make_backup", None) is not None:
        cargs.extend([
            "-make_backup",
            params.get("make_backup", None)
        ])
    if params.get("shell_list", None) is not None:
        cargs.extend([
            "-shell_list",
            *params.get("shell_list", None)
        ])
    if params.get("test", False):
        cargs.append("-test")
    if params.get("verbosity_level", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbosity_level", None))
        ])
    return cargs


def init_user_dotfiles_py_outputs(
    params: InitUserDotfilesPyParameters,
    execution: Execution,
) -> InitUserDotfilesPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = InitUserDotfilesPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def init_user_dotfiles_py_execute(
    params: InitUserDotfilesPyParameters,
    runner: Runner | None = None,
) -> InitUserDotfilesPyOutputs:
    """
    init_user_dotfiles.py
    
    Initialize or evaluate user dot files (.cshrc, .bashrc, ...) for system
    settings.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `InitUserDotfilesPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(INIT_USER_DOTFILES_PY_METADATA)
    params = execution.params(params)
    cargs = init_user_dotfiles_py_cargs(params, execution)
    ret = init_user_dotfiles_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def init_user_dotfiles_py(
    help_: bool = False,
    help_dotfiles_all: bool = False,
    help_dotfiles_mod: bool = False,
    help_shells: bool = False,
    hist: bool = False,
    show_valid_opts: bool = False,
    ver: bool = False,
    dot_files_list: list[str] | None = None,
    dir_bin: str | None = None,
    dir_dot: str | None = None,
    do_updates: list[str] | None = None,
    dry_run: bool = False,
    force: bool = False,
    make_backup: str | None = None,
    shell_list: list[str] | None = None,
    test: bool = False,
    verbosity_level: int | None = None,
    runner: Runner | None = None,
) -> InitUserDotfilesPyOutputs:
    """
    init_user_dotfiles.py
    
    Initialize or evaluate user dot files (.cshrc, .bashrc, ...) for system
    settings.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        help_: Show this help.
        help_dotfiles_all: Display dot files known by the program.
        help_dotfiles_mod: Display modifiable dot files.
        help_shells: Display shells known by the program.
        hist: Show module history.
        show_valid_opts: List valid options.
        ver: Show current version.
        dot_files_list: Specify dot files to focus on (default from\
            -help_dotfiles_mod).
        dir_bin: Specify bin directory to add to PATH (default comes from\
            `which afni_proc.py`).
        dir_dot: Specify directory containing dot files.
        do_updates: Specify which updates to make (default is nothing).
        dry_run: Do not modify files, but see what would happen.
        force: Force edits, whether they seem needed or not.
        make_backup: Specify whether to make backups of originals (default is\
            yes).
        shell_list: Specify shells instead of using -dflist.
        test: Just test the files for potential changes.
        verbosity_level: Set the verbosity level (default 1).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `InitUserDotfilesPyOutputs`).
    """
    params = init_user_dotfiles_py_params(
        help_=help_,
        help_dotfiles_all=help_dotfiles_all,
        help_dotfiles_mod=help_dotfiles_mod,
        help_shells=help_shells,
        hist=hist,
        show_valid_opts=show_valid_opts,
        ver=ver,
        dot_files_list=dot_files_list,
        dir_bin=dir_bin,
        dir_dot=dir_dot,
        do_updates=do_updates,
        dry_run=dry_run,
        force=force,
        make_backup=make_backup,
        shell_list=shell_list,
        test=test,
        verbosity_level=verbosity_level,
    )
    return init_user_dotfiles_py_execute(params, runner)


__all__ = [
    "INIT_USER_DOTFILES_PY_METADATA",
    "InitUserDotfilesPyOutputs",
    "init_user_dotfiles_py",
    "init_user_dotfiles_py_execute",
    "init_user_dotfiles_py_params",
]
