# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

MAP_ICOSAHEDRON_METADATA = Metadata(
    id="a3138b4aa327170500cbb35df97389a3aea3f40c.boutiques",
    name="MapIcosahedron",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


MapIcosahedronParameters = typing.TypedDict('MapIcosahedronParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/MapIcosahedron"]],
    "spec_file": InputPathType,
    "rec_depth": typing.NotRequired[float | None],
    "lin_depth": typing.NotRequired[float | None],
    "morph_surf": typing.NotRequired[str | None],
    "num_it": typing.NotRequired[float | None],
    "prefix": typing.NotRequired[str | None],
    "nn_dset": typing.NotRequired[str | None],
    "dset": typing.NotRequired[str | None],
    "fix_cut_surfaces": bool,
    "verbosity": bool,
    "help": bool,
})
MapIcosahedronParametersTagged = typing.TypedDict('MapIcosahedronParametersTagged', {
    "@type": typing.Literal["afni/MapIcosahedron"],
    "spec_file": InputPathType,
    "rec_depth": typing.NotRequired[float | None],
    "lin_depth": typing.NotRequired[float | None],
    "morph_surf": typing.NotRequired[str | None],
    "num_it": typing.NotRequired[float | None],
    "prefix": typing.NotRequired[str | None],
    "nn_dset": typing.NotRequired[str | None],
    "dset": typing.NotRequired[str | None],
    "fix_cut_surfaces": bool,
    "verbosity": bool,
    "help": bool,
})


class MapIcosahedronOutputs(typing.NamedTuple):
    """
    Output object returned when calling `MapIcosahedronParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def map_icosahedron_params(
    spec_file: InputPathType,
    rec_depth: float | None = None,
    lin_depth: float | None = None,
    morph_surf: str | None = None,
    num_it: float | None = None,
    prefix: str | None = None,
    nn_dset: str | None = None,
    dset: str | None = None,
    fix_cut_surfaces: bool = False,
    verbosity: bool = False,
    help_: bool = False,
) -> MapIcosahedronParametersTagged:
    """
    Build parameters.
    
    Args:
        spec_file: Spec file containing original-mesh surfaces.
        rec_depth: Recursive (binary) tessellation depth for icosahedron\
            (default: 3).
        lin_depth: Number of edge divides for linear icosahedron tessellation.
        morph_surf: Specifies the morphSurf surface.
        num_it: Number of smoothing iterations.
        prefix: Prefix for output files (default: 'std.').
        nn_dset: Map DSET onto the new mesh using Nearest Neighbor\
            interpolation.
        dset: Map DSET onto the new mesh using barycentric interpolation.
        fix_cut_surfaces: Check and fix standard-mesh surfaces with cuts for\
            cross-cut connections.
        verbosity: Enable verbose output.
        help_: Display the help text.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/MapIcosahedron",
        "spec_file": spec_file,
        "fix_cut_surfaces": fix_cut_surfaces,
        "verbosity": verbosity,
        "help": help_,
    }
    if rec_depth is not None:
        params["rec_depth"] = rec_depth
    if lin_depth is not None:
        params["lin_depth"] = lin_depth
    if morph_surf is not None:
        params["morph_surf"] = morph_surf
    if num_it is not None:
        params["num_it"] = num_it
    if prefix is not None:
        params["prefix"] = prefix
    if nn_dset is not None:
        params["nn_dset"] = nn_dset
    if dset is not None:
        params["dset"] = dset
    return params


def map_icosahedron_cargs(
    params: MapIcosahedronParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("MapIcosahedron")
    cargs.append(execution.input_file(params.get("spec_file", None)))
    if params.get("rec_depth", None) is not None:
        cargs.extend([
            "-rd",
            str(params.get("rec_depth", None))
        ])
    if params.get("lin_depth", None) is not None:
        cargs.extend([
            "-ld",
            str(params.get("lin_depth", None))
        ])
    if params.get("morph_surf", None) is not None:
        cargs.extend([
            "-morph",
            params.get("morph_surf", None)
        ])
    if params.get("num_it", None) is not None:
        cargs.extend([
            "-it",
            str(params.get("num_it", None))
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("nn_dset", None) is not None:
        cargs.extend([
            "-NN_dset_map",
            params.get("nn_dset", None)
        ])
    if params.get("dset", None) is not None:
        cargs.extend([
            "-dset_map",
            params.get("dset", None)
        ])
    if params.get("fix_cut_surfaces", False):
        cargs.append("-fix_cut_surfaces")
    if params.get("verbosity", False):
        cargs.append("-verb")
    if params.get("help", False):
        cargs.append("-help")
    return cargs


def map_icosahedron_outputs(
    params: MapIcosahedronParameters,
    execution: Execution,
) -> MapIcosahedronOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = MapIcosahedronOutputs(
        root=execution.output_file("."),
    )
    return ret


def map_icosahedron_execute(
    params: MapIcosahedronParameters,
    runner: Runner | None = None,
) -> MapIcosahedronOutputs:
    """
    MapIcosahedron
    
    Creates new versions of original-mesh surfaces using the mesh of an
    icosahedron.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `MapIcosahedronOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(MAP_ICOSAHEDRON_METADATA)
    params = execution.params(params)
    cargs = map_icosahedron_cargs(params, execution)
    ret = map_icosahedron_outputs(params, execution)
    execution.run(cargs)
    return ret


def map_icosahedron(
    spec_file: InputPathType,
    rec_depth: float | None = None,
    lin_depth: float | None = None,
    morph_surf: str | None = None,
    num_it: float | None = None,
    prefix: str | None = None,
    nn_dset: str | None = None,
    dset: str | None = None,
    fix_cut_surfaces: bool = False,
    verbosity: bool = False,
    help_: bool = False,
    runner: Runner | None = None,
) -> MapIcosahedronOutputs:
    """
    MapIcosahedron
    
    Creates new versions of original-mesh surfaces using the mesh of an
    icosahedron.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        spec_file: Spec file containing original-mesh surfaces.
        rec_depth: Recursive (binary) tessellation depth for icosahedron\
            (default: 3).
        lin_depth: Number of edge divides for linear icosahedron tessellation.
        morph_surf: Specifies the morphSurf surface.
        num_it: Number of smoothing iterations.
        prefix: Prefix for output files (default: 'std.').
        nn_dset: Map DSET onto the new mesh using Nearest Neighbor\
            interpolation.
        dset: Map DSET onto the new mesh using barycentric interpolation.
        fix_cut_surfaces: Check and fix standard-mesh surfaces with cuts for\
            cross-cut connections.
        verbosity: Enable verbose output.
        help_: Display the help text.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `MapIcosahedronOutputs`).
    """
    params = map_icosahedron_params(
        spec_file=spec_file,
        rec_depth=rec_depth,
        lin_depth=lin_depth,
        morph_surf=morph_surf,
        num_it=num_it,
        prefix=prefix,
        nn_dset=nn_dset,
        dset=dset,
        fix_cut_surfaces=fix_cut_surfaces,
        verbosity=verbosity,
        help_=help_,
    )
    return map_icosahedron_execute(params, runner)


__all__ = [
    "MAP_ICOSAHEDRON_METADATA",
    "MapIcosahedronOutputs",
    "map_icosahedron",
    "map_icosahedron_execute",
    "map_icosahedron_params",
]
