# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

MAP_TRACK_ID_METADATA = Metadata(
    id="4ee10f84c4d6677586bf4ac90f7a7517bc13dbea.boutiques",
    name="map_TrackID",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


MapTrackIdParameters = typing.TypedDict('MapTrackIdParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/map_TrackID"]],
    "prefix": str,
    "in_trk": InputPathType,
    "in_map": InputPathType,
    "reference": InputPathType,
    "verbose": bool,
    "orig_zero": bool,
    "line_only_num": bool,
    "already_inv": bool,
})
MapTrackIdParametersTagged = typing.TypedDict('MapTrackIdParametersTagged', {
    "@type": typing.Literal["afni/map_TrackID"],
    "prefix": str,
    "in_trk": InputPathType,
    "in_map": InputPathType,
    "reference": InputPathType,
    "verbose": bool,
    "orig_zero": bool,
    "line_only_num": bool,
    "already_inv": bool,
})


class MapTrackIdOutputs(typing.NamedTuple):
    """
    Output object returned when calling `MapTrackIdParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_trk_file: OutputPathType
    """Mapped track file to new space"""


def map_track_id_params(
    prefix: str,
    in_trk: InputPathType,
    in_map: InputPathType,
    reference: InputPathType,
    verbose: bool = False,
    orig_zero: bool = False,
    line_only_num: bool = False,
    already_inv: bool = False,
) -> MapTrackIdParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix for the output track file.
        in_trk: The name of the *.trk file to be mapped.
        in_map: Single line of matrix values for the transformation.
        reference: 3D data set in the space to which the TRK file is being\
            mapped.
        verbose: Verbose output.
        orig_zero: Put (0,0,0) as the origin in the output *.trk file.
        line_only_num: If your 1D_MATR file is just 12 numbers in a row.
        already_inv: If you have inverted the mapping or use another program\
            than 3dAllineate.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/map_TrackID",
        "prefix": prefix,
        "in_trk": in_trk,
        "in_map": in_map,
        "reference": reference,
        "verbose": verbose,
        "orig_zero": orig_zero,
        "line_only_num": line_only_num,
        "already_inv": already_inv,
    }
    return params


def map_track_id_cargs(
    params: MapTrackIdParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("map_TrackID")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.extend([
        "-in_trk",
        execution.input_file(params.get("in_trk", None))
    ])
    cargs.extend([
        "-in_map",
        execution.input_file(params.get("in_map", None))
    ])
    cargs.extend([
        "-ref",
        execution.input_file(params.get("reference", None))
    ])
    if params.get("verbose", False):
        cargs.append("-verb")
    if params.get("orig_zero", False):
        cargs.append("-orig_zero")
    if params.get("line_only_num", False):
        cargs.append("-line_only_num")
    if params.get("already_inv", False):
        cargs.append("-already_inv")
    return cargs


def map_track_id_outputs(
    params: MapTrackIdParameters,
    execution: Execution,
) -> MapTrackIdOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = MapTrackIdOutputs(
        root=execution.output_file("."),
        output_trk_file=execution.output_file(params.get("prefix", None) + ".trk"),
    )
    return ret


def map_track_id_execute(
    params: MapTrackIdParameters,
    runner: Runner | None = None,
) -> MapTrackIdOutputs:
    """
    map_TrackID
    
    Maps the track file (*.trk) output of 3dTrackID to another space using the
    1Dmatrix_save info of 3dAllineate.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `MapTrackIdOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(MAP_TRACK_ID_METADATA)
    params = execution.params(params)
    cargs = map_track_id_cargs(params, execution)
    ret = map_track_id_outputs(params, execution)
    execution.run(cargs)
    return ret


def map_track_id(
    prefix: str,
    in_trk: InputPathType,
    in_map: InputPathType,
    reference: InputPathType,
    verbose: bool = False,
    orig_zero: bool = False,
    line_only_num: bool = False,
    already_inv: bool = False,
    runner: Runner | None = None,
) -> MapTrackIdOutputs:
    """
    map_TrackID
    
    Maps the track file (*.trk) output of 3dTrackID to another space using the
    1Dmatrix_save info of 3dAllineate.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix for the output track file.
        in_trk: The name of the *.trk file to be mapped.
        in_map: Single line of matrix values for the transformation.
        reference: 3D data set in the space to which the TRK file is being\
            mapped.
        verbose: Verbose output.
        orig_zero: Put (0,0,0) as the origin in the output *.trk file.
        line_only_num: If your 1D_MATR file is just 12 numbers in a row.
        already_inv: If you have inverted the mapping or use another program\
            than 3dAllineate.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `MapTrackIdOutputs`).
    """
    params = map_track_id_params(
        prefix=prefix,
        in_trk=in_trk,
        in_map=in_map,
        reference=reference,
        verbose=verbose,
        orig_zero=orig_zero,
        line_only_num=line_only_num,
        already_inv=already_inv,
    )
    return map_track_id_execute(params, runner)


__all__ = [
    "MAP_TRACK_ID_METADATA",
    "MapTrackIdOutputs",
    "map_track_id",
    "map_track_id_execute",
    "map_track_id_params",
]
