# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

MYGET_METADATA = Metadata(
    id="6924b5dd88139a6314a9d06a406e8d99114cb986.boutiques",
    name="myget",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


MygetParameters = typing.TypedDict('MygetParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/myget"]],
    "protocol_version": typing.NotRequired[typing.Literal["-1", "-1.1"] | None],
    "url": str,
    "output_file": str,
})
MygetParametersTagged = typing.TypedDict('MygetParametersTagged', {
    "@type": typing.Literal["afni/myget"],
    "protocol_version": typing.NotRequired[typing.Literal["-1", "-1.1"] | None],
    "url": str,
    "output_file": str,
})


class MygetOutputs(typing.NamedTuple):
    """
    Output object returned when calling `MygetParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """The filename to save the downloaded file"""


def myget_params(
    url: str,
    output_file: str,
    protocol_version: typing.Literal["-1", "-1.1"] | None = None,
) -> MygetParametersTagged:
    """
    Build parameters.
    
    Args:
        url: The URL to download the file from.
        output_file: The filename to save the downloaded file.
        protocol_version: Specify protocol version. You can choose between -1\
            or -1.1.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/myget",
        "url": url,
        "output_file": output_file,
    }
    if protocol_version is not None:
        params["protocol_version"] = protocol_version
    return params


def myget_cargs(
    params: MygetParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("myget")
    if params.get("protocol_version", None) is not None:
        cargs.append(params.get("protocol_version", None))
    cargs.append(params.get("url", None))
    cargs.extend([
        ">",
        params.get("output_file", None)
    ])
    return cargs


def myget_outputs(
    params: MygetParameters,
    execution: Execution,
) -> MygetOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = MygetOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_file", None)),
    )
    return ret


def myget_execute(
    params: MygetParameters,
    runner: Runner | None = None,
) -> MygetOutputs:
    """
    myget
    
    A simple file downloader from a URL.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `MygetOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(MYGET_METADATA)
    params = execution.params(params)
    cargs = myget_cargs(params, execution)
    ret = myget_outputs(params, execution)
    execution.run(cargs)
    return ret


def myget(
    url: str,
    output_file: str,
    protocol_version: typing.Literal["-1", "-1.1"] | None = None,
    runner: Runner | None = None,
) -> MygetOutputs:
    """
    myget
    
    A simple file downloader from a URL.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        url: The URL to download the file from.
        output_file: The filename to save the downloaded file.
        protocol_version: Specify protocol version. You can choose between -1\
            or -1.1.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `MygetOutputs`).
    """
    params = myget_params(
        protocol_version=protocol_version,
        url=url,
        output_file=output_file,
    )
    return myget_execute(params, runner)


__all__ = [
    "MYGET_METADATA",
    "MygetOutputs",
    "myget",
    "myget_execute",
    "myget_params",
]
