# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

NICCC_METADATA = Metadata(
    id="38ab5aeadd2358c30dcd70e6045a73c5e0e67cb5.boutiques",
    name="niccc",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


NicccParameters = typing.TypedDict('NicccParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/niccc"]],
    "streamspec": str,
    "duplicate": bool,
    "nodata": bool,
    "attribute": typing.NotRequired[str | None],
    "match": typing.NotRequired[str | None],
    "file": bool,
    "string": bool,
    "stdout": bool,
    "hash": bool,
    "quiet": bool,
    "find_attr": typing.NotRequired[list[str] | None],
    "skip_attr": typing.NotRequired[list[str] | None],
})
NicccParametersTagged = typing.TypedDict('NicccParametersTagged', {
    "@type": typing.Literal["afni/niccc"],
    "streamspec": str,
    "duplicate": bool,
    "nodata": bool,
    "attribute": typing.NotRequired[str | None],
    "match": typing.NotRequired[str | None],
    "file": bool,
    "string": bool,
    "stdout": bool,
    "hash": bool,
    "quiet": bool,
    "find_attr": typing.NotRequired[list[str] | None],
    "skip_attr": typing.NotRequired[list[str] | None],
})


class NicccOutputs(typing.NamedTuple):
    """
    Output object returned when calling `NicccParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    stderr_output: OutputPathType
    """Results output to stderr"""


def niccc_params(
    streamspec: str,
    duplicate: bool = False,
    nodata: bool = False,
    attribute: str | None = None,
    match: str | None = None,
    file: bool = False,
    string_: bool = False,
    stdout: bool = False,
    hash_: bool = False,
    quiet: bool = False,
    find_attr: list[str] | None = None,
    skip_attr: list[str] | None = None,
) -> NicccParametersTagged:
    """
    Build parameters.
    
    Args:
        streamspec: A string defining a NIML stream.
        duplicate: Duplicate the element before showing it. This is to test\
            NI_duplicate function.
        nodata: Show header parts only in output.
        attribute: Dump the value of attribute ATTR.
        match: Match attribute: If MATCH is exact, then attribute name is\
            matched exactly. If MATCH is partial, then a match of all the\
            characters in ATTR is enough.
        file: Streamspec is a filename.
        string_: Streamspec is an element string like: '<T font=9 coords="2.3\
            23 2"/>'.
        stdout: Write elements to stdout, instead of stderr.
        hash_: Put the # at the beginning of lines with no data.
        quiet: Quiet stderr messages, and don't echo attribute name with\
            -attribute option.
        find_attr: Only output elements that have an attribute ATTR of value\
            ATTRVAL.
        skip_attr: Do not output elements that have an attribute ATTR of value\
            ATTRVAL.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/niccc",
        "streamspec": streamspec,
        "duplicate": duplicate,
        "nodata": nodata,
        "file": file,
        "string": string_,
        "stdout": stdout,
        "hash": hash_,
        "quiet": quiet,
    }
    if attribute is not None:
        params["attribute"] = attribute
    if match is not None:
        params["match"] = match
    if find_attr is not None:
        params["find_attr"] = find_attr
    if skip_attr is not None:
        params["skip_attr"] = skip_attr
    return params


def niccc_cargs(
    params: NicccParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("niccc")
    cargs.append(params.get("streamspec", None))
    if params.get("duplicate", False):
        cargs.append("-dup")
    if params.get("nodata", False):
        cargs.append("-nodata")
    if params.get("attribute", None) is not None:
        cargs.extend([
            "-attribute",
            params.get("attribute", None)
        ])
    if params.get("match", None) is not None:
        cargs.extend([
            "-match",
            params.get("match", None)
        ])
    if params.get("file", False):
        cargs.append("-f")
    if params.get("string", False):
        cargs.append("-s")
    if params.get("stdout", False):
        cargs.append("-stdout")
    if params.get("hash", False):
        cargs.append("-#")
    if params.get("quiet", False):
        cargs.append("-quiet")
    if params.get("find_attr", None) is not None:
        cargs.extend([
            "-find_nel_with_attr",
            *params.get("find_attr", None)
        ])
    if params.get("skip_attr", None) is not None:
        cargs.extend([
            "-skip_nel_with_attr",
            *params.get("skip_attr", None)
        ])
    return cargs


def niccc_outputs(
    params: NicccParameters,
    execution: Execution,
) -> NicccOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = NicccOutputs(
        root=execution.output_file("."),
        stderr_output=execution.output_file("stderr"),
    )
    return ret


def niccc_execute(
    params: NicccParameters,
    runner: Runner | None = None,
) -> NicccOutputs:
    """
    niccc
    
    A program for conducting certain NIML tests on input from streamspec and
    write the results to stderr.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `NicccOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(NICCC_METADATA)
    params = execution.params(params)
    cargs = niccc_cargs(params, execution)
    ret = niccc_outputs(params, execution)
    execution.run(cargs)
    return ret


def niccc(
    streamspec: str,
    duplicate: bool = False,
    nodata: bool = False,
    attribute: str | None = None,
    match: str | None = None,
    file: bool = False,
    string_: bool = False,
    stdout: bool = False,
    hash_: bool = False,
    quiet: bool = False,
    find_attr: list[str] | None = None,
    skip_attr: list[str] | None = None,
    runner: Runner | None = None,
) -> NicccOutputs:
    """
    niccc
    
    A program for conducting certain NIML tests on input from streamspec and
    write the results to stderr.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        streamspec: A string defining a NIML stream.
        duplicate: Duplicate the element before showing it. This is to test\
            NI_duplicate function.
        nodata: Show header parts only in output.
        attribute: Dump the value of attribute ATTR.
        match: Match attribute: If MATCH is exact, then attribute name is\
            matched exactly. If MATCH is partial, then a match of all the\
            characters in ATTR is enough.
        file: Streamspec is a filename.
        string_: Streamspec is an element string like: '<T font=9 coords="2.3\
            23 2"/>'.
        stdout: Write elements to stdout, instead of stderr.
        hash_: Put the # at the beginning of lines with no data.
        quiet: Quiet stderr messages, and don't echo attribute name with\
            -attribute option.
        find_attr: Only output elements that have an attribute ATTR of value\
            ATTRVAL.
        skip_attr: Do not output elements that have an attribute ATTR of value\
            ATTRVAL.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `NicccOutputs`).
    """
    params = niccc_params(
        streamspec=streamspec,
        duplicate=duplicate,
        nodata=nodata,
        attribute=attribute,
        match=match,
        file=file,
        string_=string_,
        stdout=stdout,
        hash_=hash_,
        quiet=quiet,
        find_attr=find_attr,
        skip_attr=skip_attr,
    )
    return niccc_execute(params, runner)


__all__ = [
    "NICCC_METADATA",
    "NicccOutputs",
    "niccc",
    "niccc_execute",
    "niccc_params",
]
