# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

PARSE_FS_LT_LOG_PY_METADATA = Metadata(
    id="4a69eeba6f91f13034077316927725321424fc4f.boutiques",
    name="parse_fs_lt_log.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ParseFsLtLogPyParameters = typing.TypedDict('ParseFsLtLogPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/parse_fs_lt_log.py"]],
    "logfile": InputPathType,
    "labels": list[str],
    "show_orig": bool,
    "show_all_orig": bool,
    "verbosity": typing.NotRequired[float | None],
})
ParseFsLtLogPyParametersTagged = typing.TypedDict('ParseFsLtLogPyParametersTagged', {
    "@type": typing.Literal["afni/parse_fs_lt_log.py"],
    "logfile": InputPathType,
    "labels": list[str],
    "show_orig": bool,
    "show_all_orig": bool,
    "verbosity": typing.NotRequired[float | None],
})


class ParseFsLtLogPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ParseFsLtLogPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def parse_fs_lt_log_py_params(
    logfile: InputPathType,
    labels: list[str],
    show_orig: bool = False,
    show_all_orig: bool = False,
    verbosity: float | None = None,
) -> ParseFsLtLogPyParametersTagged:
    """
    Build parameters.
    
    Args:
        logfile: Specify rank log file.
        labels: Specify a list of labels to search for.
        show_orig: Show original label indices.
        show_all_orig: Show all original label indices.
        verbosity: Specify verbosity level.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/parse_fs_lt_log.py",
        "logfile": logfile,
        "labels": labels,
        "show_orig": show_orig,
        "show_all_orig": show_all_orig,
    }
    if verbosity is not None:
        params["verbosity"] = verbosity
    return params


def parse_fs_lt_log_py_cargs(
    params: ParseFsLtLogPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("parse_fs_lt_log.py")
    cargs.extend([
        "-logfile",
        execution.input_file(params.get("logfile", None))
    ])
    cargs.extend([
        "-labels",
        *params.get("labels", None)
    ])
    if params.get("show_orig", False):
        cargs.append("-show_orig")
    if params.get("show_all_orig", False):
        cargs.append("-show_all_orig")
    if params.get("verbosity", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbosity", None))
        ])
    return cargs


def parse_fs_lt_log_py_outputs(
    params: ParseFsLtLogPyParameters,
    execution: Execution,
) -> ParseFsLtLogPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ParseFsLtLogPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def parse_fs_lt_log_py_execute(
    params: ParseFsLtLogPyParameters,
    runner: Runner | None = None,
) -> ParseFsLtLogPyOutputs:
    """
    parse_fs_lt_log.py
    
    Parses FreeSurfer labeltable log file and retrieves labeltable indices.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ParseFsLtLogPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(PARSE_FS_LT_LOG_PY_METADATA)
    params = execution.params(params)
    cargs = parse_fs_lt_log_py_cargs(params, execution)
    ret = parse_fs_lt_log_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def parse_fs_lt_log_py(
    logfile: InputPathType,
    labels: list[str],
    show_orig: bool = False,
    show_all_orig: bool = False,
    verbosity: float | None = None,
    runner: Runner | None = None,
) -> ParseFsLtLogPyOutputs:
    """
    parse_fs_lt_log.py
    
    Parses FreeSurfer labeltable log file and retrieves labeltable indices.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        logfile: Specify rank log file.
        labels: Specify a list of labels to search for.
        show_orig: Show original label indices.
        show_all_orig: Show all original label indices.
        verbosity: Specify verbosity level.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ParseFsLtLogPyOutputs`).
    """
    params = parse_fs_lt_log_py_params(
        logfile=logfile,
        labels=labels,
        show_orig=show_orig,
        show_all_orig=show_all_orig,
        verbosity=verbosity,
    )
    return parse_fs_lt_log_py_execute(params, runner)


__all__ = [
    "PARSE_FS_LT_LOG_PY_METADATA",
    "ParseFsLtLogPyOutputs",
    "parse_fs_lt_log_py",
    "parse_fs_lt_log_py_execute",
    "parse_fs_lt_log_py_params",
]
