# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

PLUGOUT_TT_METADATA = Metadata(
    id="145dc1e62b1eb43cc53a27323d95048b129d8942.boutiques",
    name="plugout_tt",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


PlugoutTtParameters = typing.TypedDict('PlugoutTtParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/plugout_tt"]],
    "host": typing.NotRequired[str | None],
    "ijk_option": bool,
    "verbose": bool,
    "port": typing.NotRequired[float | None],
    "name": typing.NotRequired[str | None],
    "port_offset": typing.NotRequired[float | None],
    "port_offset_quiet": typing.NotRequired[float | None],
    "port_bloc": typing.NotRequired[float | None],
    "max_port_bloc": bool,
    "max_port_bloc_quiet": bool,
    "num_assigned_ports": bool,
    "num_assigned_ports_quiet": bool,
})
PlugoutTtParametersTagged = typing.TypedDict('PlugoutTtParametersTagged', {
    "@type": typing.Literal["afni/plugout_tt"],
    "host": typing.NotRequired[str | None],
    "ijk_option": bool,
    "verbose": bool,
    "port": typing.NotRequired[float | None],
    "name": typing.NotRequired[str | None],
    "port_offset": typing.NotRequired[float | None],
    "port_offset_quiet": typing.NotRequired[float | None],
    "port_bloc": typing.NotRequired[float | None],
    "max_port_bloc": bool,
    "max_port_bloc_quiet": bool,
    "num_assigned_ports": bool,
    "num_assigned_ports_quiet": bool,
})


class PlugoutTtOutputs(typing.NamedTuple):
    """
    Output object returned when calling `PlugoutTtParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def plugout_tt_params(
    host: str | None = None,
    ijk_option: bool = False,
    verbose: bool = False,
    port: float | None = None,
    name: str | None = None,
    port_offset: float | None = None,
    port_offset_quiet: float | None = None,
    port_bloc: float | None = None,
    max_port_bloc: bool = False,
    max_port_bloc_quiet: bool = False,
    num_assigned_ports: bool = False,
    num_assigned_ports_quiet: bool = False,
) -> PlugoutTtParametersTagged:
    """
    Build parameters.
    
    Args:
        host: Name of the host computer to connect to AFNI on. The default is\
            to connect on the current host using shared memory.
        ijk_option: Get voxel indices from AFNI instead of Talairach\
            coordinates.
        verbose: Enable verbose mode (prints lots of diagnostic messages).
        port: TCP/IP port number to use. The default is 8001.
        name: String to use as the name that AFNI assigns to this plugout. The\
            default is something silly.
        port_offset: Provide a port offset to allow multiple instances of\
            communicating programs to operate on the same computer. Use an integer\
            in the inclusive range [1025 to 65500].
        port_offset_quiet: Provide a port offset to allow multiple instances of\
            communicating programs to operate on the same computer with quiet\
            output in case of issues. Use an integer in the inclusive range [1025\
            to 65500].
        port_bloc: Provide a port offset bloc for easier configuration of\
            multiple instances. PORT_OFFSET_BLOC is an integer between 0 and\
            MAX_BLOC (around 4000).
        max_port_bloc: Print the current value of MAX_BLOC and exit. Stay under\
            2000 for safety.
        max_port_bloc_quiet: Print the current value of MAX_BLOC quietly and\
            exit.
        num_assigned_ports: Print the number of assigned ports used by AFNI,\
            then quit.
        num_assigned_ports_quiet: Print the number of assigned ports used by\
            AFNI quietly, then quit.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/plugout_tt",
        "ijk_option": ijk_option,
        "verbose": verbose,
        "max_port_bloc": max_port_bloc,
        "max_port_bloc_quiet": max_port_bloc_quiet,
        "num_assigned_ports": num_assigned_ports,
        "num_assigned_ports_quiet": num_assigned_ports_quiet,
    }
    if host is not None:
        params["host"] = host
    if port is not None:
        params["port"] = port
    if name is not None:
        params["name"] = name
    if port_offset is not None:
        params["port_offset"] = port_offset
    if port_offset_quiet is not None:
        params["port_offset_quiet"] = port_offset_quiet
    if port_bloc is not None:
        params["port_bloc"] = port_bloc
    return params


def plugout_tt_cargs(
    params: PlugoutTtParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("plugout_tt")
    if params.get("host", None) is not None:
        cargs.extend([
            "-host",
            params.get("host", None)
        ])
    if params.get("ijk_option", False):
        cargs.append("-ijk")
    if params.get("verbose", False):
        cargs.append("-v")
    if params.get("port", None) is not None:
        cargs.extend([
            "-port",
            str(params.get("port", None))
        ])
    if params.get("name", None) is not None:
        cargs.extend([
            "-name",
            params.get("name", None)
        ])
    if params.get("port_offset", None) is not None:
        cargs.extend([
            "-np",
            str(params.get("port_offset", None))
        ])
    if params.get("port_offset_quiet", None) is not None:
        cargs.extend([
            "-npq",
            str(params.get("port_offset_quiet", None))
        ])
    if params.get("port_bloc", None) is not None:
        cargs.extend([
            "-npb",
            str(params.get("port_bloc", None))
        ])
    if params.get("max_port_bloc", False):
        cargs.append("-max_port_bloc")
    if params.get("max_port_bloc_quiet", False):
        cargs.append("-max_port_bloc_quiet")
    if params.get("num_assigned_ports", False):
        cargs.append("-num_assigned_ports")
    if params.get("num_assigned_ports_quiet", False):
        cargs.append("-num_assigned_ports_quiet")
    return cargs


def plugout_tt_outputs(
    params: PlugoutTtParameters,
    execution: Execution,
) -> PlugoutTtOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = PlugoutTtOutputs(
        root=execution.output_file("."),
    )
    return ret


def plugout_tt_execute(
    params: PlugoutTtParameters,
    runner: Runner | None = None,
) -> PlugoutTtOutputs:
    """
    plugout_tt
    
    This program connects to AFNI and receives notification whenever the user
    changes Talairach coordinates.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PlugoutTtOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(PLUGOUT_TT_METADATA)
    params = execution.params(params)
    cargs = plugout_tt_cargs(params, execution)
    ret = plugout_tt_outputs(params, execution)
    execution.run(cargs)
    return ret


def plugout_tt(
    host: str | None = None,
    ijk_option: bool = False,
    verbose: bool = False,
    port: float | None = None,
    name: str | None = None,
    port_offset: float | None = None,
    port_offset_quiet: float | None = None,
    port_bloc: float | None = None,
    max_port_bloc: bool = False,
    max_port_bloc_quiet: bool = False,
    num_assigned_ports: bool = False,
    num_assigned_ports_quiet: bool = False,
    runner: Runner | None = None,
) -> PlugoutTtOutputs:
    """
    plugout_tt
    
    This program connects to AFNI and receives notification whenever the user
    changes Talairach coordinates.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        host: Name of the host computer to connect to AFNI on. The default is\
            to connect on the current host using shared memory.
        ijk_option: Get voxel indices from AFNI instead of Talairach\
            coordinates.
        verbose: Enable verbose mode (prints lots of diagnostic messages).
        port: TCP/IP port number to use. The default is 8001.
        name: String to use as the name that AFNI assigns to this plugout. The\
            default is something silly.
        port_offset: Provide a port offset to allow multiple instances of\
            communicating programs to operate on the same computer. Use an integer\
            in the inclusive range [1025 to 65500].
        port_offset_quiet: Provide a port offset to allow multiple instances of\
            communicating programs to operate on the same computer with quiet\
            output in case of issues. Use an integer in the inclusive range [1025\
            to 65500].
        port_bloc: Provide a port offset bloc for easier configuration of\
            multiple instances. PORT_OFFSET_BLOC is an integer between 0 and\
            MAX_BLOC (around 4000).
        max_port_bloc: Print the current value of MAX_BLOC and exit. Stay under\
            2000 for safety.
        max_port_bloc_quiet: Print the current value of MAX_BLOC quietly and\
            exit.
        num_assigned_ports: Print the number of assigned ports used by AFNI,\
            then quit.
        num_assigned_ports_quiet: Print the number of assigned ports used by\
            AFNI quietly, then quit.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PlugoutTtOutputs`).
    """
    params = plugout_tt_params(
        host=host,
        ijk_option=ijk_option,
        verbose=verbose,
        port=port,
        name=name,
        port_offset=port_offset,
        port_offset_quiet=port_offset_quiet,
        port_bloc=port_bloc,
        max_port_bloc=max_port_bloc,
        max_port_bloc_quiet=max_port_bloc_quiet,
        num_assigned_ports=num_assigned_ports,
        num_assigned_ports_quiet=num_assigned_ports_quiet,
    )
    return plugout_tt_execute(params, runner)


__all__ = [
    "PLUGOUT_TT_METADATA",
    "PlugoutTtOutputs",
    "plugout_tt",
    "plugout_tt_execute",
    "plugout_tt_params",
]
