# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

PROMPT_POPUP_METADATA = Metadata(
    id="1754fed0e11b63758a193b0de9198e3fac8f88c3.boutiques",
    name="prompt_popup",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


PromptPopupParameters = typing.TypedDict('PromptPopupParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/prompt_popup"]],
    "message": str,
    "message_pause": typing.NotRequired[str | None],
    "buttons": typing.NotRequired[list[str] | None],
    "buttons_b": typing.NotRequired[list[str] | None],
    "timeout": typing.NotRequired[float | None],
    "timeout_to": typing.NotRequired[float | None],
})
PromptPopupParametersTagged = typing.TypedDict('PromptPopupParametersTagged', {
    "@type": typing.Literal["afni/prompt_popup"],
    "message": str,
    "message_pause": typing.NotRequired[str | None],
    "buttons": typing.NotRequired[list[str] | None],
    "buttons_b": typing.NotRequired[list[str] | None],
    "timeout": typing.NotRequired[float | None],
    "timeout_to": typing.NotRequired[float | None],
})


class PromptPopupOutputs(typing.NamedTuple):
    """
    Output object returned when calling `PromptPopupParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def prompt_popup_params(
    message: str,
    message_pause: str | None = None,
    buttons: list[str] | None = None,
    buttons_b: list[str] | None = None,
    timeout: float | None = None,
    timeout_to: float | None = None,
) -> PromptPopupParametersTagged:
    """
    Build parameters.
    
    Args:
        message: Pops a window prompting the user with MESSAGE. If MESSAGE is\
            '-', it is read from stdin.
        message_pause: Same as -message to match the old prompt_user.
        buttons: What do you want the buttons to say? You can give up to three\
            -button for three buttons. Returns integer 1, 2, or 3. If there is no\
            -button, there will be one button 'Ok'.
        buttons_b: Same as -button.
        timeout: Timeout in seconds of prompt message. Default answer is\
            returned if TT seconds elapse without user input.
        timeout_to: Same as -timeout TT.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/prompt_popup",
        "message": message,
    }
    if message_pause is not None:
        params["message_pause"] = message_pause
    if buttons is not None:
        params["buttons"] = buttons
    if buttons_b is not None:
        params["buttons_b"] = buttons_b
    if timeout is not None:
        params["timeout"] = timeout
    if timeout_to is not None:
        params["timeout_to"] = timeout_to
    return params


def prompt_popup_cargs(
    params: PromptPopupParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("prompt_popup")
    cargs.extend([
        "-message",
        params.get("message", None)
    ])
    if params.get("message_pause", None) is not None:
        cargs.extend([
            "-pause",
            params.get("message_pause", None)
        ])
    if params.get("buttons", None) is not None:
        cargs.extend([
            "-button",
            *params.get("buttons", None)
        ])
    if params.get("buttons_b", None) is not None:
        cargs.extend([
            "-b",
            *params.get("buttons_b", None)
        ])
    if params.get("timeout", None) is not None:
        cargs.extend([
            "-timeout",
            str(params.get("timeout", None))
        ])
    if params.get("timeout_to", None) is not None:
        cargs.extend([
            "-to",
            str(params.get("timeout_to", None))
        ])
    return cargs


def prompt_popup_outputs(
    params: PromptPopupParameters,
    execution: Execution,
) -> PromptPopupOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = PromptPopupOutputs(
        root=execution.output_file("."),
    )
    return ret


def prompt_popup_execute(
    params: PromptPopupParameters,
    runner: Runner | None = None,
) -> PromptPopupOutputs:
    """
    prompt_popup
    
    A command-line tool that pops up a window prompting user interaction with a
    message and buttons.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PromptPopupOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(PROMPT_POPUP_METADATA)
    params = execution.params(params)
    cargs = prompt_popup_cargs(params, execution)
    ret = prompt_popup_outputs(params, execution)
    execution.run(cargs)
    return ret


def prompt_popup(
    message: str,
    message_pause: str | None = None,
    buttons: list[str] | None = None,
    buttons_b: list[str] | None = None,
    timeout: float | None = None,
    timeout_to: float | None = None,
    runner: Runner | None = None,
) -> PromptPopupOutputs:
    """
    prompt_popup
    
    A command-line tool that pops up a window prompting user interaction with a
    message and buttons.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        message: Pops a window prompting the user with MESSAGE. If MESSAGE is\
            '-', it is read from stdin.
        message_pause: Same as -message to match the old prompt_user.
        buttons: What do you want the buttons to say? You can give up to three\
            -button for three buttons. Returns integer 1, 2, or 3. If there is no\
            -button, there will be one button 'Ok'.
        buttons_b: Same as -button.
        timeout: Timeout in seconds of prompt message. Default answer is\
            returned if TT seconds elapse without user input.
        timeout_to: Same as -timeout TT.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PromptPopupOutputs`).
    """
    params = prompt_popup_params(
        message=message,
        message_pause=message_pause,
        buttons=buttons,
        buttons_b=buttons_b,
        timeout=timeout,
        timeout_to=timeout_to,
    )
    return prompt_popup_execute(params, runner)


__all__ = [
    "PROMPT_POPUP_METADATA",
    "PromptPopupOutputs",
    "prompt_popup",
    "prompt_popup_execute",
    "prompt_popup_params",
]
