# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

PROMPT_USER_METADATA = Metadata(
    id="a02a912e9e37f8366cbffb8b82daed3927eaceab.boutiques",
    name="prompt_user",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


PromptUserParameters = typing.TypedDict('PromptUserParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/prompt_user"]],
    "pause_message": str,
    "timeout": typing.NotRequired[float | None],
    "timeout_alias": typing.NotRequired[float | None],
})
PromptUserParametersTagged = typing.TypedDict('PromptUserParametersTagged', {
    "@type": typing.Literal["afni/prompt_user"],
    "pause_message": str,
    "timeout": typing.NotRequired[float | None],
    "timeout_alias": typing.NotRequired[float | None],
})


class PromptUserOutputs(typing.NamedTuple):
    """
    Output object returned when calling `PromptUserParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def prompt_user_params(
    pause_message: str,
    timeout: float | None = None,
    timeout_alias: float | None = None,
) -> PromptUserParametersTagged:
    """
    Build parameters.
    
    Args:
        pause_message: Pops a window prompting the user with MESSAGE. If\
            MESSAGE is '-', it is read from stdin.
        timeout: Timeout in seconds for the prompt message. Default answer is\
            returned if TT seconds elapse without user input.
        timeout_alias: Alias for -timeout.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/prompt_user",
        "pause_message": pause_message,
    }
    if timeout is not None:
        params["timeout"] = timeout
    if timeout_alias is not None:
        params["timeout_alias"] = timeout_alias
    return params


def prompt_user_cargs(
    params: PromptUserParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("prompt_user")
    cargs.extend([
        "<-pause>",
        params.get("pause_message", None)
    ])
    if params.get("timeout", None) is not None:
        cargs.extend([
            "-timeout",
            str(params.get("timeout", None))
        ])
    if params.get("timeout_alias", None) is not None:
        cargs.extend([
            "-to",
            str(params.get("timeout_alias", None))
        ])
    return cargs


def prompt_user_outputs(
    params: PromptUserParameters,
    execution: Execution,
) -> PromptUserOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = PromptUserOutputs(
        root=execution.output_file("."),
    )
    return ret


def prompt_user_execute(
    params: PromptUserParameters,
    runner: Runner | None = None,
) -> PromptUserOutputs:
    """
    prompt_user
    
    Tool that prompts a window requesting user input with a custom message.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PromptUserOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(PROMPT_USER_METADATA)
    params = execution.params(params)
    cargs = prompt_user_cargs(params, execution)
    ret = prompt_user_outputs(params, execution)
    execution.run(cargs)
    return ret


def prompt_user(
    pause_message: str,
    timeout: float | None = None,
    timeout_alias: float | None = None,
    runner: Runner | None = None,
) -> PromptUserOutputs:
    """
    prompt_user
    
    Tool that prompts a window requesting user input with a custom message.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        pause_message: Pops a window prompting the user with MESSAGE. If\
            MESSAGE is '-', it is read from stdin.
        timeout: Timeout in seconds for the prompt message. Default answer is\
            returned if TT seconds elapse without user input.
        timeout_alias: Alias for -timeout.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PromptUserOutputs`).
    """
    params = prompt_user_params(
        pause_message=pause_message,
        timeout=timeout,
        timeout_alias=timeout_alias,
    )
    return prompt_user_execute(params, runner)


__all__ = [
    "PROMPT_USER_METADATA",
    "PromptUserOutputs",
    "prompt_user",
    "prompt_user_execute",
    "prompt_user_params",
]
