# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

PTA_METADATA = Metadata(
    id="68b75e168798ae5dc1df3f812b938ff85744d71e.boutiques",
    name="PTA",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


PtaParameters = typing.TypedDict('PtaParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/PTA"]],
    "prefix": str,
    "input_file": InputPathType,
    "model_formula": str,
    "vt_formulation": typing.NotRequired[str | None],
    "prediction_table": typing.NotRequired[InputPathType | None],
    "verbosity_level": typing.NotRequired[float | None],
    "response_var": typing.NotRequired[str | None],
    "dbg_args": bool,
})
PtaParametersTagged = typing.TypedDict('PtaParametersTagged', {
    "@type": typing.Literal["afni/PTA"],
    "prefix": str,
    "input_file": InputPathType,
    "model_formula": str,
    "vt_formulation": typing.NotRequired[str | None],
    "prediction_table": typing.NotRequired[InputPathType | None],
    "verbosity_level": typing.NotRequired[float | None],
    "response_var": typing.NotRequired[str | None],
    "dbg_args": bool,
})


class PtaOutputs(typing.NamedTuple):
    """
    Output object returned when calling `PtaParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    stat_output: OutputPathType
    """Statistical evidence output of PTA"""
    prediction_output: OutputPathType
    """Predicted values and their standard errors"""


def pta_params(
    prefix: str,
    input_file: InputPathType,
    model_formula: str,
    vt_formulation: str | None = None,
    prediction_table: InputPathType | None = None,
    verbosity_level: float | None = None,
    response_var: str | None = None,
    dbg_args: bool = False,
) -> PtaParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix for output files.
        input_file: Input data file in table format (data frame structure of\
            long format in R).
        model_formula: Model formulation through multilevel smoothing splines.
        vt_formulation: Specify varying smoothing terms. Two components are\
            required: the first one 'var' indicates the variable (e.g., subject)\
            around which the smoothing will vary while the second component\
            specifies the smoothing formulation (e.g., s(age,subject)).
        prediction_table: Data table to generate predicted values for graphical\
            illustration.
        verbosity_level: Verbosity level (0 for quiet, 1 or more for talkative).
        response_var: Column name designated as the response/outcome variable\
            (default is 'Y').
        dbg_args: Enable R to save parameters for debugging.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/PTA",
        "prefix": prefix,
        "input_file": input_file,
        "model_formula": model_formula,
        "dbg_args": dbg_args,
    }
    if vt_formulation is not None:
        params["vt_formulation"] = vt_formulation
    if prediction_table is not None:
        params["prediction_table"] = prediction_table
    if verbosity_level is not None:
        params["verbosity_level"] = verbosity_level
    if response_var is not None:
        params["response_var"] = response_var
    return params


def pta_cargs(
    params: PtaParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("PTA")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file", None))
    ])
    cargs.extend([
        "-model",
        params.get("model_formula", None)
    ])
    if params.get("vt_formulation", None) is not None:
        cargs.extend([
            "-vt",
            params.get("vt_formulation", None)
        ])
    if params.get("prediction_table", None) is not None:
        cargs.extend([
            "-prediction",
            execution.input_file(params.get("prediction_table", None))
        ])
    if params.get("verbosity_level", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbosity_level", None))
        ])
    if params.get("response_var", None) is not None:
        cargs.extend([
            "-Y",
            params.get("response_var", None)
        ])
    if params.get("dbg_args", False):
        cargs.append("-dbgArgs")
    return cargs


def pta_outputs(
    params: PtaParameters,
    execution: Execution,
) -> PtaOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = PtaOutputs(
        root=execution.output_file("."),
        stat_output=execution.output_file(params.get("prefix", None) + "-stat.txt"),
        prediction_output=execution.output_file(params.get("prefix", None) + "-prediction.txt"),
    )
    return ret


def pta_execute(
    params: PtaParameters,
    runner: Runner | None = None,
) -> PtaOutputs:
    """
    PTA
    
    Program for Profile Tracking Analysis - estimates nonlinear trajectories
    through smoothing splines.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PtaOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(PTA_METADATA)
    params = execution.params(params)
    cargs = pta_cargs(params, execution)
    ret = pta_outputs(params, execution)
    execution.run(cargs)
    return ret


def pta(
    prefix: str,
    input_file: InputPathType,
    model_formula: str,
    vt_formulation: str | None = None,
    prediction_table: InputPathType | None = None,
    verbosity_level: float | None = None,
    response_var: str | None = None,
    dbg_args: bool = False,
    runner: Runner | None = None,
) -> PtaOutputs:
    """
    PTA
    
    Program for Profile Tracking Analysis - estimates nonlinear trajectories
    through smoothing splines.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix for output files.
        input_file: Input data file in table format (data frame structure of\
            long format in R).
        model_formula: Model formulation through multilevel smoothing splines.
        vt_formulation: Specify varying smoothing terms. Two components are\
            required: the first one 'var' indicates the variable (e.g., subject)\
            around which the smoothing will vary while the second component\
            specifies the smoothing formulation (e.g., s(age,subject)).
        prediction_table: Data table to generate predicted values for graphical\
            illustration.
        verbosity_level: Verbosity level (0 for quiet, 1 or more for talkative).
        response_var: Column name designated as the response/outcome variable\
            (default is 'Y').
        dbg_args: Enable R to save parameters for debugging.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `PtaOutputs`).
    """
    params = pta_params(
        prefix=prefix,
        input_file=input_file,
        model_formula=model_formula,
        vt_formulation=vt_formulation,
        prediction_table=prediction_table,
        verbosity_level=verbosity_level,
        response_var=response_var,
        dbg_args=dbg_args,
    )
    return pta_execute(params, runner)


__all__ = [
    "PTA_METADATA",
    "PtaOutputs",
    "pta",
    "pta_execute",
    "pta_params",
]
