# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

QHULL_METADATA = Metadata(
    id="7cf282f989e22a92a6d1e41d86ce6515a481efaa.boutiques",
    name="qhull",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


QhullParameters = typing.TypedDict('QhullParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/qhull"]],
    "input_coords": str,
    "delaunay": bool,
    "furthest_delaunay": bool,
    "voronoi": bool,
    "furthest_voronoi": bool,
    "halfspace_intersection": bool,
    "triangulated_output": bool,
    "joggled_input": bool,
    "verify": bool,
    "summary": bool,
    "vertices_incident": bool,
    "normals": bool,
    "vertex_coordinates": bool,
    "halfspace_intersections": bool,
    "extreme_points": bool,
    "total_area_volume": bool,
    "off_format": bool,
    "geomview_output": bool,
    "mathematica_output": bool,
    "print_facets": typing.NotRequired[str | None],
    "output_file": typing.NotRequired[str | None],
})
QhullParametersTagged = typing.TypedDict('QhullParametersTagged', {
    "@type": typing.Literal["afni/qhull"],
    "input_coords": str,
    "delaunay": bool,
    "furthest_delaunay": bool,
    "voronoi": bool,
    "furthest_voronoi": bool,
    "halfspace_intersection": bool,
    "triangulated_output": bool,
    "joggled_input": bool,
    "verify": bool,
    "summary": bool,
    "vertices_incident": bool,
    "normals": bool,
    "vertex_coordinates": bool,
    "halfspace_intersections": bool,
    "extreme_points": bool,
    "total_area_volume": bool,
    "off_format": bool,
    "geomview_output": bool,
    "mathematica_output": bool,
    "print_facets": typing.NotRequired[str | None],
    "output_file": typing.NotRequired[str | None],
})


class QhullOutputs(typing.NamedTuple):
    """
    Output object returned when calling `QhullParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_results: OutputPathType | None
    """Output file with the specified results."""


def qhull_params(
    input_coords: str,
    delaunay: bool = False,
    furthest_delaunay: bool = False,
    voronoi: bool = False,
    furthest_voronoi: bool = False,
    halfspace_intersection: bool = False,
    triangulated_output: bool = False,
    joggled_input: bool = False,
    verify: bool = False,
    summary: bool = False,
    vertices_incident: bool = False,
    normals: bool = False,
    vertex_coordinates: bool = False,
    halfspace_intersections: bool = False,
    extreme_points: bool = False,
    total_area_volume: bool = False,
    off_format: bool = False,
    geomview_output: bool = False,
    mathematica_output: bool = False,
    print_facets: str | None = None,
    output_file: str | None = None,
) -> QhullParametersTagged:
    """
    Build parameters.
    
    Args:
        input_coords: Dimension, number of points, and point coordinates\
            provided via stdin.
        delaunay: Compute Delaunay triangulation by lifting points to a\
            paraboloid.
        furthest_delaunay: Compute furthest-site Delaunay triangulation (upper\
            convex hull).
        voronoi: Compute Voronoi diagram as the dual of the Delaunay\
            triangulation.
        furthest_voronoi: Compute furthest-site Voronoi diagram.
        halfspace_intersection: Compute halfspace intersection about\
            [1,1,0,...] via polar duality.
        triangulated_output: Triangulated output.
        joggled_input: Joggled input instead of merged facets.
        verify: Verify result: structure, convexity, and point inclusion.
        summary: Summary of results.
        vertices_incident: Vertices incident to each facet.
        normals: Normals with offsets.
        vertex_coordinates: Vertex coordinates (if 'Qc', includes coplanar\
            points). If 'v', Voronoi vertices.
        halfspace_intersections: Halfspace intersections.
        extreme_points: Extreme points (convex hull vertices).
        total_area_volume: Compute total area and volume.
        off_format: OFF format (if 'v', outputs Voronoi regions).
        geomview_output: Geomview output (2-d, 3-d and 4-d).
        mathematica_output: Mathematica output (2-d and 3-d).
        print_facets: Print facets that include point n, -n if not.
        output_file: Output results to file.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/qhull",
        "input_coords": input_coords,
        "delaunay": delaunay,
        "furthest_delaunay": furthest_delaunay,
        "voronoi": voronoi,
        "furthest_voronoi": furthest_voronoi,
        "halfspace_intersection": halfspace_intersection,
        "triangulated_output": triangulated_output,
        "joggled_input": joggled_input,
        "verify": verify,
        "summary": summary,
        "vertices_incident": vertices_incident,
        "normals": normals,
        "vertex_coordinates": vertex_coordinates,
        "halfspace_intersections": halfspace_intersections,
        "extreme_points": extreme_points,
        "total_area_volume": total_area_volume,
        "off_format": off_format,
        "geomview_output": geomview_output,
        "mathematica_output": mathematica_output,
    }
    if print_facets is not None:
        params["print_facets"] = print_facets
    if output_file is not None:
        params["output_file"] = output_file
    return params


def qhull_cargs(
    params: QhullParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("qhull")
    cargs.append(params.get("input_coords", None))
    if params.get("delaunay", False):
        cargs.append("d")
    if params.get("furthest_delaunay", False):
        cargs.append("d Qu")
    if params.get("voronoi", False):
        cargs.append("v")
    if params.get("furthest_voronoi", False):
        cargs.append("v Qu")
    if params.get("halfspace_intersection", False):
        cargs.append("H1,1")
    if params.get("triangulated_output", False):
        cargs.append("Qt")
    if params.get("joggled_input", False):
        cargs.append("QJ")
    if params.get("verify", False):
        cargs.append("Tv")
    if params.get("summary", False):
        cargs.append("s")
    if params.get("vertices_incident", False):
        cargs.append("i")
    if params.get("normals", False):
        cargs.append("n")
    if params.get("vertex_coordinates", False):
        cargs.append("p")
    if params.get("halfspace_intersections", False):
        cargs.append("Fp")
    if params.get("extreme_points", False):
        cargs.append("Fx")
    if params.get("total_area_volume", False):
        cargs.append("FA")
    if params.get("off_format", False):
        cargs.append("o")
    if params.get("geomview_output", False):
        cargs.append("G")
    if params.get("mathematica_output", False):
        cargs.append("m")
    if params.get("print_facets", None) is not None:
        cargs.extend([
            "QVn",
            params.get("print_facets", None)
        ])
    if params.get("output_file", None) is not None:
        cargs.extend([
            "TO",
            params.get("output_file", None)
        ])
    return cargs


def qhull_outputs(
    params: QhullParameters,
    execution: Execution,
) -> QhullOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = QhullOutputs(
        root=execution.output_file("."),
        output_results=execution.output_file(params.get("output_file", None) + ".txt") if (params.get("output_file") is not None) else None,
    )
    return ret


def qhull_execute(
    params: QhullParameters,
    runner: Runner | None = None,
) -> QhullOutputs:
    """
    qhull
    
    Tool to compute convex hulls and related structures.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `QhullOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(QHULL_METADATA)
    params = execution.params(params)
    cargs = qhull_cargs(params, execution)
    ret = qhull_outputs(params, execution)
    execution.run(cargs)
    return ret


def qhull(
    input_coords: str,
    delaunay: bool = False,
    furthest_delaunay: bool = False,
    voronoi: bool = False,
    furthest_voronoi: bool = False,
    halfspace_intersection: bool = False,
    triangulated_output: bool = False,
    joggled_input: bool = False,
    verify: bool = False,
    summary: bool = False,
    vertices_incident: bool = False,
    normals: bool = False,
    vertex_coordinates: bool = False,
    halfspace_intersections: bool = False,
    extreme_points: bool = False,
    total_area_volume: bool = False,
    off_format: bool = False,
    geomview_output: bool = False,
    mathematica_output: bool = False,
    print_facets: str | None = None,
    output_file: str | None = None,
    runner: Runner | None = None,
) -> QhullOutputs:
    """
    qhull
    
    Tool to compute convex hulls and related structures.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_coords: Dimension, number of points, and point coordinates\
            provided via stdin.
        delaunay: Compute Delaunay triangulation by lifting points to a\
            paraboloid.
        furthest_delaunay: Compute furthest-site Delaunay triangulation (upper\
            convex hull).
        voronoi: Compute Voronoi diagram as the dual of the Delaunay\
            triangulation.
        furthest_voronoi: Compute furthest-site Voronoi diagram.
        halfspace_intersection: Compute halfspace intersection about\
            [1,1,0,...] via polar duality.
        triangulated_output: Triangulated output.
        joggled_input: Joggled input instead of merged facets.
        verify: Verify result: structure, convexity, and point inclusion.
        summary: Summary of results.
        vertices_incident: Vertices incident to each facet.
        normals: Normals with offsets.
        vertex_coordinates: Vertex coordinates (if 'Qc', includes coplanar\
            points). If 'v', Voronoi vertices.
        halfspace_intersections: Halfspace intersections.
        extreme_points: Extreme points (convex hull vertices).
        total_area_volume: Compute total area and volume.
        off_format: OFF format (if 'v', outputs Voronoi regions).
        geomview_output: Geomview output (2-d, 3-d and 4-d).
        mathematica_output: Mathematica output (2-d and 3-d).
        print_facets: Print facets that include point n, -n if not.
        output_file: Output results to file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `QhullOutputs`).
    """
    params = qhull_params(
        input_coords=input_coords,
        delaunay=delaunay,
        furthest_delaunay=furthest_delaunay,
        voronoi=voronoi,
        furthest_voronoi=furthest_voronoi,
        halfspace_intersection=halfspace_intersection,
        triangulated_output=triangulated_output,
        joggled_input=joggled_input,
        verify=verify,
        summary=summary,
        vertices_incident=vertices_incident,
        normals=normals,
        vertex_coordinates=vertex_coordinates,
        halfspace_intersections=halfspace_intersections,
        extreme_points=extreme_points,
        total_area_volume=total_area_volume,
        off_format=off_format,
        geomview_output=geomview_output,
        mathematica_output=mathematica_output,
        print_facets=print_facets,
        output_file=output_file,
    )
    return qhull_execute(params, runner)


__all__ = [
    "QHULL_METADATA",
    "QhullOutputs",
    "qhull",
    "qhull_execute",
    "qhull_params",
]
