# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

QUICK_ALPHA_VALS_PY_METADATA = Metadata(
    id="240a9d3e24a1a2d167b06636e882d90d255a2a3c.boutiques",
    name="quick.alpha.vals.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


QuickAlphaValsPyParameters = typing.TypedDict('QuickAlphaValsPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/quick.alpha.vals.py"]],
    "niter": typing.NotRequired[int | None],
    "max_file": InputPathType,
})
QuickAlphaValsPyParametersTagged = typing.TypedDict('QuickAlphaValsPyParametersTagged', {
    "@type": typing.Literal["afni/quick.alpha.vals.py"],
    "niter": typing.NotRequired[int | None],
    "max_file": InputPathType,
})


class QuickAlphaValsPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `QuickAlphaValsPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    alpha_table: OutputPathType
    """Generated alpha table file"""


def quick_alpha_vals_py_params(
    max_file: InputPathType,
    niter: int | None = None,
) -> QuickAlphaValsPyParametersTagged:
    """
    Build parameters.
    
    Args:
        max_file: File containing maximum z values.
        niter: Number of iterations that should be in the z file.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/quick.alpha.vals.py",
        "max_file": max_file,
    }
    if niter is not None:
        params["niter"] = niter
    return params


def quick_alpha_vals_py_cargs(
    params: QuickAlphaValsPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("quick.alpha.vals.py")
    if params.get("niter", None) is not None:
        cargs.extend([
            "-niter",
            str(params.get("niter", None))
        ])
    cargs.append(execution.input_file(params.get("max_file", None)))
    return cargs


def quick_alpha_vals_py_outputs(
    params: QuickAlphaValsPyParameters,
    execution: Execution,
) -> QuickAlphaValsPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = QuickAlphaValsPyOutputs(
        root=execution.output_file("."),
        alpha_table=execution.output_file("alpha_table.txt"),
    )
    return ret


def quick_alpha_vals_py_execute(
    params: QuickAlphaValsPyParameters,
    runner: Runner | None = None,
) -> QuickAlphaValsPyOutputs:
    """
    quick.alpha.vals.py
    
    Generate an alpha table from slow_surf_clustsim.py results.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `QuickAlphaValsPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(QUICK_ALPHA_VALS_PY_METADATA)
    params = execution.params(params)
    cargs = quick_alpha_vals_py_cargs(params, execution)
    ret = quick_alpha_vals_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def quick_alpha_vals_py(
    max_file: InputPathType,
    niter: int | None = None,
    runner: Runner | None = None,
) -> QuickAlphaValsPyOutputs:
    """
    quick.alpha.vals.py
    
    Generate an alpha table from slow_surf_clustsim.py results.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        max_file: File containing maximum z values.
        niter: Number of iterations that should be in the z file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `QuickAlphaValsPyOutputs`).
    """
    params = quick_alpha_vals_py_params(
        niter=niter,
        max_file=max_file,
    )
    return quick_alpha_vals_py_execute(params, runner)


__all__ = [
    "QUICK_ALPHA_VALS_PY_METADATA",
    "QuickAlphaValsPyOutputs",
    "quick_alpha_vals_py",
    "quick_alpha_vals_py_execute",
    "quick_alpha_vals_py_params",
]
