# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

R_PKGS_INSTALL_METADATA = Metadata(
    id="21bbac9c8d45c10c34e4107732268562b9494893.boutiques",
    name="rPkgsInstall",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


RPkgsInstallParameters = typing.TypedDict('RPkgsInstallParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/rPkgsInstall"]],
    "packages": str,
    "download_site": typing.NotRequired[str | None],
    "check": bool,
    "update": bool,
    "remove": bool,
})
RPkgsInstallParametersTagged = typing.TypedDict('RPkgsInstallParametersTagged', {
    "@type": typing.Literal["afni/rPkgsInstall"],
    "packages": str,
    "download_site": typing.NotRequired[str | None],
    "check": bool,
    "update": bool,
    "remove": bool,
})


class RPkgsInstallOutputs(typing.NamedTuple):
    """
    Output object returned when calling `RPkgsInstallParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_packages: OutputPathType
    """Output R packages after installation, update, or removal"""


def r_pkgs_install_params(
    packages: str,
    download_site: str | None = None,
    check: bool = False,
    update_: bool = False,
    remove: bool = False,
) -> RPkgsInstallParametersTagged:
    """
    Build parameters.
    
    Args:
        packages: List of R packages to install, update, or remove. Use 'ALL'\
            to refer to all AFNI-required packages.
        download_site: Specify the package repository website. Default is\
            'http://cloud.r-project.org'.
        check: Verify whether the specified R packages are installed on the\
            computer without installing/updating/removing them.
        update_: Update the specified R packages. If packages are not\
            installed, they will be installed.
        remove: Remove the specified R packages from the system.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/rPkgsInstall",
        "packages": packages,
        "check": check,
        "update": update_,
        "remove": remove,
    }
    if download_site is not None:
        params["download_site"] = download_site
    return params


def r_pkgs_install_cargs(
    params: RPkgsInstallParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("rPkgsInstall")
    cargs.extend([
        "-pkgs",
        params.get("packages", None)
    ])
    if params.get("download_site", None) is not None:
        cargs.extend([
            "-site",
            params.get("download_site", None)
        ])
    if params.get("check", False):
        cargs.append("-check")
    if params.get("update", False):
        cargs.append("-update")
    if params.get("remove", False):
        cargs.append("-remove")
    return cargs


def r_pkgs_install_outputs(
    params: RPkgsInstallParameters,
    execution: Execution,
) -> RPkgsInstallOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = RPkgsInstallOutputs(
        root=execution.output_file("."),
        output_packages=execution.output_file(params.get("packages", None)),
    )
    return ret


def r_pkgs_install_execute(
    params: RPkgsInstallParameters,
    runner: Runner | None = None,
) -> RPkgsInstallOutputs:
    """
    rPkgsInstall
    
    A tool for installing, checking, updating, or removing R packages for AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `RPkgsInstallOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(R_PKGS_INSTALL_METADATA)
    params = execution.params(params)
    cargs = r_pkgs_install_cargs(params, execution)
    ret = r_pkgs_install_outputs(params, execution)
    execution.run(cargs)
    return ret


def r_pkgs_install(
    packages: str,
    download_site: str | None = None,
    check: bool = False,
    update_: bool = False,
    remove: bool = False,
    runner: Runner | None = None,
) -> RPkgsInstallOutputs:
    """
    rPkgsInstall
    
    A tool for installing, checking, updating, or removing R packages for AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        packages: List of R packages to install, update, or remove. Use 'ALL'\
            to refer to all AFNI-required packages.
        download_site: Specify the package repository website. Default is\
            'http://cloud.r-project.org'.
        check: Verify whether the specified R packages are installed on the\
            computer without installing/updating/removing them.
        update_: Update the specified R packages. If packages are not\
            installed, they will be installed.
        remove: Remove the specified R packages from the system.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `RPkgsInstallOutputs`).
    """
    params = r_pkgs_install_params(
        packages=packages,
        download_site=download_site,
        check=check,
        update_=update_,
        remove=remove,
    )
    return r_pkgs_install_execute(params, runner)


__all__ = [
    "RPkgsInstallOutputs",
    "R_PKGS_INSTALL_METADATA",
    "r_pkgs_install",
    "r_pkgs_install_execute",
    "r_pkgs_install_params",
]
