# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

RBOX_METADATA = Metadata(
    id="e0ab2950b88a47b196779cd3aaf7eead632b4814.boutiques",
    name="rbox",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


RboxParameters = typing.TypedDict('RboxParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/rbox"]],
    "number_points": str,
    "dimension": typing.NotRequired[str | None],
    "unit_cube": bool,
    "unit_diamond": bool,
    "spiral": bool,
    "regular_polygon": bool,
    "cospherical_points": bool,
    "simplex_points": bool,
    "simplex_plus_points": bool,
    "add_point": typing.NotRequired[list[str] | None],
    "lens_distribution": typing.NotRequired[str | None],
    "random_within": bool,
    "random_disk": typing.NotRequired[str | None],
    "bounding_box": typing.NotRequired[float | None],
    "homogeneous_coordinates": bool,
    "remove_command_line": bool,
    "time_seed": bool,
    "integer_coordinates": bool,
    "offset": typing.NotRequired[float | None],
    "user_seed": typing.NotRequired[float | None],
    "mesh_lattice": typing.NotRequired[list[str] | None],
})
RboxParametersTagged = typing.TypedDict('RboxParametersTagged', {
    "@type": typing.Literal["afni/rbox"],
    "number_points": str,
    "dimension": typing.NotRequired[str | None],
    "unit_cube": bool,
    "unit_diamond": bool,
    "spiral": bool,
    "regular_polygon": bool,
    "cospherical_points": bool,
    "simplex_points": bool,
    "simplex_plus_points": bool,
    "add_point": typing.NotRequired[list[str] | None],
    "lens_distribution": typing.NotRequired[str | None],
    "random_within": bool,
    "random_disk": typing.NotRequired[str | None],
    "bounding_box": typing.NotRequired[float | None],
    "homogeneous_coordinates": bool,
    "remove_command_line": bool,
    "time_seed": bool,
    "integer_coordinates": bool,
    "offset": typing.NotRequired[float | None],
    "user_seed": typing.NotRequired[float | None],
    "mesh_lattice": typing.NotRequired[list[str] | None],
})


class RboxOutputs(typing.NamedTuple):
    """
    Output object returned when calling `RboxParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def rbox_params(
    number_points: str,
    dimension: str | None = None,
    unit_cube: bool = False,
    unit_diamond: bool = False,
    spiral: bool = False,
    regular_polygon: bool = False,
    cospherical_points: bool = False,
    simplex_points: bool = False,
    simplex_plus_points: bool = False,
    add_point: list[str] | None = None,
    lens_distribution: str | None = None,
    random_within: bool = False,
    random_disk: str | None = None,
    bounding_box: float | None = None,
    homogeneous_coordinates: bool = False,
    remove_command_line: bool = False,
    time_seed: bool = False,
    integer_coordinates: bool = False,
    offset: float | None = None,
    user_seed: float | None = None,
    mesh_lattice: list[str] | None = None,
) -> RboxParametersTagged:
    """
    Build parameters.
    
    Args:
        number_points: Number of random points in cube, lens, spiral, sphere or\
            grid.
        dimension: Dimension (e.g., D3 for 3-d).
        unit_cube: Add a unit cube to the output (optional: 'c G2.0' sets size).
        unit_diamond: Add a unit diamond to the output (optional: 'd G2.0' sets\
            size).
        spiral: Generate a regular 3-d spiral.
        regular_polygon: Generate a regular polygon (optional: 'r s Z1 G0.1'\
            makes a cone).
        cospherical_points: Generate cospherical points.
        simplex_points: Generate random points in simplex, may use 'r' or 'Wn'.
        simplex_plus_points: Same as 'x', plus simplex.
        add_point: Add point [n,m,r] first, pads with 0.
        lens_distribution: Lens distribution of radius n. Also 's', 'r', 'G',\
            'W'.
        random_within: Random distribution within 0.1 of the cube's or sphere's\
            surface.
        random_disk: Random points in a 0.5 disk projected to a sphere,\
            optional gap size (e.g., 'Z0.5 s G0.6').
        bounding_box: Bounding box coordinates, default 0.5.
        homogeneous_coordinates: Output as homogeneous coordinates for cdd.
        remove_command_line: Remove command line from the first line of output.
        time_seed: Use time as the random number seed (default is command line).
        integer_coordinates: Print integer coordinates, default 'Bn' is 1e+06.
        offset: Offset coordinates by n.
        user_seed: Use n as the random number seed.
        mesh_lattice: Lattice (Mesh) rotated by [n,-m,0], [m,n,0], [0,0,r], ...
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/rbox",
        "number_points": number_points,
        "unit_cube": unit_cube,
        "unit_diamond": unit_diamond,
        "spiral": spiral,
        "regular_polygon": regular_polygon,
        "cospherical_points": cospherical_points,
        "simplex_points": simplex_points,
        "simplex_plus_points": simplex_plus_points,
        "random_within": random_within,
        "homogeneous_coordinates": homogeneous_coordinates,
        "remove_command_line": remove_command_line,
        "time_seed": time_seed,
        "integer_coordinates": integer_coordinates,
    }
    if dimension is not None:
        params["dimension"] = dimension
    if add_point is not None:
        params["add_point"] = add_point
    if lens_distribution is not None:
        params["lens_distribution"] = lens_distribution
    if random_disk is not None:
        params["random_disk"] = random_disk
    if bounding_box is not None:
        params["bounding_box"] = bounding_box
    if offset is not None:
        params["offset"] = offset
    if user_seed is not None:
        params["user_seed"] = user_seed
    if mesh_lattice is not None:
        params["mesh_lattice"] = mesh_lattice
    return params


def rbox_cargs(
    params: RboxParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("rbox")
    cargs.append(params.get("number_points", None))
    if params.get("dimension", None) is not None:
        cargs.append(params.get("dimension", None))
    if params.get("unit_cube", False):
        cargs.append("c")
    if params.get("unit_diamond", False):
        cargs.append("d")
    if params.get("spiral", False):
        cargs.append("l")
    if params.get("regular_polygon", False):
        cargs.append("r")
    if params.get("cospherical_points", False):
        cargs.append("s")
    if params.get("simplex_points", False):
        cargs.append("x")
    if params.get("simplex_plus_points", False):
        cargs.append("y")
    if params.get("add_point", None) is not None:
        cargs.extend([
            "P",
            *params.get("add_point", None)
        ])
    if params.get("lens_distribution", None) is not None:
        cargs.extend([
            "L",
            params.get("lens_distribution", None)
        ])
    if params.get("random_within", False):
        cargs.append("W")
    if params.get("random_disk", None) is not None:
        cargs.extend([
            "Z",
            params.get("random_disk", None)
        ])
    if params.get("bounding_box", None) is not None:
        cargs.extend([
            "B",
            str(params.get("bounding_box", None))
        ])
    if params.get("homogeneous_coordinates", False):
        cargs.append("h")
    if params.get("remove_command_line", False):
        cargs.append("n")
    if params.get("time_seed", False):
        cargs.append("t")
    if params.get("integer_coordinates", False):
        cargs.append("z")
    if params.get("offset", None) is not None:
        cargs.extend([
            "O",
            str(params.get("offset", None))
        ])
    if params.get("user_seed", None) is not None:
        cargs.extend([
            "t",
            str(params.get("user_seed", None))
        ])
    if params.get("mesh_lattice", None) is not None:
        cargs.extend([
            "M",
            *params.get("mesh_lattice", None)
        ])
    return cargs


def rbox_outputs(
    params: RboxParameters,
    execution: Execution,
) -> RboxOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = RboxOutputs(
        root=execution.output_file("."),
    )
    return ret


def rbox_execute(
    params: RboxParameters,
    runner: Runner | None = None,
) -> RboxOutputs:
    """
    rbox
    
    Generate various point distributions. Default is random in cube.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `RboxOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(RBOX_METADATA)
    params = execution.params(params)
    cargs = rbox_cargs(params, execution)
    ret = rbox_outputs(params, execution)
    execution.run(cargs)
    return ret


def rbox(
    number_points: str,
    dimension: str | None = None,
    unit_cube: bool = False,
    unit_diamond: bool = False,
    spiral: bool = False,
    regular_polygon: bool = False,
    cospherical_points: bool = False,
    simplex_points: bool = False,
    simplex_plus_points: bool = False,
    add_point: list[str] | None = None,
    lens_distribution: str | None = None,
    random_within: bool = False,
    random_disk: str | None = None,
    bounding_box: float | None = None,
    homogeneous_coordinates: bool = False,
    remove_command_line: bool = False,
    time_seed: bool = False,
    integer_coordinates: bool = False,
    offset: float | None = None,
    user_seed: float | None = None,
    mesh_lattice: list[str] | None = None,
    runner: Runner | None = None,
) -> RboxOutputs:
    """
    rbox
    
    Generate various point distributions. Default is random in cube.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        number_points: Number of random points in cube, lens, spiral, sphere or\
            grid.
        dimension: Dimension (e.g., D3 for 3-d).
        unit_cube: Add a unit cube to the output (optional: 'c G2.0' sets size).
        unit_diamond: Add a unit diamond to the output (optional: 'd G2.0' sets\
            size).
        spiral: Generate a regular 3-d spiral.
        regular_polygon: Generate a regular polygon (optional: 'r s Z1 G0.1'\
            makes a cone).
        cospherical_points: Generate cospherical points.
        simplex_points: Generate random points in simplex, may use 'r' or 'Wn'.
        simplex_plus_points: Same as 'x', plus simplex.
        add_point: Add point [n,m,r] first, pads with 0.
        lens_distribution: Lens distribution of radius n. Also 's', 'r', 'G',\
            'W'.
        random_within: Random distribution within 0.1 of the cube's or sphere's\
            surface.
        random_disk: Random points in a 0.5 disk projected to a sphere,\
            optional gap size (e.g., 'Z0.5 s G0.6').
        bounding_box: Bounding box coordinates, default 0.5.
        homogeneous_coordinates: Output as homogeneous coordinates for cdd.
        remove_command_line: Remove command line from the first line of output.
        time_seed: Use time as the random number seed (default is command line).
        integer_coordinates: Print integer coordinates, default 'Bn' is 1e+06.
        offset: Offset coordinates by n.
        user_seed: Use n as the random number seed.
        mesh_lattice: Lattice (Mesh) rotated by [n,-m,0], [m,n,0], [0,0,r], ...
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `RboxOutputs`).
    """
    params = rbox_params(
        number_points=number_points,
        dimension=dimension,
        unit_cube=unit_cube,
        unit_diamond=unit_diamond,
        spiral=spiral,
        regular_polygon=regular_polygon,
        cospherical_points=cospherical_points,
        simplex_points=simplex_points,
        simplex_plus_points=simplex_plus_points,
        add_point=add_point,
        lens_distribution=lens_distribution,
        random_within=random_within,
        random_disk=random_disk,
        bounding_box=bounding_box,
        homogeneous_coordinates=homogeneous_coordinates,
        remove_command_line=remove_command_line,
        time_seed=time_seed,
        integer_coordinates=integer_coordinates,
        offset=offset,
        user_seed=user_seed,
        mesh_lattice=mesh_lattice,
    )
    return rbox_execute(params, runner)


__all__ = [
    "RBOX_METADATA",
    "RboxOutputs",
    "rbox",
    "rbox_execute",
    "rbox_params",
]
