# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

READ_MATLAB_FILES_PY_METADATA = Metadata(
    id="b2992267cf3b556de790bd538f9e886b0ec131db.boutiques",
    name="read_matlab_files.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


ReadMatlabFilesPyParameters = typing.TypedDict('ReadMatlabFilesPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/read_matlab_files.py"]],
    "infiles": list[str],
    "prefix": typing.NotRequired[str | None],
    "overwrite": bool,
    "help": bool,
    "history": bool,
    "version": bool,
})
ReadMatlabFilesPyParametersTagged = typing.TypedDict('ReadMatlabFilesPyParametersTagged', {
    "@type": typing.Literal["afni/read_matlab_files.py"],
    "infiles": list[str],
    "prefix": typing.NotRequired[str | None],
    "overwrite": bool,
    "help": bool,
    "history": bool,
    "version": bool,
})


class ReadMatlabFilesPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `ReadMatlabFilesPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    converted_1d_file: OutputPathType | None
    """Converted 1D format file"""


def read_matlab_files_py_params(
    infiles: list[str],
    prefix: str | None = None,
    overwrite: bool = False,
    help_: bool = False,
    history: bool = False,
    version: bool = False,
) -> ReadMatlabFilesPyParametersTagged:
    """
    Build parameters.
    
    Args:
        infiles: Input MATLAB files to be processed.
        prefix: Prefix for output file names.
        overwrite: Overwrite any existing output files.
        help_: Show help message.
        history: Show revision history.
        version: Show version number.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/read_matlab_files.py",
        "infiles": infiles,
        "overwrite": overwrite,
        "help": help_,
        "history": history,
        "version": version,
    }
    if prefix is not None:
        params["prefix"] = prefix
    return params


def read_matlab_files_py_cargs(
    params: ReadMatlabFilesPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("read_matlab_files.py")
    cargs.extend(params.get("infiles", None))
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("overwrite", False):
        cargs.append("-overwrite")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("history", False):
        cargs.append("-hist")
    if params.get("version", False):
        cargs.append("-ver")
    return cargs


def read_matlab_files_py_outputs(
    params: ReadMatlabFilesPyParameters,
    execution: Execution,
) -> ReadMatlabFilesPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = ReadMatlabFilesPyOutputs(
        root=execution.output_file("."),
        converted_1d_file=execution.output_file(params.get("prefix", None) + ".[INDEX].[KEY].1D") if (params.get("prefix") is not None) else None,
    )
    return ret


def read_matlab_files_py_execute(
    params: ReadMatlabFilesPyParameters,
    runner: Runner | None = None,
) -> ReadMatlabFilesPyOutputs:
    """
    read_matlab_files.py
    
    Describe or convert MATLAB files (.mat) to 1D format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ReadMatlabFilesPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(READ_MATLAB_FILES_PY_METADATA)
    params = execution.params(params)
    cargs = read_matlab_files_py_cargs(params, execution)
    ret = read_matlab_files_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def read_matlab_files_py(
    infiles: list[str],
    prefix: str | None = None,
    overwrite: bool = False,
    help_: bool = False,
    history: bool = False,
    version: bool = False,
    runner: Runner | None = None,
) -> ReadMatlabFilesPyOutputs:
    """
    read_matlab_files.py
    
    Describe or convert MATLAB files (.mat) to 1D format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infiles: Input MATLAB files to be processed.
        prefix: Prefix for output file names.
        overwrite: Overwrite any existing output files.
        help_: Show help message.
        history: Show revision history.
        version: Show version number.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `ReadMatlabFilesPyOutputs`).
    """
    params = read_matlab_files_py_params(
        infiles=infiles,
        prefix=prefix,
        overwrite=overwrite,
        help_=help_,
        history=history,
        version=version,
    )
    return read_matlab_files_py_execute(params, runner)


__all__ = [
    "READ_MATLAB_FILES_PY_METADATA",
    "ReadMatlabFilesPyOutputs",
    "read_matlab_files_py",
    "read_matlab_files_py_execute",
    "read_matlab_files_py_params",
]
