# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

ROTCOM_METADATA = Metadata(
    id="cedbefcf10a28280103e75a171cb3de8c47463b6.boutiques",
    name="rotcom",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


RotcomParameters = typing.TypedDict('RotcomParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/rotcom"]],
    "rotate_ashift": str,
    "dataset": typing.NotRequired[InputPathType | None],
})
RotcomParametersTagged = typing.TypedDict('RotcomParametersTagged', {
    "@type": typing.Literal["afni/rotcom"],
    "rotate_ashift": str,
    "dataset": typing.NotRequired[InputPathType | None],
})


class RotcomOutputs(typing.NamedTuple):
    """
    Output object returned when calling `RotcomParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    stdout: OutputPathType
    """The 4x3 transformation matrix+vector output"""


def rotcom_params(
    rotate_ashift: str,
    dataset: InputPathType | None = None,
) -> RotcomParametersTagged:
    """
    Build parameters.
    
    Args:
        rotate_ashift: Combination of rotate and ashift options in a single\
            quoted string (e.g., '-rotate 10I 0R 0A -ashift 5S 0 0').
        dataset: Input dataset for determining coordinate order.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/rotcom",
        "rotate_ashift": rotate_ashift,
    }
    if dataset is not None:
        params["dataset"] = dataset
    return params


def rotcom_cargs(
    params: RotcomParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("rotcom")
    cargs.append(params.get("rotate_ashift", None))
    if params.get("dataset", None) is not None:
        cargs.append(execution.input_file(params.get("dataset", None)))
    return cargs


def rotcom_outputs(
    params: RotcomParameters,
    execution: Execution,
) -> RotcomOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = RotcomOutputs(
        root=execution.output_file("."),
        stdout=execution.output_file("stdout"),
    )
    return ret


def rotcom_execute(
    params: RotcomParameters,
    runner: Runner | None = None,
) -> RotcomOutputs:
    """
    rotcom
    
    Prints to stdout the 4x3 transformation matrix+vector that would be applied
    by 3drotate to the given dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `RotcomOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(ROTCOM_METADATA)
    params = execution.params(params)
    cargs = rotcom_cargs(params, execution)
    ret = rotcom_outputs(params, execution)
    execution.run(cargs)
    return ret


def rotcom(
    rotate_ashift: str,
    dataset: InputPathType | None = None,
    runner: Runner | None = None,
) -> RotcomOutputs:
    """
    rotcom
    
    Prints to stdout the 4x3 transformation matrix+vector that would be applied
    by 3drotate to the given dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        rotate_ashift: Combination of rotate and ashift options in a single\
            quoted string (e.g., '-rotate 10I 0R 0A -ashift 5S 0 0').
        dataset: Input dataset for determining coordinate order.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `RotcomOutputs`).
    """
    params = rotcom_params(
        rotate_ashift=rotate_ashift,
        dataset=dataset,
    )
    return rotcom_execute(params, runner)


__all__ = [
    "ROTCOM_METADATA",
    "RotcomOutputs",
    "rotcom",
    "rotcom_execute",
    "rotcom_params",
]
