# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

RTFEEDME_METADATA = Metadata(
    id="031662f7ace1e435c0c343699a3380e8eef5d84a.boutiques",
    name="rtfeedme",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


RtfeedmeParameters = typing.TypedDict('RtfeedmeParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/rtfeedme"]],
    "datasets": list[InputPathType],
    "host": typing.NotRequired[str | None],
    "interval_ms": typing.NotRequired[float | None],
    "send_3d": bool,
    "buffer_mb": typing.NotRequired[float | None],
    "verbose": bool,
    "swap_bytes": bool,
    "nz_fake": typing.NotRequired[float | None],
    "drive_cmd": typing.NotRequired[list[str] | None],
    "note": typing.NotRequired[list[str] | None],
    "yrange": typing.NotRequired[float | None],
})
RtfeedmeParametersTagged = typing.TypedDict('RtfeedmeParametersTagged', {
    "@type": typing.Literal["afni/rtfeedme"],
    "datasets": list[InputPathType],
    "host": typing.NotRequired[str | None],
    "interval_ms": typing.NotRequired[float | None],
    "send_3d": bool,
    "buffer_mb": typing.NotRequired[float | None],
    "verbose": bool,
    "swap_bytes": bool,
    "nz_fake": typing.NotRequired[float | None],
    "drive_cmd": typing.NotRequired[list[str] | None],
    "note": typing.NotRequired[list[str] | None],
    "yrange": typing.NotRequired[float | None],
})


class RtfeedmeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `RtfeedmeParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def rtfeedme_params(
    datasets: list[InputPathType],
    host: str | None = None,
    interval_ms: float | None = None,
    send_3d: bool = False,
    buffer_mb: float | None = None,
    verbose: bool = False,
    swap_bytes: bool = False,
    nz_fake: float | None = None,
    drive_cmd: list[str] | None = None,
    note: list[str] | None = None,
    yrange: float | None = None,
) -> RtfeedmeParametersTagged:
    """
    Build parameters.
    
    Args:
        datasets: List of datasets to send to AFNI, specified as paths to\
            dataset files. Multiple datasets can be specified.
        host: Send data via TCP/IP to AFNI running on the specified computer\
            system 'sname'. Default is the current system using shared memory. Use\
            'localhost' to send on the current system using TCP/IP.
        interval_ms: Inter-transmit interval in milliseconds. Default is to\
            send data as fast as possible.
        send_3d: Send data in 3D bricks. Default is 2D slices.
        buffer_mb: Set the interprocess communications buffer size in megabytes\
            when using shared memory. Has no effect if using TCP/IP. Default is 1\
            MB; if set to 0, a 50 KB buffer is used.
        verbose: Be talkative about actions.
        swap_bytes: Swap byte pairs before sending data.
        nz_fake: Send 'nz' as the value of nzz for debugging purposes.
        drive_cmd: Send 'cmd' as a DRIVE_AFNI command. If 'cmd' contains\
            spaces, it must be quoted. Multiple -drive options can be used.
        note: Send 'sss' as a NOTE to the realtime plugin. Multiple -note\
            options can be used.
        yrange: Send value 'v' as the y-range for realtime motion estimation\
            graphing.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/rtfeedme",
        "datasets": datasets,
        "send_3d": send_3d,
        "verbose": verbose,
        "swap_bytes": swap_bytes,
    }
    if host is not None:
        params["host"] = host
    if interval_ms is not None:
        params["interval_ms"] = interval_ms
    if buffer_mb is not None:
        params["buffer_mb"] = buffer_mb
    if nz_fake is not None:
        params["nz_fake"] = nz_fake
    if drive_cmd is not None:
        params["drive_cmd"] = drive_cmd
    if note is not None:
        params["note"] = note
    if yrange is not None:
        params["yrange"] = yrange
    return params


def rtfeedme_cargs(
    params: RtfeedmeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("rtfeedme")
    cargs.extend([execution.input_file(f) for f in params.get("datasets", None)])
    if params.get("host", None) is not None:
        cargs.extend([
            "-host",
            params.get("host", None)
        ])
    if params.get("interval_ms", None) is not None:
        cargs.extend([
            "-dt",
            str(params.get("interval_ms", None))
        ])
    if params.get("send_3d", False):
        cargs.append("-3D")
    if params.get("buffer_mb", None) is not None:
        cargs.extend([
            "-buf",
            str(params.get("buffer_mb", None))
        ])
    if params.get("verbose", False):
        cargs.append("-verbose")
    if params.get("swap_bytes", False):
        cargs.append("-swap2")
    if params.get("nz_fake", None) is not None:
        cargs.extend([
            "-nzfake",
            str(params.get("nz_fake", None))
        ])
    if params.get("drive_cmd", None) is not None:
        cargs.extend([
            "-drive",
            *params.get("drive_cmd", None)
        ])
    if params.get("note", None) is not None:
        cargs.extend([
            "-note",
            *params.get("note", None)
        ])
    if params.get("yrange", None) is not None:
        cargs.extend([
            "-gyr",
            str(params.get("yrange", None))
        ])
    return cargs


def rtfeedme_outputs(
    params: RtfeedmeParameters,
    execution: Execution,
) -> RtfeedmeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = RtfeedmeOutputs(
        root=execution.output_file("."),
    )
    return ret


def rtfeedme_execute(
    params: RtfeedmeParameters,
    runner: Runner | None = None,
) -> RtfeedmeOutputs:
    """
    rtfeedme
    
    Test the real-time plugin by sending all the bricks in 'dataset' to AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `RtfeedmeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(RTFEEDME_METADATA)
    params = execution.params(params)
    cargs = rtfeedme_cargs(params, execution)
    ret = rtfeedme_outputs(params, execution)
    execution.run(cargs)
    return ret


def rtfeedme(
    datasets: list[InputPathType],
    host: str | None = None,
    interval_ms: float | None = None,
    send_3d: bool = False,
    buffer_mb: float | None = None,
    verbose: bool = False,
    swap_bytes: bool = False,
    nz_fake: float | None = None,
    drive_cmd: list[str] | None = None,
    note: list[str] | None = None,
    yrange: float | None = None,
    runner: Runner | None = None,
) -> RtfeedmeOutputs:
    """
    rtfeedme
    
    Test the real-time plugin by sending all the bricks in 'dataset' to AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        datasets: List of datasets to send to AFNI, specified as paths to\
            dataset files. Multiple datasets can be specified.
        host: Send data via TCP/IP to AFNI running on the specified computer\
            system 'sname'. Default is the current system using shared memory. Use\
            'localhost' to send on the current system using TCP/IP.
        interval_ms: Inter-transmit interval in milliseconds. Default is to\
            send data as fast as possible.
        send_3d: Send data in 3D bricks. Default is 2D slices.
        buffer_mb: Set the interprocess communications buffer size in megabytes\
            when using shared memory. Has no effect if using TCP/IP. Default is 1\
            MB; if set to 0, a 50 KB buffer is used.
        verbose: Be talkative about actions.
        swap_bytes: Swap byte pairs before sending data.
        nz_fake: Send 'nz' as the value of nzz for debugging purposes.
        drive_cmd: Send 'cmd' as a DRIVE_AFNI command. If 'cmd' contains\
            spaces, it must be quoted. Multiple -drive options can be used.
        note: Send 'sss' as a NOTE to the realtime plugin. Multiple -note\
            options can be used.
        yrange: Send value 'v' as the y-range for realtime motion estimation\
            graphing.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `RtfeedmeOutputs`).
    """
    params = rtfeedme_params(
        datasets=datasets,
        host=host,
        interval_ms=interval_ms,
        send_3d=send_3d,
        buffer_mb=buffer_mb,
        verbose=verbose,
        swap_bytes=swap_bytes,
        nz_fake=nz_fake,
        drive_cmd=drive_cmd,
        note=note,
        yrange=yrange,
    )
    return rtfeedme_execute(params, runner)


__all__ = [
    "RTFEEDME_METADATA",
    "RtfeedmeOutputs",
    "rtfeedme",
    "rtfeedme_execute",
    "rtfeedme_params",
]
