# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SAMP_BIAS_METADATA = Metadata(
    id="4faddcdab52d97992d0c7bcd367e7c5071d25515.boutiques",
    name="SampBias",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SampBiasParameters = typing.TypedDict('SampBiasParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/SampBias"]],
    "specfile": InputPathType,
    "surfname": str,
    "plimit": typing.NotRequired[float | None],
    "dlimit": typing.NotRequired[float | None],
    "outfile": str,
    "prefix": typing.NotRequired[str | None],
    "segdo": typing.NotRequired[str | None],
})
SampBiasParametersTagged = typing.TypedDict('SampBiasParametersTagged', {
    "@type": typing.Literal["afni/SampBias"],
    "specfile": InputPathType,
    "surfname": str,
    "plimit": typing.NotRequired[float | None],
    "dlimit": typing.NotRequired[float | None],
    "outfile": str,
    "prefix": typing.NotRequired[str | None],
    "segdo": typing.NotRequired[str | None],
})


class SampBiasOutputs(typing.NamedTuple):
    """
    Output object returned when calling `SampBiasParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_1_d: OutputPathType
    """Output results in .1D format"""
    out_prefix: OutputPathType | None
    """Output results in a proper surface-based dataset."""


def samp_bias_params(
    specfile: InputPathType,
    surfname: str,
    outfile: str,
    plimit: float | None = None,
    dlimit: float | None = None,
    prefix: str | None = None,
    segdo: str | None = None,
) -> SampBiasParametersTagged:
    """
    Build parameters.
    
    Args:
        specfile: Spec file containing input surfaces.
        surfname: Name of input surface.
        outfile: Output results in .1D format.
        plimit: Maximum length of path along surface in mm. Default is 50 mm.
        dlimit: Maximum length of euclidean distance in mm. Default is 1000 mm.
        prefix: Output results into a proper surface-based dataset.
        segdo: Output a displayable object file that contains segments between\
            paired nodes.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/SampBias",
        "specfile": specfile,
        "surfname": surfname,
        "outfile": outfile,
    }
    if plimit is not None:
        params["plimit"] = plimit
    if dlimit is not None:
        params["dlimit"] = dlimit
    if prefix is not None:
        params["prefix"] = prefix
    if segdo is not None:
        params["segdo"] = segdo
    return params


def samp_bias_cargs(
    params: SampBiasParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SampBias")
    cargs.extend([
        "-spec",
        execution.input_file(params.get("specfile", None))
    ])
    cargs.extend([
        "-surf",
        params.get("surfname", None)
    ])
    if params.get("plimit", None) is not None:
        cargs.extend([
            "-plimit",
            str(params.get("plimit", None))
        ])
    if params.get("dlimit", None) is not None:
        cargs.extend([
            "-dlimit",
            str(params.get("dlimit", None))
        ])
    cargs.extend([
        "-out",
        params.get("outfile", None)
    ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("segdo", None) is not None:
        cargs.extend([
            "-segdo",
            params.get("segdo", None)
        ])
    return cargs


def samp_bias_outputs(
    params: SampBiasParameters,
    execution: Execution,
) -> SampBiasOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SampBiasOutputs(
        root=execution.output_file("."),
        out_1_d=execution.output_file(params.get("outfile", None) + ".1D"),
        out_prefix=execution.output_file(params.get("prefix", None)) if (params.get("prefix") is not None) else None,
    )
    return ret


def samp_bias_execute(
    params: SampBiasParameters,
    runner: Runner | None = None,
) -> SampBiasOutputs:
    """
    SampBias
    
    SampBias is a tool for sampling bias resultant segments between paired nodes
    on anatomical surfaces.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SampBiasOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SAMP_BIAS_METADATA)
    params = execution.params(params)
    cargs = samp_bias_cargs(params, execution)
    ret = samp_bias_outputs(params, execution)
    execution.run(cargs)
    return ret


def samp_bias(
    specfile: InputPathType,
    surfname: str,
    outfile: str,
    plimit: float | None = None,
    dlimit: float | None = None,
    prefix: str | None = None,
    segdo: str | None = None,
    runner: Runner | None = None,
) -> SampBiasOutputs:
    """
    SampBias
    
    SampBias is a tool for sampling bias resultant segments between paired nodes
    on anatomical surfaces.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        specfile: Spec file containing input surfaces.
        surfname: Name of input surface.
        outfile: Output results in .1D format.
        plimit: Maximum length of path along surface in mm. Default is 50 mm.
        dlimit: Maximum length of euclidean distance in mm. Default is 1000 mm.
        prefix: Output results into a proper surface-based dataset.
        segdo: Output a displayable object file that contains segments between\
            paired nodes.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SampBiasOutputs`).
    """
    params = samp_bias_params(
        specfile=specfile,
        surfname=surfname,
        plimit=plimit,
        dlimit=dlimit,
        outfile=outfile,
        prefix=prefix,
        segdo=segdo,
    )
    return samp_bias_execute(params, runner)


__all__ = [
    "SAMP_BIAS_METADATA",
    "SampBiasOutputs",
    "samp_bias",
    "samp_bias_execute",
    "samp_bias_params",
]
