# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SFIM_METADATA = Metadata(
    id="ad5768baaae7cebeadaf50152b4413144e7e8b36.boutiques",
    name="sfim",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SfimParameters = typing.TypedDict('SfimParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/sfim"]],
    "input_images": list[InputPathType],
    "sfint_file": typing.NotRequired[str | None],
    "baseline_state": typing.NotRequired[str | None],
    "local_base_option": bool,
    "output_prefix": typing.NotRequired[str | None],
})
SfimParametersTagged = typing.TypedDict('SfimParametersTagged', {
    "@type": typing.Literal["afni/sfim"],
    "input_images": list[InputPathType],
    "sfint_file": typing.NotRequired[str | None],
    "baseline_state": typing.NotRequired[str | None],
    "local_base_option": bool,
    "output_prefix": typing.NotRequired[str | None],
})


class SfimOutputs(typing.NamedTuple):
    """
    Output object returned when calling `SfimParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def sfim_params(
    input_images: list[InputPathType],
    sfint_file: str | None = None,
    baseline_state: str | None = None,
    local_base_option: bool = False,
    output_prefix: str | None = None,
) -> SfimParametersTagged:
    """
    Build parameters.
    
    Args:
        input_images: Input image files in formats accepted by AFNI.
        sfint_file: Filename which contains the interval definitions. Default\
            is 'sfint'. Example: '3*# 5*rest 4*A 5*rest 4*B 5*rest 4*A 5*rest'.
        baseline_state: Task state name to use as the baseline. Default is\
            'rest'.
        local_base_option: Flag to indicate if each non-base task state\
            interval should have the mean of the two nearest base intervals\
            subtracted instead of the grand mean of all the base task intervals.
        output_prefix: Prefix for output image filenames for all states. The\
            i'th interval with task state name 'fred' will be written to file\
            'pname.fred.i'. Default is 'sfim'.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/sfim",
        "input_images": input_images,
        "local_base_option": local_base_option,
    }
    if sfint_file is not None:
        params["sfint_file"] = sfint_file
    if baseline_state is not None:
        params["baseline_state"] = baseline_state
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    return params


def sfim_cargs(
    params: SfimParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("sfim")
    cargs.extend([execution.input_file(f) for f in params.get("input_images", None)])
    if params.get("sfint_file", None) is not None:
        cargs.extend([
            "-sfint",
            params.get("sfint_file", None)
        ])
    if params.get("baseline_state", None) is not None:
        cargs.extend([
            "-base",
            params.get("baseline_state", None)
        ])
    if params.get("local_base_option", False):
        cargs.append("-localbase")
    if params.get("output_prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("output_prefix", None)
        ])
    return cargs


def sfim_outputs(
    params: SfimParameters,
    execution: Execution,
) -> SfimOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SfimOutputs(
        root=execution.output_file("."),
    )
    return ret


def sfim_execute(
    params: SfimParameters,
    runner: Runner | None = None,
) -> SfimOutputs:
    """
    sfim
    
    Stepwise Functional IMages.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SfimOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SFIM_METADATA)
    params = execution.params(params)
    cargs = sfim_cargs(params, execution)
    ret = sfim_outputs(params, execution)
    execution.run(cargs)
    return ret


def sfim(
    input_images: list[InputPathType],
    sfint_file: str | None = None,
    baseline_state: str | None = None,
    local_base_option: bool = False,
    output_prefix: str | None = None,
    runner: Runner | None = None,
) -> SfimOutputs:
    """
    sfim
    
    Stepwise Functional IMages.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_images: Input image files in formats accepted by AFNI.
        sfint_file: Filename which contains the interval definitions. Default\
            is 'sfint'. Example: '3*# 5*rest 4*A 5*rest 4*B 5*rest 4*A 5*rest'.
        baseline_state: Task state name to use as the baseline. Default is\
            'rest'.
        local_base_option: Flag to indicate if each non-base task state\
            interval should have the mean of the two nearest base intervals\
            subtracted instead of the grand mean of all the base task intervals.
        output_prefix: Prefix for output image filenames for all states. The\
            i'th interval with task state name 'fred' will be written to file\
            'pname.fred.i'. Default is 'sfim'.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SfimOutputs`).
    """
    params = sfim_params(
        input_images=input_images,
        sfint_file=sfint_file,
        baseline_state=baseline_state,
        local_base_option=local_base_option,
        output_prefix=output_prefix,
    )
    return sfim_execute(params, runner)


__all__ = [
    "SFIM_METADATA",
    "SfimOutputs",
    "sfim",
    "sfim_execute",
    "sfim_params",
]
