# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SUMA_GLXDINO_METADATA = Metadata(
    id="ff8213640ad8c997c8565a4312bacb57bfcc0bcd.boutiques",
    name="SUMA_glxdino",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SumaGlxdinoParameters = typing.TypedDict('SumaGlxdinoParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/SUMA_glxdino"]],
    "verbose": bool,
})
SumaGlxdinoParametersTagged = typing.TypedDict('SumaGlxdinoParametersTagged', {
    "@type": typing.Literal["afni/SUMA_glxdino"],
    "verbose": bool,
})


class SumaGlxdinoOutputs(typing.NamedTuple):
    """
    Output object returned when calling `SumaGlxdinoParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def suma_glxdino_params(
    verbose: bool = False,
) -> SumaGlxdinoParametersTagged:
    """
    Build parameters.
    
    Args:
        verbose: Switch on diagnostic messages.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/SUMA_glxdino",
        "verbose": verbose,
    }
    return params


def suma_glxdino_cargs(
    params: SumaGlxdinoParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SUMA_glxdino")
    if params.get("verbose", False):
        cargs.append("-v")
    return cargs


def suma_glxdino_outputs(
    params: SumaGlxdinoParameters,
    execution: Execution,
) -> SumaGlxdinoOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SumaGlxdinoOutputs(
        root=execution.output_file("."),
    )
    return ret


def suma_glxdino_execute(
    params: SumaGlxdinoParameters,
    runner: Runner | None = None,
) -> SumaGlxdinoOutputs:
    """
    SUMA_glxdino
    
    A simple openGL test program using GLX. If it does not run, then SUMA
    certainly won't.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SumaGlxdinoOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SUMA_GLXDINO_METADATA)
    params = execution.params(params)
    cargs = suma_glxdino_cargs(params, execution)
    ret = suma_glxdino_outputs(params, execution)
    execution.run(cargs)
    return ret


def suma_glxdino(
    verbose: bool = False,
    runner: Runner | None = None,
) -> SumaGlxdinoOutputs:
    """
    SUMA_glxdino
    
    A simple openGL test program using GLX. If it does not run, then SUMA
    certainly won't.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        verbose: Switch on diagnostic messages.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SumaGlxdinoOutputs`).
    """
    params = suma_glxdino_params(
        verbose=verbose,
    )
    return suma_glxdino_execute(params, runner)


__all__ = [
    "SUMA_GLXDINO_METADATA",
    "SumaGlxdinoOutputs",
    "suma_glxdino",
    "suma_glxdino_execute",
    "suma_glxdino_params",
]
