# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SURF_EXTREMA_METADATA = Metadata(
    id="dab9c5e241b4f90ee6541ca4c63fc1b5bc231d49.boutiques",
    name="SurfExtrema",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SurfExtremaParameters = typing.TypedDict('SurfExtremaParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/SurfExtrema"]],
    "input": typing.NotRequired[InputPathType | None],
    "hood": typing.NotRequired[float | None],
    "thresh": typing.NotRequired[float | None],
    "gthresh": typing.NotRequired[float | None],
    "gscale": typing.NotRequired[typing.Literal["NONE", "LMEAN", "GMEAN"] | None],
    "extype": typing.NotRequired[typing.Literal["MAX", "MIN", "ABS"] | None],
    "prefix": str,
    "table": typing.NotRequired[str | None],
})
SurfExtremaParametersTagged = typing.TypedDict('SurfExtremaParametersTagged', {
    "@type": typing.Literal["afni/SurfExtrema"],
    "input": typing.NotRequired[InputPathType | None],
    "hood": typing.NotRequired[float | None],
    "thresh": typing.NotRequired[float | None],
    "gthresh": typing.NotRequired[float | None],
    "gscale": typing.NotRequired[typing.Literal["NONE", "LMEAN", "GMEAN"] | None],
    "extype": typing.NotRequired[typing.Literal["MAX", "MIN", "ABS"] | None],
    "prefix": str,
    "table": typing.NotRequired[str | None],
})


class SurfExtremaOutputs(typing.NamedTuple):
    """
    Output object returned when calling `SurfExtremaParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_grd: OutputPathType
    """Output file containing the scaled average gradient values."""
    output_ext: OutputPathType
    """Output file containing the nodes with maximum values."""


def surf_extrema_params(
    prefix: str,
    input_: InputPathType | None = None,
    hood: float | None = None,
    thresh: float | None = None,
    gthresh: float | None = None,
    gscale: typing.Literal["NONE", "LMEAN", "GMEAN"] | None = None,
    extype: typing.Literal["MAX", "MIN", "ABS"] | None = None,
    table: str | None = None,
) -> SurfExtremaParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix for the output datasets.
        input_: Input dataset in which Extrema are to be identified.
        hood: Neighborhood radius (R) in mm. Default is 8 mm.
        thresh: Do not consider nodes with value less than this threshold.\
            Default is 0.
        gthresh: Do not consider nodes with gradient less than this threshold.\
            Default is 0.01.
        gscale: Scaling to apply to gradient computation.
        extype: Find maxima, minima, or extrema. Options are MAX (default),\
            MIN, ABS.
        table: Name of file in which to store a record of the extrema found.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/SurfExtrema",
        "prefix": prefix,
    }
    if input_ is not None:
        params["input"] = input_
    if hood is not None:
        params["hood"] = hood
    if thresh is not None:
        params["thresh"] = thresh
    if gthresh is not None:
        params["gthresh"] = gthresh
    if gscale is not None:
        params["gscale"] = gscale
    if extype is not None:
        params["extype"] = extype
    if table is not None:
        params["table"] = table
    return params


def surf_extrema_cargs(
    params: SurfExtremaParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SurfExtrema")
    if params.get("input", None) is not None:
        cargs.extend([
            "-input",
            execution.input_file(params.get("input", None))
        ])
    if params.get("hood", None) is not None:
        cargs.extend([
            "-nbhd_rad",
            str(params.get("hood", None))
        ])
    if params.get("thresh", None) is not None:
        cargs.extend([
            "-thresh",
            str(params.get("thresh", None))
        ])
    if params.get("gthresh", None) is not None:
        cargs.extend([
            "-gthresh",
            str(params.get("gthresh", None))
        ])
    if params.get("gscale", None) is not None:
        cargs.extend([
            "-gscale",
            params.get("gscale", None)
        ])
    if params.get("extype", None) is not None:
        cargs.extend([
            "-extype",
            params.get("extype", None)
        ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("table", None) is not None:
        cargs.extend([
            "-table",
            params.get("table", None)
        ])
    return cargs


def surf_extrema_outputs(
    params: SurfExtremaParameters,
    execution: Execution,
) -> SurfExtremaOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SurfExtremaOutputs(
        root=execution.output_file("."),
        output_grd=execution.output_file(params.get("prefix", None) + ".grd"),
        output_ext=execution.output_file(params.get("prefix", None) + ".ext"),
    )
    return ret


def surf_extrema_execute(
    params: SurfExtremaParameters,
    runner: Runner | None = None,
) -> SurfExtremaOutputs:
    """
    SurfExtrema
    
    A program finding the local extrema in a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfExtremaOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SURF_EXTREMA_METADATA)
    params = execution.params(params)
    cargs = surf_extrema_cargs(params, execution)
    ret = surf_extrema_outputs(params, execution)
    execution.run(cargs)
    return ret


def surf_extrema(
    prefix: str,
    input_: InputPathType | None = None,
    hood: float | None = None,
    thresh: float | None = None,
    gthresh: float | None = None,
    gscale: typing.Literal["NONE", "LMEAN", "GMEAN"] | None = None,
    extype: typing.Literal["MAX", "MIN", "ABS"] | None = None,
    table: str | None = None,
    runner: Runner | None = None,
) -> SurfExtremaOutputs:
    """
    SurfExtrema
    
    A program finding the local extrema in a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix for the output datasets.
        input_: Input dataset in which Extrema are to be identified.
        hood: Neighborhood radius (R) in mm. Default is 8 mm.
        thresh: Do not consider nodes with value less than this threshold.\
            Default is 0.
        gthresh: Do not consider nodes with gradient less than this threshold.\
            Default is 0.01.
        gscale: Scaling to apply to gradient computation.
        extype: Find maxima, minima, or extrema. Options are MAX (default),\
            MIN, ABS.
        table: Name of file in which to store a record of the extrema found.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfExtremaOutputs`).
    """
    params = surf_extrema_params(
        input_=input_,
        hood=hood,
        thresh=thresh,
        gthresh=gthresh,
        gscale=gscale,
        extype=extype,
        prefix=prefix,
        table=table,
    )
    return surf_extrema_execute(params, runner)


__all__ = [
    "SURF_EXTREMA_METADATA",
    "SurfExtremaOutputs",
    "surf_extrema",
    "surf_extrema_execute",
    "surf_extrema_params",
]
