# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SURF_INFO_METADATA = Metadata(
    id="56af722d55dc6d5f432c8465801c64246f4b10d3.boutiques",
    name="SurfInfo",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SurfInfoParameters = typing.TypedDict('SurfInfoParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/SurfInfo"]],
    "surface": InputPathType,
    "com": bool,
    "debug_level": typing.NotRequired[float | None],
    "detail_level": typing.NotRequired[float | None],
    "n_node": bool,
    "n_faceset": bool,
    "n_tri": bool,
    "quiet": bool,
    "separator": typing.NotRequired[str | None],
    "input_surface": typing.NotRequired[str | None],
    "surface_state": typing.NotRequired[str | None],
    "surface_volume": typing.NotRequired[InputPathType | None],
    "spec_file": typing.NotRequired[InputPathType | None],
    "novolreg": bool,
    "noxform": bool,
    "setenv": typing.NotRequired[str | None],
    "trace": bool,
    "extreme_trace": bool,
    "nomall": bool,
    "yesmall": bool,
})
SurfInfoParametersTagged = typing.TypedDict('SurfInfoParametersTagged', {
    "@type": typing.Literal["afni/SurfInfo"],
    "surface": InputPathType,
    "com": bool,
    "debug_level": typing.NotRequired[float | None],
    "detail_level": typing.NotRequired[float | None],
    "n_node": bool,
    "n_faceset": bool,
    "n_tri": bool,
    "quiet": bool,
    "separator": typing.NotRequired[str | None],
    "input_surface": typing.NotRequired[str | None],
    "surface_state": typing.NotRequired[str | None],
    "surface_volume": typing.NotRequired[InputPathType | None],
    "spec_file": typing.NotRequired[InputPathType | None],
    "novolreg": bool,
    "noxform": bool,
    "setenv": typing.NotRequired[str | None],
    "trace": bool,
    "extreme_trace": bool,
    "nomall": bool,
    "yesmall": bool,
})


class SurfInfoOutputs(typing.NamedTuple):
    """
    Output object returned when calling `SurfInfoParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    metrics_output: OutputPathType
    """Output file containing calculated surface metrics."""


def surf_info_params(
    surface: InputPathType,
    com: bool = False,
    debug_level: float | None = None,
    detail_level: float | None = None,
    n_node: bool = False,
    n_faceset: bool = False,
    n_tri: bool = False,
    quiet: bool = False,
    separator: str | None = None,
    input_surface: str | None = None,
    surface_state: str | None = None,
    surface_volume: InputPathType | None = None,
    spec_file: InputPathType | None = None,
    novolreg: bool = False,
    noxform: bool = False,
    setenv: str | None = None,
    trace_: bool = False,
    extreme_trace: bool = False,
    nomall: bool = False,
    yesmall: bool = False,
) -> SurfInfoParametersTagged:
    """
    Build parameters.
    
    Args:
        surface: Input surface file.
        com: Output the center of mass.
        debug_level: Debugging level (2 turns LocalHead ON).
        detail_level: Calculate surface metrics. 1=yes, 0=no.
        n_node: Output the number of nodes.
        n_faceset: Output the number of face sets.
        n_tri: Output the number of triangles.
        quiet: Do not include the name of the parameter in output.
        separator: Use string SEP to separate parameter values. Default is ' ;\
            '.
        input_surface: Specify the input surface type and file.
        surface_state: Specify surface type, state, and name.
        surface_volume: Specify a surface volume file.
        spec_file: Specify a surface specification (spec) file.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        noxform: Same as -novolreg.
        setenv: Set environment variable ENVname to be ENVvalue. Quotes are\
            necessary.
        trace_: Turns on In/Out debug and Memory tracing.
        extreme_trace: Turns on extreme tracing.
        nomall: Turn off memory tracing.
        yesmall: Turn on memory tracing (default).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/SurfInfo",
        "surface": surface,
        "com": com,
        "n_node": n_node,
        "n_faceset": n_faceset,
        "n_tri": n_tri,
        "quiet": quiet,
        "novolreg": novolreg,
        "noxform": noxform,
        "trace": trace_,
        "extreme_trace": extreme_trace,
        "nomall": nomall,
        "yesmall": yesmall,
    }
    if debug_level is not None:
        params["debug_level"] = debug_level
    if detail_level is not None:
        params["detail_level"] = detail_level
    if separator is not None:
        params["separator"] = separator
    if input_surface is not None:
        params["input_surface"] = input_surface
    if surface_state is not None:
        params["surface_state"] = surface_state
    if surface_volume is not None:
        params["surface_volume"] = surface_volume
    if spec_file is not None:
        params["spec_file"] = spec_file
    if setenv is not None:
        params["setenv"] = setenv
    return params


def surf_info_cargs(
    params: SurfInfoParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SurfInfo")
    cargs.append(execution.input_file(params.get("surface", None)))
    if params.get("com", False):
        cargs.append("-COM")
    if params.get("debug_level", None) is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug_level", None))
        ])
    if params.get("detail_level", None) is not None:
        cargs.extend([
            "-detail",
            str(params.get("detail_level", None))
        ])
    if params.get("n_node", False):
        cargs.append("-N_Node")
    if params.get("n_faceset", False):
        cargs.append("-N_FaceSet")
    if params.get("n_tri", False):
        cargs.append("-N_Tri")
    if params.get("quiet", False):
        cargs.append("-quiet")
    if params.get("separator", None) is not None:
        cargs.extend([
            "-sep",
            params.get("separator", None)
        ])
    if params.get("input_surface", None) is not None:
        cargs.extend([
            "-i_TYPE",
            params.get("input_surface", None)
        ])
    if params.get("surface_state", None) is not None:
        cargs.extend([
            "-tsn",
            params.get("surface_state", None)
        ])
    if params.get("surface_volume", None) is not None:
        cargs.extend([
            "-sv",
            execution.input_file(params.get("surface_volume", None))
        ])
    if params.get("spec_file", None) is not None:
        cargs.extend([
            "-spec",
            execution.input_file(params.get("spec_file", None))
        ])
    if params.get("novolreg", False):
        cargs.append("-novolreg")
    if params.get("noxform", False):
        cargs.append("-noxform")
    if params.get("setenv", None) is not None:
        cargs.extend([
            "-setenv",
            params.get("setenv", None)
        ])
    if params.get("trace", False):
        cargs.append("-trace")
    if params.get("extreme_trace", False):
        cargs.append("-TRACE")
    if params.get("nomall", False):
        cargs.append("-nomall")
    if params.get("yesmall", False):
        cargs.append("-yesmall")
    return cargs


def surf_info_outputs(
    params: SurfInfoParameters,
    execution: Execution,
) -> SurfInfoOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SurfInfoOutputs(
        root=execution.output_file("."),
        metrics_output=execution.output_file(pathlib.Path(params.get("surface", None)).name + "_metrics.txt"),
    )
    return ret


def surf_info_execute(
    params: SurfInfoParameters,
    runner: Runner | None = None,
) -> SurfInfoOutputs:
    """
    SurfInfo
    
    Tool to gather information about surface files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfInfoOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SURF_INFO_METADATA)
    params = execution.params(params)
    cargs = surf_info_cargs(params, execution)
    ret = surf_info_outputs(params, execution)
    execution.run(cargs)
    return ret


def surf_info(
    surface: InputPathType,
    com: bool = False,
    debug_level: float | None = None,
    detail_level: float | None = None,
    n_node: bool = False,
    n_faceset: bool = False,
    n_tri: bool = False,
    quiet: bool = False,
    separator: str | None = None,
    input_surface: str | None = None,
    surface_state: str | None = None,
    surface_volume: InputPathType | None = None,
    spec_file: InputPathType | None = None,
    novolreg: bool = False,
    noxform: bool = False,
    setenv: str | None = None,
    trace_: bool = False,
    extreme_trace: bool = False,
    nomall: bool = False,
    yesmall: bool = False,
    runner: Runner | None = None,
) -> SurfInfoOutputs:
    """
    SurfInfo
    
    Tool to gather information about surface files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        surface: Input surface file.
        com: Output the center of mass.
        debug_level: Debugging level (2 turns LocalHead ON).
        detail_level: Calculate surface metrics. 1=yes, 0=no.
        n_node: Output the number of nodes.
        n_faceset: Output the number of face sets.
        n_tri: Output the number of triangles.
        quiet: Do not include the name of the parameter in output.
        separator: Use string SEP to separate parameter values. Default is ' ;\
            '.
        input_surface: Specify the input surface type and file.
        surface_state: Specify surface type, state, and name.
        surface_volume: Specify a surface volume file.
        spec_file: Specify a surface specification (spec) file.
        novolreg: Ignore any Rotate, Volreg, Tagalign, or WarpDrive\
            transformations present in the Surface Volume.
        noxform: Same as -novolreg.
        setenv: Set environment variable ENVname to be ENVvalue. Quotes are\
            necessary.
        trace_: Turns on In/Out debug and Memory tracing.
        extreme_trace: Turns on extreme tracing.
        nomall: Turn off memory tracing.
        yesmall: Turn on memory tracing (default).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfInfoOutputs`).
    """
    params = surf_info_params(
        surface=surface,
        com=com,
        debug_level=debug_level,
        detail_level=detail_level,
        n_node=n_node,
        n_faceset=n_faceset,
        n_tri=n_tri,
        quiet=quiet,
        separator=separator,
        input_surface=input_surface,
        surface_state=surface_state,
        surface_volume=surface_volume,
        spec_file=spec_file,
        novolreg=novolreg,
        noxform=noxform,
        setenv=setenv,
        trace_=trace_,
        extreme_trace=extreme_trace,
        nomall=nomall,
        yesmall=yesmall,
    )
    return surf_info_execute(params, runner)


__all__ = [
    "SURF_INFO_METADATA",
    "SurfInfoOutputs",
    "surf_info",
    "surf_info_execute",
    "surf_info_params",
]
