# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SURF_LOCALSTAT_METADATA = Metadata(
    id="8a12a6d69e93058f704ee707c378a9b21f748a8e.boutiques",
    name="SurfLocalstat",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SurfLocalstatParameters = typing.TypedDict('SurfLocalstatParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/SurfLocalstat"]],
    "hood": typing.NotRequired[float | None],
    "nbhd_rad": typing.NotRequired[float | None],
    "prefix": str,
    "stat": typing.Literal["mean", "mode", "num", "FWHM", "ALL"],
    "input_dataset": InputPathType,
    "surface": InputPathType,
})
SurfLocalstatParametersTagged = typing.TypedDict('SurfLocalstatParametersTagged', {
    "@type": typing.Literal["afni/SurfLocalstat"],
    "hood": typing.NotRequired[float | None],
    "nbhd_rad": typing.NotRequired[float | None],
    "prefix": str,
    "stat": typing.Literal["mean", "mode", "num", "FWHM", "ALL"],
    "input_dataset": InputPathType,
    "surface": InputPathType,
})


class SurfLocalstatOutputs(typing.NamedTuple):
    """
    Output object returned when calling `SurfLocalstatParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Computed local statistics dataset"""


def surf_localstat_params(
    prefix: str,
    stat_: typing.Literal["mean", "mode", "num", "FWHM", "ALL"],
    input_dataset: InputPathType,
    surface: InputPathType,
    hood: float | None = None,
    nbhd_rad: float | None = None,
) -> SurfLocalstatParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix of output data set.
        stat_: Compute the specified statistic on the values extracted from the\
            region around each voxel. Options: mean, mode, num, FWHM, ALL.
        input_dataset: Input dataset.
        surface: Input GIFTI surface file.
        hood: Neighborhood of nodes within the specified radius R.
        nbhd_rad: Distance from node n as measured by the shortest distance\
            along the mesh.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/SurfLocalstat",
        "prefix": prefix,
        "stat": stat_,
        "input_dataset": input_dataset,
        "surface": surface,
    }
    if hood is not None:
        params["hood"] = hood
    if nbhd_rad is not None:
        params["nbhd_rad"] = nbhd_rad
    return params


def surf_localstat_cargs(
    params: SurfLocalstatParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SurfLocalstat")
    if params.get("hood", None) is not None:
        cargs.extend([
            "-hood",
            str(params.get("hood", None))
        ])
    if params.get("nbhd_rad", None) is not None:
        cargs.extend([
            "-nbhd_rad",
            str(params.get("nbhd_rad", None))
        ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.extend([
        "-stat",
        params.get("stat", None)
    ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_dataset", None))
    ])
    cargs.extend([
        "-i_gii",
        execution.input_file(params.get("surface", None))
    ])
    return cargs


def surf_localstat_outputs(
    params: SurfLocalstatParameters,
    execution: Execution,
) -> SurfLocalstatOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SurfLocalstatOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None) + ".niml.dset"),
    )
    return ret


def surf_localstat_execute(
    params: SurfLocalstatParameters,
    runner: Runner | None = None,
) -> SurfLocalstatOutputs:
    """
    SurfLocalstat
    
    Compute local statistics on a surface mesh.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfLocalstatOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SURF_LOCALSTAT_METADATA)
    params = execution.params(params)
    cargs = surf_localstat_cargs(params, execution)
    ret = surf_localstat_outputs(params, execution)
    execution.run(cargs)
    return ret


def surf_localstat(
    prefix: str,
    stat_: typing.Literal["mean", "mode", "num", "FWHM", "ALL"],
    input_dataset: InputPathType,
    surface: InputPathType,
    hood: float | None = None,
    nbhd_rad: float | None = None,
    runner: Runner | None = None,
) -> SurfLocalstatOutputs:
    """
    SurfLocalstat
    
    Compute local statistics on a surface mesh.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix of output data set.
        stat_: Compute the specified statistic on the values extracted from the\
            region around each voxel. Options: mean, mode, num, FWHM, ALL.
        input_dataset: Input dataset.
        surface: Input GIFTI surface file.
        hood: Neighborhood of nodes within the specified radius R.
        nbhd_rad: Distance from node n as measured by the shortest distance\
            along the mesh.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfLocalstatOutputs`).
    """
    params = surf_localstat_params(
        hood=hood,
        nbhd_rad=nbhd_rad,
        prefix=prefix,
        stat_=stat_,
        input_dataset=input_dataset,
        surface=surface,
    )
    return surf_localstat_execute(params, runner)


__all__ = [
    "SURF_LOCALSTAT_METADATA",
    "SurfLocalstatOutputs",
    "surf_localstat",
    "surf_localstat_execute",
    "surf_localstat_params",
]
