# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SURF_MEASURES_METADATA = Metadata(
    id="b94a39e16fa59659338338e4789f816c9ea37585.boutiques",
    name="SurfMeasures",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SurfMeasuresParameters = typing.TypedDict('SurfMeasuresParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/SurfMeasures"]],
    "spec_file": InputPathType,
    "surf_A": str,
    "surf_B": typing.NotRequired[str | None],
    "out_1D": typing.NotRequired[str | None],
    "out_dset": str,
    "func": typing.NotRequired[list[str] | None],
    "surf_volume": typing.NotRequired[InputPathType | None],
    "cmask": typing.NotRequired[str | None],
    "debug": typing.NotRequired[int | None],
    "dnode": typing.NotRequired[float | None],
    "nodes_1D": typing.NotRequired[InputPathType | None],
    "info_all": bool,
    "info_area": bool,
    "info_norms": bool,
    "info_thick": bool,
    "info_vol": bool,
    "info_volg": bool,
    "ver": bool,
})
SurfMeasuresParametersTagged = typing.TypedDict('SurfMeasuresParametersTagged', {
    "@type": typing.Literal["afni/SurfMeasures"],
    "spec_file": InputPathType,
    "surf_A": str,
    "surf_B": typing.NotRequired[str | None],
    "out_1D": typing.NotRequired[str | None],
    "out_dset": str,
    "func": typing.NotRequired[list[str] | None],
    "surf_volume": typing.NotRequired[InputPathType | None],
    "cmask": typing.NotRequired[str | None],
    "debug": typing.NotRequired[int | None],
    "dnode": typing.NotRequired[float | None],
    "nodes_1D": typing.NotRequired[InputPathType | None],
    "info_all": bool,
    "info_area": bool,
    "info_norms": bool,
    "info_thick": bool,
    "info_vol": bool,
    "info_volg": bool,
    "ver": bool,
})


class SurfMeasuresOutputs(typing.NamedTuple):
    """
    Output object returned when calling `SurfMeasuresParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_1_d: OutputPathType | None
    """Output in 1D format"""
    output_dset: OutputPathType
    """Output in specified dataset format"""


def surf_measures_params(
    spec_file: InputPathType,
    surf_a: str,
    out_dset: str,
    surf_b: str | None = None,
    out_1_d: str | None = None,
    func: list[str] | None = None,
    surf_volume: InputPathType | None = None,
    cmask: str | None = None,
    debug: int | None = None,
    dnode: float | None = None,
    nodes_1_d: InputPathType | None = None,
    info_all: bool = False,
    info_area: bool = False,
    info_norms: bool = False,
    info_thick: bool = False,
    info_vol: bool = False,
    info_volg: bool = False,
    ver: bool = False,
) -> SurfMeasuresParametersTagged:
    """
    Build parameters.
    
    Args:
        spec_file: SUMA spec file containing a list of related surfaces.
        surf_a: Surface name (in spec file) for the first surface.
        out_dset: Output filename with dataset format.
        surf_b: Surface name (in spec file) for the second surface.
        out_1_d: Output filename in 1D format.
        func: Measure function to be applied.
        surf_volume: AFNI volume dataset associated with the surface.
        cmask: Restrict nodes with a mask.
        debug: Display extra run-time information with specified debug level\
            (0-5).
        dnode: Display extra information for specified node.
        nodes_1_d: Restrict output to specific nodes listed in a file.
        info_all: Display all final info.
        info_area: Display total area of each triangulated surface.
        info_norms: Display info about the normals.
        info_thick: Display minimum and maximum thickness between surfaces.
        info_vol: Display total computed volume between surfaces.
        info_volg: Display total computed volume estimated via Gauss' theorem.
        ver: Show program version and compile date.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/SurfMeasures",
        "spec_file": spec_file,
        "surf_A": surf_a,
        "out_dset": out_dset,
        "info_all": info_all,
        "info_area": info_area,
        "info_norms": info_norms,
        "info_thick": info_thick,
        "info_vol": info_vol,
        "info_volg": info_volg,
        "ver": ver,
    }
    if surf_b is not None:
        params["surf_B"] = surf_b
    if out_1_d is not None:
        params["out_1D"] = out_1_d
    if func is not None:
        params["func"] = func
    if surf_volume is not None:
        params["surf_volume"] = surf_volume
    if cmask is not None:
        params["cmask"] = cmask
    if debug is not None:
        params["debug"] = debug
    if dnode is not None:
        params["dnode"] = dnode
    if nodes_1_d is not None:
        params["nodes_1D"] = nodes_1_d
    return params


def surf_measures_cargs(
    params: SurfMeasuresParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SurfMeasures")
    cargs.extend([
        "-spec",
        execution.input_file(params.get("spec_file", None))
    ])
    cargs.extend([
        "-surf_A",
        params.get("surf_A", None)
    ])
    if params.get("surf_B", None) is not None:
        cargs.extend([
            "-surf_B",
            params.get("surf_B", None)
        ])
    if params.get("out_1D", None) is not None:
        cargs.extend([
            "-out_1D",
            params.get("out_1D", None)
        ])
    cargs.extend([
        "-out",
        params.get("out_dset", None)
    ])
    if params.get("func", None) is not None:
        cargs.extend([
            "-func",
            *params.get("func", None)
        ])
    if params.get("surf_volume", None) is not None:
        cargs.extend([
            "-sv",
            execution.input_file(params.get("surf_volume", None))
        ])
    if params.get("cmask", None) is not None:
        cargs.extend([
            "-cmask",
            params.get("cmask", None)
        ])
    if params.get("debug", None) is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug", None))
        ])
    if params.get("dnode", None) is not None:
        cargs.extend([
            "-dnode",
            str(params.get("dnode", None))
        ])
    if params.get("nodes_1D", None) is not None:
        cargs.extend([
            "-nodes_1D",
            execution.input_file(params.get("nodes_1D", None))
        ])
    if params.get("info_all", False):
        cargs.append("-info_all")
    if params.get("info_area", False):
        cargs.append("-info_area")
    if params.get("info_norms", False):
        cargs.append("-info_norms")
    if params.get("info_thick", False):
        cargs.append("-info_thick")
    if params.get("info_vol", False):
        cargs.append("-info_vol")
    if params.get("info_volg", False):
        cargs.append("-info_volg")
    if params.get("ver", False):
        cargs.append("-ver")
    return cargs


def surf_measures_outputs(
    params: SurfMeasuresParameters,
    execution: Execution,
) -> SurfMeasuresOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SurfMeasuresOutputs(
        root=execution.output_file("."),
        output_1_d=execution.output_file(params.get("out_1D", None) + ".1D") if (params.get("out_1D") is not None) else None,
        output_dset=execution.output_file(params.get("out_dset", None)),
    )
    return ret


def surf_measures_execute(
    params: SurfMeasuresParameters,
    runner: Runner | None = None,
) -> SurfMeasuresOutputs:
    """
    SurfMeasures
    
    Compute measures from surface dataset(s).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfMeasuresOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SURF_MEASURES_METADATA)
    params = execution.params(params)
    cargs = surf_measures_cargs(params, execution)
    ret = surf_measures_outputs(params, execution)
    execution.run(cargs)
    return ret


def surf_measures(
    spec_file: InputPathType,
    surf_a: str,
    out_dset: str,
    surf_b: str | None = None,
    out_1_d: str | None = None,
    func: list[str] | None = None,
    surf_volume: InputPathType | None = None,
    cmask: str | None = None,
    debug: int | None = None,
    dnode: float | None = None,
    nodes_1_d: InputPathType | None = None,
    info_all: bool = False,
    info_area: bool = False,
    info_norms: bool = False,
    info_thick: bool = False,
    info_vol: bool = False,
    info_volg: bool = False,
    ver: bool = False,
    runner: Runner | None = None,
) -> SurfMeasuresOutputs:
    """
    SurfMeasures
    
    Compute measures from surface dataset(s).
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        spec_file: SUMA spec file containing a list of related surfaces.
        surf_a: Surface name (in spec file) for the first surface.
        out_dset: Output filename with dataset format.
        surf_b: Surface name (in spec file) for the second surface.
        out_1_d: Output filename in 1D format.
        func: Measure function to be applied.
        surf_volume: AFNI volume dataset associated with the surface.
        cmask: Restrict nodes with a mask.
        debug: Display extra run-time information with specified debug level\
            (0-5).
        dnode: Display extra information for specified node.
        nodes_1_d: Restrict output to specific nodes listed in a file.
        info_all: Display all final info.
        info_area: Display total area of each triangulated surface.
        info_norms: Display info about the normals.
        info_thick: Display minimum and maximum thickness between surfaces.
        info_vol: Display total computed volume between surfaces.
        info_volg: Display total computed volume estimated via Gauss' theorem.
        ver: Show program version and compile date.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfMeasuresOutputs`).
    """
    params = surf_measures_params(
        spec_file=spec_file,
        surf_a=surf_a,
        surf_b=surf_b,
        out_1_d=out_1_d,
        out_dset=out_dset,
        func=func,
        surf_volume=surf_volume,
        cmask=cmask,
        debug=debug,
        dnode=dnode,
        nodes_1_d=nodes_1_d,
        info_all=info_all,
        info_area=info_area,
        info_norms=info_norms,
        info_thick=info_thick,
        info_vol=info_vol,
        info_volg=info_volg,
        ver=ver,
    )
    return surf_measures_execute(params, runner)


__all__ = [
    "SURF_MEASURES_METADATA",
    "SurfMeasuresOutputs",
    "surf_measures",
    "surf_measures_execute",
    "surf_measures_params",
]
