# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SURF_RETINO_MAP_METADATA = Metadata(
    id="759f3f4ec4008d75ee870dbe1ee1e5e8b576e660.boutiques",
    name="SurfRetinoMap",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SurfRetinoMapParameters = typing.TypedDict('SurfRetinoMapParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/SurfRetinoMap"]],
    "surface": str,
    "polar": str,
    "eccentricity": str,
    "prefix": typing.NotRequired[str | None],
    "node_debug": typing.NotRequired[float | None],
})
SurfRetinoMapParametersTagged = typing.TypedDict('SurfRetinoMapParametersTagged', {
    "@type": typing.Literal["afni/SurfRetinoMap"],
    "surface": str,
    "polar": str,
    "eccentricity": str,
    "prefix": typing.NotRequired[str | None],
    "node_debug": typing.NotRequired[float | None],
})


class SurfRetinoMapOutputs(typing.NamedTuple):
    """
    Output object returned when calling `SurfRetinoMapParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    vfr_output: OutputPathType | None
    """Output Visual Field Ratio (VFR) dataset."""
    threshold_max_output: OutputPathType | None
    """Maximum threshold at each node in the input datasets."""


def surf_retino_map_params(
    surface: str,
    polar: str,
    eccentricity: str,
    prefix: str | None = None,
    node_debug: float | None = None,
) -> SurfRetinoMapParametersTagged:
    """
    Build parameters.
    
    Args:
        surface: Surface on which distances are computed. See 'Specifying input\
            surfaces' section for syntax.
        polar: Retinotopic dataset: polar angle dataset.
        eccentricity: Retinotopic dataset: eccentricity angle dataset.
        prefix: Prefix for output datasets.
        node_debug: Index of node number for which debugging information is\
            output.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/SurfRetinoMap",
        "surface": surface,
        "polar": polar,
        "eccentricity": eccentricity,
    }
    if prefix is not None:
        params["prefix"] = prefix
    if node_debug is not None:
        params["node_debug"] = node_debug
    return params


def surf_retino_map_cargs(
    params: SurfRetinoMapParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SurfRetinoMap")
    cargs.append(params.get("surface", None))
    cargs.append(params.get("polar", None))
    cargs.append(params.get("eccentricity", None))
    if params.get("prefix", None) is not None:
        cargs.extend([
            "--prefix",
            params.get("prefix", None)
        ])
    if params.get("node_debug", None) is not None:
        cargs.extend([
            "--node_dbg",
            str(params.get("node_debug", None))
        ])
    return cargs


def surf_retino_map_outputs(
    params: SurfRetinoMapParameters,
    execution: Execution,
) -> SurfRetinoMapOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SurfRetinoMapOutputs(
        root=execution.output_file("."),
        vfr_output=execution.output_file(params.get("prefix", None) + "_VFR.nii.gz") if (params.get("prefix") is not None) else None,
        threshold_max_output=execution.output_file(params.get("prefix", None) + "_threshold_max.nii.gz") if (params.get("prefix") is not None) else None,
    )
    return ret


def surf_retino_map_execute(
    params: SurfRetinoMapParameters,
    runner: Runner | None = None,
) -> SurfRetinoMapOutputs:
    """
    SurfRetinoMap
    
    Tool for retinotopic mapping on cortical surfaces.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfRetinoMapOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SURF_RETINO_MAP_METADATA)
    params = execution.params(params)
    cargs = surf_retino_map_cargs(params, execution)
    ret = surf_retino_map_outputs(params, execution)
    execution.run(cargs)
    return ret


def surf_retino_map(
    surface: str,
    polar: str,
    eccentricity: str,
    prefix: str | None = None,
    node_debug: float | None = None,
    runner: Runner | None = None,
) -> SurfRetinoMapOutputs:
    """
    SurfRetinoMap
    
    Tool for retinotopic mapping on cortical surfaces.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        surface: Surface on which distances are computed. See 'Specifying input\
            surfaces' section for syntax.
        polar: Retinotopic dataset: polar angle dataset.
        eccentricity: Retinotopic dataset: eccentricity angle dataset.
        prefix: Prefix for output datasets.
        node_debug: Index of node number for which debugging information is\
            output.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfRetinoMapOutputs`).
    """
    params = surf_retino_map_params(
        surface=surface,
        polar=polar,
        eccentricity=eccentricity,
        prefix=prefix,
        node_debug=node_debug,
    )
    return surf_retino_map_execute(params, runner)


__all__ = [
    "SURF_RETINO_MAP_METADATA",
    "SurfRetinoMapOutputs",
    "surf_retino_map",
    "surf_retino_map_execute",
    "surf_retino_map_params",
]
