# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

SURF_TO_SURF_METADATA = Metadata(
    id="30606794951a6ad0374602d13eac56a3bd04e87b.boutiques",
    name="SurfToSurf",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


SurfToSurfParameters = typing.TypedDict('SurfToSurfParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/SurfToSurf"]],
    "input_surface_1": InputPathType,
    "input_surface_2": InputPathType,
    "surface_volume": typing.NotRequired[InputPathType | None],
    "prefix": typing.NotRequired[str | None],
    "output_params": typing.NotRequired[str | None],
    "node_indices": typing.NotRequired[InputPathType | None],
    "proj_dir": typing.NotRequired[InputPathType | None],
    "data": typing.NotRequired[InputPathType | None],
    "node_debug": typing.NotRequired[float | None],
    "debug_level": typing.NotRequired[float | None],
    "make_consistent": bool,
    "dset": typing.NotRequired[InputPathType | None],
    "mapfile": typing.NotRequired[InputPathType | None],
})
SurfToSurfParametersTagged = typing.TypedDict('SurfToSurfParametersTagged', {
    "@type": typing.Literal["afni/SurfToSurf"],
    "input_surface_1": InputPathType,
    "input_surface_2": InputPathType,
    "surface_volume": typing.NotRequired[InputPathType | None],
    "prefix": typing.NotRequired[str | None],
    "output_params": typing.NotRequired[str | None],
    "node_indices": typing.NotRequired[InputPathType | None],
    "proj_dir": typing.NotRequired[InputPathType | None],
    "data": typing.NotRequired[InputPathType | None],
    "node_debug": typing.NotRequired[float | None],
    "debug_level": typing.NotRequired[float | None],
    "make_consistent": bool,
    "dset": typing.NotRequired[InputPathType | None],
    "mapfile": typing.NotRequired[InputPathType | None],
})


class SurfToSurfOutputs(typing.NamedTuple):
    """
    Output object returned when calling `SurfToSurfParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType | None
    """Output file in 1D format"""


def surf_to_surf_params(
    input_surface_1: InputPathType,
    input_surface_2: InputPathType,
    surface_volume: InputPathType | None = None,
    prefix: str | None = None,
    output_params: str | None = None,
    node_indices: InputPathType | None = None,
    proj_dir: InputPathType | None = None,
    data: InputPathType | None = None,
    node_debug: float | None = None,
    debug_level: float | None = None,
    make_consistent: bool = False,
    dset: InputPathType | None = None,
    mapfile: InputPathType | None = None,
) -> SurfToSurfParametersTagged:
    """
    Build parameters.
    
    Args:
        input_surface_1: First input surface file (S1).
        input_surface_2: Second input surface file (S2).
        surface_volume: Specify the surface volume (SV1).
        prefix: Specify prefix for the output file.
        output_params: List of mapping parameters to include in output.
        node_indices: 1D file containing node indices of S1 to consider.
        proj_dir: 1D file containing projection directions.
        data: 1D file containing data to be interpolated.
        node_debug: Node index for debugging purposes.
        debug_level: Debugging level.
        make_consistent: Force a consistency check and correct triangle\
            orientation.
        dset: Dataset file for data interpolation; mutually exclusive with\
            -data.
        mapfile: File containing mapping parameters between surfaces S2 and S1.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/SurfToSurf",
        "input_surface_1": input_surface_1,
        "input_surface_2": input_surface_2,
        "make_consistent": make_consistent,
    }
    if surface_volume is not None:
        params["surface_volume"] = surface_volume
    if prefix is not None:
        params["prefix"] = prefix
    if output_params is not None:
        params["output_params"] = output_params
    if node_indices is not None:
        params["node_indices"] = node_indices
    if proj_dir is not None:
        params["proj_dir"] = proj_dir
    if data is not None:
        params["data"] = data
    if node_debug is not None:
        params["node_debug"] = node_debug
    if debug_level is not None:
        params["debug_level"] = debug_level
    if dset is not None:
        params["dset"] = dset
    if mapfile is not None:
        params["mapfile"] = mapfile
    return params


def surf_to_surf_cargs(
    params: SurfToSurfParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("SurfToSurf")
    cargs.append(execution.input_file(params.get("input_surface_1", None)))
    cargs.append(execution.input_file(params.get("input_surface_2", None)))
    if params.get("surface_volume", None) is not None:
        cargs.extend([
            "-sv",
            execution.input_file(params.get("surface_volume", None))
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("output_params", None) is not None:
        cargs.extend([
            "-output_params",
            params.get("output_params", None)
        ])
    if params.get("node_indices", None) is not None:
        cargs.extend([
            "-node_indices",
            execution.input_file(params.get("node_indices", None))
        ])
    if params.get("proj_dir", None) is not None:
        cargs.extend([
            "-proj_dir",
            execution.input_file(params.get("proj_dir", None))
        ])
    if params.get("data", None) is not None:
        cargs.extend([
            "-data",
            execution.input_file(params.get("data", None))
        ])
    if params.get("node_debug", None) is not None:
        cargs.extend([
            "-node_debug",
            str(params.get("node_debug", None))
        ])
    if params.get("debug_level", None) is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug_level", None))
        ])
    if params.get("make_consistent", False):
        cargs.append("-make_consistent")
    if params.get("dset", None) is not None:
        cargs.extend([
            "-dset",
            execution.input_file(params.get("dset", None))
        ])
    if params.get("mapfile", None) is not None:
        cargs.extend([
            "-mapfile",
            execution.input_file(params.get("mapfile", None))
        ])
    return cargs


def surf_to_surf_outputs(
    params: SurfToSurfParameters,
    execution: Execution,
) -> SurfToSurfOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = SurfToSurfOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("prefix", None) + ".1D") if (params.get("prefix") is not None) else None,
    )
    return ret


def surf_to_surf_execute(
    params: SurfToSurfParameters,
    runner: Runner | None = None,
) -> SurfToSurfOutputs:
    """
    SurfToSurf
    
    Interpolate data from one surface to another.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfToSurfOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(SURF_TO_SURF_METADATA)
    params = execution.params(params)
    cargs = surf_to_surf_cargs(params, execution)
    ret = surf_to_surf_outputs(params, execution)
    execution.run(cargs)
    return ret


def surf_to_surf(
    input_surface_1: InputPathType,
    input_surface_2: InputPathType,
    surface_volume: InputPathType | None = None,
    prefix: str | None = None,
    output_params: str | None = None,
    node_indices: InputPathType | None = None,
    proj_dir: InputPathType | None = None,
    data: InputPathType | None = None,
    node_debug: float | None = None,
    debug_level: float | None = None,
    make_consistent: bool = False,
    dset: InputPathType | None = None,
    mapfile: InputPathType | None = None,
    runner: Runner | None = None,
) -> SurfToSurfOutputs:
    """
    SurfToSurf
    
    Interpolate data from one surface to another.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_surface_1: First input surface file (S1).
        input_surface_2: Second input surface file (S2).
        surface_volume: Specify the surface volume (SV1).
        prefix: Specify prefix for the output file.
        output_params: List of mapping parameters to include in output.
        node_indices: 1D file containing node indices of S1 to consider.
        proj_dir: 1D file containing projection directions.
        data: 1D file containing data to be interpolated.
        node_debug: Node index for debugging purposes.
        debug_level: Debugging level.
        make_consistent: Force a consistency check and correct triangle\
            orientation.
        dset: Dataset file for data interpolation; mutually exclusive with\
            -data.
        mapfile: File containing mapping parameters between surfaces S2 and S1.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `SurfToSurfOutputs`).
    """
    params = surf_to_surf_params(
        input_surface_1=input_surface_1,
        input_surface_2=input_surface_2,
        surface_volume=surface_volume,
        prefix=prefix,
        output_params=output_params,
        node_indices=node_indices,
        proj_dir=proj_dir,
        data=data,
        node_debug=node_debug,
        debug_level=debug_level,
        make_consistent=make_consistent,
        dset=dset,
        mapfile=mapfile,
    )
    return surf_to_surf_execute(params, runner)


__all__ = [
    "SURF_TO_SURF_METADATA",
    "SurfToSurfOutputs",
    "surf_to_surf",
    "surf_to_surf_execute",
    "surf_to_surf_params",
]
