# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

TEDANA_WRAPPER_PY_METADATA = Metadata(
    id="35e559ddd827c563b8387bf1e45614d747bf5d09.boutiques",
    name="tedana_wrapper.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


TedanaWrapperPyParameters = typing.TypedDict('TedanaWrapperPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/tedana_wrapper.py"]],
    "input_files": list[InputPathType],
    "echo_times": list[float],
    "mask": InputPathType,
    "results_dir": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
    "save_all": bool,
    "prep_only": bool,
    "tedana_prog": typing.NotRequired[str | None],
    "tedana_is_exec": bool,
    "ted_label": typing.NotRequired[str | None],
    "tedana_opts": typing.NotRequired[str | None],
    "help": bool,
    "detailed_help": bool,
})
TedanaWrapperPyParametersTagged = typing.TypedDict('TedanaWrapperPyParametersTagged', {
    "@type": typing.Literal["afni/tedana_wrapper.py"],
    "input_files": list[InputPathType],
    "echo_times": list[float],
    "mask": InputPathType,
    "results_dir": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
    "save_all": bool,
    "prep_only": bool,
    "tedana_prog": typing.NotRequired[str | None],
    "tedana_is_exec": bool,
    "ted_label": typing.NotRequired[str | None],
    "tedana_opts": typing.NotRequired[str | None],
    "help": bool,
    "detailed_help": bool,
})


class TedanaWrapperPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `TedanaWrapperPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    tedana_output: OutputPathType | None
    """Output directory for tedana results."""
    tedana_report: OutputPathType | None
    """Tedana report file."""


def tedana_wrapper_py_params(
    input_files: list[InputPathType],
    echo_times: list[float],
    mask: InputPathType,
    results_dir: str | None = None,
    prefix: str | None = None,
    save_all: bool = False,
    prep_only: bool = False,
    tedana_prog: str | None = None,
    tedana_is_exec: bool = False,
    ted_label: str | None = None,
    tedana_opts: str | None = None,
    help_: bool = False,
    detailed_help: bool = False,
) -> TedanaWrapperPyParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: 4D dataset for each echo.
        echo_times: Echo time (ms) for each echo.
        mask: Mask in same space/grid as the input datasets.
        results_dir: Folder to be created for all outputs. Default\
            [./Bunnymen].
        prefix: Prefix for dataset names. Default [Bunnymen].
        save_all: Save intermediate datasets. Default is to save only the\
            3dZcat stacked dataset (and tedana stuff).
        prep_only: Do not run tedana.py, stop at 3dZcat.
        tedana_prog: Path and name of the version of tedana.py that will be\
            run. Default is meica.libs/tedana.py in the afni binaries directory.
        tedana_is_exec: Run 'tedana.py' rather than 'python tedana.py'.
        ted_label: Suffix for output folder. Adds suffix like TED.LABEL (NOT A\
            PATH).
        tedana_opts: Additional options to pass to tedana.py. (In quotes)\
            Example: '--initcost=tanh --conv=2.5e-5'.
        help_: Show help message and exit.
        detailed_help: Show detailed help and exit.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/tedana_wrapper.py",
        "input_files": input_files,
        "echo_times": echo_times,
        "mask": mask,
        "save_all": save_all,
        "prep_only": prep_only,
        "tedana_is_exec": tedana_is_exec,
        "help": help_,
        "detailed_help": detailed_help,
    }
    if results_dir is not None:
        params["results_dir"] = results_dir
    if prefix is not None:
        params["prefix"] = prefix
    if tedana_prog is not None:
        params["tedana_prog"] = tedana_prog
    if ted_label is not None:
        params["ted_label"] = ted_label
    if tedana_opts is not None:
        params["tedana_opts"] = tedana_opts
    return params


def tedana_wrapper_py_cargs(
    params: TedanaWrapperPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("tedana_wrapper.py")
    cargs.extend([
        "-input",
        *[execution.input_file(f) for f in params.get("input_files", None)]
    ])
    cargs.extend([
        "-TE",
        *map(str, params.get("echo_times", None))
    ])
    cargs.extend([
        "-mask",
        execution.input_file(params.get("mask", None))
    ])
    if params.get("results_dir", None) is not None:
        cargs.extend([
            "-results_dir",
            params.get("results_dir", None)
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("save_all", False):
        cargs.append("-save_all")
    if params.get("prep_only", False):
        cargs.append("-prep_only")
    if params.get("tedana_prog", None) is not None:
        cargs.extend([
            "-tedana_prog",
            params.get("tedana_prog", None)
        ])
    if params.get("tedana_is_exec", False):
        cargs.append("-tedana_is_exec")
    if params.get("ted_label", None) is not None:
        cargs.extend([
            "-ted_label",
            params.get("ted_label", None)
        ])
    if params.get("tedana_opts", None) is not None:
        cargs.extend([
            "-tedana_opts",
            params.get("tedana_opts", None)
        ])
    if params.get("help", False):
        cargs.append("-h")
    if params.get("detailed_help", False):
        cargs.append("-help")
    return cargs


def tedana_wrapper_py_outputs(
    params: TedanaWrapperPyParameters,
    execution: Execution,
) -> TedanaWrapperPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = TedanaWrapperPyOutputs(
        root=execution.output_file("."),
        tedana_output=execution.output_file(params.get("results_dir", None) + "/" + params.get("prefix", None) + "_ted_output") if (params.get("results_dir") is not None and params.get("prefix") is not None) else None,
        tedana_report=execution.output_file(params.get("results_dir", None) + "/" + params.get("prefix", None) + "_tedana_report.txt") if (params.get("results_dir") is not None and params.get("prefix") is not None) else None,
    )
    return ret


def tedana_wrapper_py_execute(
    params: TedanaWrapperPyParameters,
    runner: Runner | None = None,
) -> TedanaWrapperPyOutputs:
    """
    tedana_wrapper.py
    
    Internal wrapper to run tedana.py, typically used within afni_proc.py.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `TedanaWrapperPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(TEDANA_WRAPPER_PY_METADATA)
    params = execution.params(params)
    cargs = tedana_wrapper_py_cargs(params, execution)
    ret = tedana_wrapper_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def tedana_wrapper_py(
    input_files: list[InputPathType],
    echo_times: list[float],
    mask: InputPathType,
    results_dir: str | None = None,
    prefix: str | None = None,
    save_all: bool = False,
    prep_only: bool = False,
    tedana_prog: str | None = None,
    tedana_is_exec: bool = False,
    ted_label: str | None = None,
    tedana_opts: str | None = None,
    help_: bool = False,
    detailed_help: bool = False,
    runner: Runner | None = None,
) -> TedanaWrapperPyOutputs:
    """
    tedana_wrapper.py
    
    Internal wrapper to run tedana.py, typically used within afni_proc.py.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: 4D dataset for each echo.
        echo_times: Echo time (ms) for each echo.
        mask: Mask in same space/grid as the input datasets.
        results_dir: Folder to be created for all outputs. Default\
            [./Bunnymen].
        prefix: Prefix for dataset names. Default [Bunnymen].
        save_all: Save intermediate datasets. Default is to save only the\
            3dZcat stacked dataset (and tedana stuff).
        prep_only: Do not run tedana.py, stop at 3dZcat.
        tedana_prog: Path and name of the version of tedana.py that will be\
            run. Default is meica.libs/tedana.py in the afni binaries directory.
        tedana_is_exec: Run 'tedana.py' rather than 'python tedana.py'.
        ted_label: Suffix for output folder. Adds suffix like TED.LABEL (NOT A\
            PATH).
        tedana_opts: Additional options to pass to tedana.py. (In quotes)\
            Example: '--initcost=tanh --conv=2.5e-5'.
        help_: Show help message and exit.
        detailed_help: Show detailed help and exit.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `TedanaWrapperPyOutputs`).
    """
    params = tedana_wrapper_py_params(
        input_files=input_files,
        echo_times=echo_times,
        mask=mask,
        results_dir=results_dir,
        prefix=prefix,
        save_all=save_all,
        prep_only=prep_only,
        tedana_prog=tedana_prog,
        tedana_is_exec=tedana_is_exec,
        ted_label=ted_label,
        tedana_opts=tedana_opts,
        help_=help_,
        detailed_help=detailed_help,
    )
    return tedana_wrapper_py_execute(params, runner)


__all__ = [
    "TEDANA_WRAPPER_PY_METADATA",
    "TedanaWrapperPyOutputs",
    "tedana_wrapper_py",
    "tedana_wrapper_py_execute",
    "tedana_wrapper_py_params",
]
