# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

TO3D_METADATA = Metadata(
    id="b5fc32e956ee67dd746be525a6e36281b7403e3a.boutiques",
    name="to3d",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


To3dParameters = typing.TypedDict('To3dParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/to3d"]],
    "input_files": list[InputPathType],
    "type": typing.NotRequired[typing.Literal["spgr", "fse", "epan", "anat", "ct", "spct", "pet", "mra", "bmap", "diff", "omri", "abuc", "fim", "fith", "fico", "fitt", "fift", "fizt", "fict", "fibt", "fibn", "figt", "fipt", "fbuc"] | None],
    "statpar": typing.NotRequired[list[float] | None],
    "prefix": typing.NotRequired[str | None],
    "session": typing.NotRequired[str | None],
    "geomparent": typing.NotRequired[InputPathType | None],
    "anatparent": typing.NotRequired[InputPathType | None],
    "nosave_flag": bool,
    "nowritebrik_flag": bool,
    "view": typing.NotRequired[typing.Literal["orig", "acpc", "tlrc"] | None],
    "time_zt": typing.NotRequired[list[str] | None],
    "time_tz": typing.NotRequired[list[str] | None],
    "tr_units": typing.NotRequired[typing.Literal["ms", "msec", "s", "sec", "Hz", "Hertz"] | None],
    "torg": typing.NotRequired[float | None],
    "xFOV": typing.NotRequired[str | None],
    "yFOV": typing.NotRequired[str | None],
    "zFOV": typing.NotRequired[str | None],
    "xSLAB": typing.NotRequired[str | None],
    "ySLAB": typing.NotRequired[str | None],
    "zSLAB": typing.NotRequired[str | None],
    "zorigin": typing.NotRequired[float | None],
    "data_type": typing.NotRequired[typing.Literal["short", "float", "byte", "complex"] | None],
    "global_scaling_factor": typing.NotRequired[float | None],
    "nofloatscan_flag": bool,
    "in1_flag": bool,
    "orient": typing.NotRequired[str | None],
    "skip_outliers_flag": bool,
    "text_outliers_flag": bool,
    "save_outliers": typing.NotRequired[str | None],
    "assume_dicom_mosaic_flag": bool,
    "oblique_origin_flag": bool,
    "reverse_list_flag": bool,
    "use_last_elem_flag": bool,
    "use_old_mosaic_code_flag": bool,
    "ushort2float_flag": bool,
    "verbose_flag": bool,
    "gamma": typing.NotRequired[float | None],
    "ncolors": typing.NotRequired[float | None],
    "xtwarns_flag": bool,
    "quit_on_err_flag": bool,
})
To3dParametersTagged = typing.TypedDict('To3dParametersTagged', {
    "@type": typing.Literal["afni/to3d"],
    "input_files": list[InputPathType],
    "type": typing.NotRequired[typing.Literal["spgr", "fse", "epan", "anat", "ct", "spct", "pet", "mra", "bmap", "diff", "omri", "abuc", "fim", "fith", "fico", "fitt", "fift", "fizt", "fict", "fibt", "fibn", "figt", "fipt", "fbuc"] | None],
    "statpar": typing.NotRequired[list[float] | None],
    "prefix": typing.NotRequired[str | None],
    "session": typing.NotRequired[str | None],
    "geomparent": typing.NotRequired[InputPathType | None],
    "anatparent": typing.NotRequired[InputPathType | None],
    "nosave_flag": bool,
    "nowritebrik_flag": bool,
    "view": typing.NotRequired[typing.Literal["orig", "acpc", "tlrc"] | None],
    "time_zt": typing.NotRequired[list[str] | None],
    "time_tz": typing.NotRequired[list[str] | None],
    "tr_units": typing.NotRequired[typing.Literal["ms", "msec", "s", "sec", "Hz", "Hertz"] | None],
    "torg": typing.NotRequired[float | None],
    "xFOV": typing.NotRequired[str | None],
    "yFOV": typing.NotRequired[str | None],
    "zFOV": typing.NotRequired[str | None],
    "xSLAB": typing.NotRequired[str | None],
    "ySLAB": typing.NotRequired[str | None],
    "zSLAB": typing.NotRequired[str | None],
    "zorigin": typing.NotRequired[float | None],
    "data_type": typing.NotRequired[typing.Literal["short", "float", "byte", "complex"] | None],
    "global_scaling_factor": typing.NotRequired[float | None],
    "nofloatscan_flag": bool,
    "in1_flag": bool,
    "orient": typing.NotRequired[str | None],
    "skip_outliers_flag": bool,
    "text_outliers_flag": bool,
    "save_outliers": typing.NotRequired[str | None],
    "assume_dicom_mosaic_flag": bool,
    "oblique_origin_flag": bool,
    "reverse_list_flag": bool,
    "use_last_elem_flag": bool,
    "use_old_mosaic_code_flag": bool,
    "ushort2float_flag": bool,
    "verbose_flag": bool,
    "gamma": typing.NotRequired[float | None],
    "ncolors": typing.NotRequired[float | None],
    "xtwarns_flag": bool,
    "quit_on_err_flag": bool,
})


class To3dOutputs(typing.NamedTuple):
    """
    Output object returned when calling `To3dParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    headfile: OutputPathType | None
    """Output AFNI HEAD file"""
    brikfile: OutputPathType | None
    """Output AFNI BRIK file"""
    outfile_outliers: OutputPathType | None
    """Outlier count file"""


def to3d_params(
    input_files: list[InputPathType],
    type_: typing.Literal["spgr", "fse", "epan", "anat", "ct", "spct", "pet", "mra", "bmap", "diff", "omri", "abuc", "fim", "fith", "fico", "fitt", "fift", "fizt", "fict", "fibt", "fibn", "figt", "fipt", "fbuc"] | None = None,
    statpar: list[float] | None = None,
    prefix: str | None = None,
    session: str | None = None,
    geomparent: InputPathType | None = None,
    anatparent: InputPathType | None = None,
    nosave_flag: bool = False,
    nowritebrik_flag: bool = False,
    view: typing.Literal["orig", "acpc", "tlrc"] | None = None,
    time_zt: list[str] | None = None,
    time_tz: list[str] | None = None,
    tr_units: typing.Literal["ms", "msec", "s", "sec", "Hz", "Hertz"] | None = None,
    torg: float | None = None,
    x_fov: str | None = None,
    y_fov: str | None = None,
    z_fov: str | None = None,
    x_slab: str | None = None,
    y_slab: str | None = None,
    z_slab: str | None = None,
    zorigin: float | None = None,
    data_type: typing.Literal["short", "float", "byte", "complex"] | None = None,
    global_scaling_factor: float | None = None,
    nofloatscan_flag: bool = False,
    in1_flag: bool = False,
    orient: str | None = None,
    skip_outliers_flag: bool = False,
    text_outliers_flag: bool = False,
    save_outliers: str | None = None,
    assume_dicom_mosaic_flag: bool = False,
    oblique_origin_flag: bool = False,
    reverse_list_flag: bool = False,
    use_last_elem_flag: bool = False,
    use_old_mosaic_code_flag: bool = False,
    ushort2float_flag: bool = False,
    verbose_flag: bool = False,
    gamma: float | None = None,
    ncolors: float | None = None,
    xtwarns_flag: bool = False,
    quit_on_err_flag: bool = False,
) -> To3dParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: Input 2D image files.
        type_: Declare images to contain data of a given type.
        statpar: Supply auxiliary statistical parameters.
        prefix: Prefix of the output 3D dataset.
        session: Session directory for output 3D dataset.
        geomparent: Read geometry data from dataset file.
        anatparent: Take anatomy parent from dataset file.
        nosave_flag: Suppress autosave of 3D dataset.
        nowritebrik_flag: Suppress saving of the BRIK file.
        view: Set the dataset's viewing coordinates.
        time_zt: Specify time dependent dataset (z-axis first, then t-axis).
        time_tz: Specify time dependent dataset (t-axis first, then z-axis).
        tr_units: Specify TR units.
        torg: Set time origin of dataset.
        x_fov: Specify size and orientation of the x-axis extent.
        y_fov: Specify size and orientation of the y-axis extent.
        z_fov: Specify size and orientation of the z-axis extent.
        x_slab: Specify x-axis slab.
        y_slab: Specify y-axis slab.
        z_slab: Specify z-axis slab.
        zorigin: Set the center of the first slice offset in z-axis.
        data_type: Set voxel data to be stored as given data type.
        global_scaling_factor: Global scaling factor.
        nofloatscan_flag: Do not scan for illegal floating point values.
        in1_flag: Read and process images one slice at a time.
        orient: Set the orientation of the 3D volumes.
        skip_outliers_flag: Skip the outlier check for 3D+time datasets.
        text_outliers_flag: Only print out the outlier check results in text\
            form.
        save_outliers: Save the outliers count into a 1D file.
        assume_dicom_mosaic_flag: Assume any Siemens DICOM file is a potential\
            MOSAIC image.
        oblique_origin_flag: Assume origin and orientation from oblique\
            transformation matrix.
        reverse_list_flag: Reverse the input file list.
        use_last_elem_flag: Search DICOM images for the last occurrence of each\
            element.
        use_old_mosaic_code_flag: Do not use the Dec 2010 updates to Siemens\
            mosaic code.
        ushort2float_flag: Convert input shorts to float and add 2^16 to any\
            negatives.
        verbose_flag: Show debugging information for reading DICOM files.
        gamma: Gamma correction factor for the monitor.
        ncolors: Number of gray levels for the image displays.
        xtwarns_flag: Turn on display of Xt warning messages.
        quit_on_err_flag: Do not launch interactive to3d mode if input has\
            error.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/to3d",
        "input_files": input_files,
        "nosave_flag": nosave_flag,
        "nowritebrik_flag": nowritebrik_flag,
        "nofloatscan_flag": nofloatscan_flag,
        "in1_flag": in1_flag,
        "skip_outliers_flag": skip_outliers_flag,
        "text_outliers_flag": text_outliers_flag,
        "assume_dicom_mosaic_flag": assume_dicom_mosaic_flag,
        "oblique_origin_flag": oblique_origin_flag,
        "reverse_list_flag": reverse_list_flag,
        "use_last_elem_flag": use_last_elem_flag,
        "use_old_mosaic_code_flag": use_old_mosaic_code_flag,
        "ushort2float_flag": ushort2float_flag,
        "verbose_flag": verbose_flag,
        "xtwarns_flag": xtwarns_flag,
        "quit_on_err_flag": quit_on_err_flag,
    }
    if type_ is not None:
        params["type"] = type_
    if statpar is not None:
        params["statpar"] = statpar
    if prefix is not None:
        params["prefix"] = prefix
    if session is not None:
        params["session"] = session
    if geomparent is not None:
        params["geomparent"] = geomparent
    if anatparent is not None:
        params["anatparent"] = anatparent
    if view is not None:
        params["view"] = view
    if time_zt is not None:
        params["time_zt"] = time_zt
    if time_tz is not None:
        params["time_tz"] = time_tz
    if tr_units is not None:
        params["tr_units"] = tr_units
    if torg is not None:
        params["torg"] = torg
    if x_fov is not None:
        params["xFOV"] = x_fov
    if y_fov is not None:
        params["yFOV"] = y_fov
    if z_fov is not None:
        params["zFOV"] = z_fov
    if x_slab is not None:
        params["xSLAB"] = x_slab
    if y_slab is not None:
        params["ySLAB"] = y_slab
    if z_slab is not None:
        params["zSLAB"] = z_slab
    if zorigin is not None:
        params["zorigin"] = zorigin
    if data_type is not None:
        params["data_type"] = data_type
    if global_scaling_factor is not None:
        params["global_scaling_factor"] = global_scaling_factor
    if orient is not None:
        params["orient"] = orient
    if save_outliers is not None:
        params["save_outliers"] = save_outliers
    if gamma is not None:
        params["gamma"] = gamma
    if ncolors is not None:
        params["ncolors"] = ncolors
    return params


def to3d_cargs(
    params: To3dParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("to3d")
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    if params.get("type", None) is not None:
        cargs.extend([
            "-type",
            params.get("type", None)
        ])
    if params.get("statpar", None) is not None:
        cargs.extend([
            "-statpar",
            *map(str, params.get("statpar", None))
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("session", None) is not None:
        cargs.extend([
            "-session",
            params.get("session", None)
        ])
    if params.get("geomparent", None) is not None:
        cargs.extend([
            "-geomparent",
            execution.input_file(params.get("geomparent", None))
        ])
    if params.get("anatparent", None) is not None:
        cargs.extend([
            "-anatparent",
            execution.input_file(params.get("anatparent", None))
        ])
    if params.get("nosave_flag", False):
        cargs.append("-nosave")
    if params.get("nowritebrik_flag", False):
        cargs.append("-nowritebrik")
    if params.get("view", None) is not None:
        cargs.extend([
            "-view",
            params.get("view", None)
        ])
    if params.get("time_zt", None) is not None:
        cargs.extend([
            "-time:zt",
            *params.get("time_zt", None)
        ])
    if params.get("time_tz", None) is not None:
        cargs.extend([
            "-time:tz",
            *params.get("time_tz", None)
        ])
    if params.get("tr_units", None) is not None:
        cargs.extend([
            "-t",
            params.get("tr_units", None)
        ])
    if params.get("torg", None) is not None:
        cargs.extend([
            "-Torg",
            str(params.get("torg", None))
        ])
    if params.get("xFOV", None) is not None:
        cargs.extend([
            "-xFOV",
            params.get("xFOV", None)
        ])
    if params.get("yFOV", None) is not None:
        cargs.extend([
            "-yFOV",
            params.get("yFOV", None)
        ])
    if params.get("zFOV", None) is not None:
        cargs.extend([
            "-zFOV",
            params.get("zFOV", None)
        ])
    if params.get("xSLAB", None) is not None:
        cargs.extend([
            "-xSLAB",
            params.get("xSLAB", None)
        ])
    if params.get("ySLAB", None) is not None:
        cargs.extend([
            "-ySLAB",
            params.get("ySLAB", None)
        ])
    if params.get("zSLAB", None) is not None:
        cargs.extend([
            "-zSLAB",
            params.get("zSLAB", None)
        ])
    if params.get("zorigin", None) is not None:
        cargs.extend([
            "-zorigin",
            str(params.get("zorigin", None))
        ])
    if params.get("data_type", None) is not None:
        cargs.extend([
            "-datum",
            params.get("data_type", None)
        ])
    if params.get("global_scaling_factor", None) is not None:
        cargs.extend([
            "-gsfac",
            str(params.get("global_scaling_factor", None))
        ])
    if params.get("nofloatscan_flag", False):
        cargs.append("-nofloatscan")
    if params.get("in1_flag", False):
        cargs.append("-in:1")
    if params.get("orient", None) is not None:
        cargs.extend([
            "-orient",
            params.get("orient", None)
        ])
    if params.get("skip_outliers_flag", False):
        cargs.append("-skip_outliers")
    if params.get("text_outliers_flag", False):
        cargs.append("-text_outliers")
    if params.get("save_outliers", None) is not None:
        cargs.extend([
            "-save_outliers",
            params.get("save_outliers", None)
        ])
    if params.get("assume_dicom_mosaic_flag", False):
        cargs.append("-assume_dicom_mosaic")
    if params.get("oblique_origin_flag", False):
        cargs.append("-oblique_origin")
    if params.get("reverse_list_flag", False):
        cargs.append("-reverse_list")
    if params.get("use_last_elem_flag", False):
        cargs.append("-use_last_elem")
    if params.get("use_old_mosaic_code_flag", False):
        cargs.append("-use_old_mosaic_code")
    if params.get("ushort2float_flag", False):
        cargs.append("-ushort2float")
    if params.get("verbose_flag", False):
        cargs.append("-verb")
    if params.get("gamma", None) is not None:
        cargs.extend([
            "-gamma",
            str(params.get("gamma", None))
        ])
    if params.get("ncolors", None) is not None:
        cargs.extend([
            "-ncolors",
            str(params.get("ncolors", None))
        ])
    if params.get("xtwarns_flag", False):
        cargs.append("-xtwarns")
    if params.get("quit_on_err_flag", False):
        cargs.append("-quit_on_err")
    return cargs


def to3d_outputs(
    params: To3dParameters,
    execution: Execution,
) -> To3dOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = To3dOutputs(
        root=execution.output_file("."),
        headfile=execution.output_file(params.get("prefix", None) + ".HEAD") if (params.get("prefix") is not None) else None,
        brikfile=execution.output_file(params.get("prefix", None) + ".BRIK") if (params.get("prefix") is not None) else None,
        outfile_outliers=execution.output_file(params.get("save_outliers", None)) if (params.get("save_outliers") is not None) else None,
    )
    return ret


def to3d_execute(
    params: To3dParameters,
    runner: Runner | None = None,
) -> To3dOutputs:
    """
    to3d
    
    Creates 3D datasets for use with AFNI from 2D image files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `To3dOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(TO3D_METADATA)
    params = execution.params(params)
    cargs = to3d_cargs(params, execution)
    ret = to3d_outputs(params, execution)
    execution.run(cargs)
    return ret


def to3d(
    input_files: list[InputPathType],
    type_: typing.Literal["spgr", "fse", "epan", "anat", "ct", "spct", "pet", "mra", "bmap", "diff", "omri", "abuc", "fim", "fith", "fico", "fitt", "fift", "fizt", "fict", "fibt", "fibn", "figt", "fipt", "fbuc"] | None = None,
    statpar: list[float] | None = None,
    prefix: str | None = None,
    session: str | None = None,
    geomparent: InputPathType | None = None,
    anatparent: InputPathType | None = None,
    nosave_flag: bool = False,
    nowritebrik_flag: bool = False,
    view: typing.Literal["orig", "acpc", "tlrc"] | None = None,
    time_zt: list[str] | None = None,
    time_tz: list[str] | None = None,
    tr_units: typing.Literal["ms", "msec", "s", "sec", "Hz", "Hertz"] | None = None,
    torg: float | None = None,
    x_fov: str | None = None,
    y_fov: str | None = None,
    z_fov: str | None = None,
    x_slab: str | None = None,
    y_slab: str | None = None,
    z_slab: str | None = None,
    zorigin: float | None = None,
    data_type: typing.Literal["short", "float", "byte", "complex"] | None = None,
    global_scaling_factor: float | None = None,
    nofloatscan_flag: bool = False,
    in1_flag: bool = False,
    orient: str | None = None,
    skip_outliers_flag: bool = False,
    text_outliers_flag: bool = False,
    save_outliers: str | None = None,
    assume_dicom_mosaic_flag: bool = False,
    oblique_origin_flag: bool = False,
    reverse_list_flag: bool = False,
    use_last_elem_flag: bool = False,
    use_old_mosaic_code_flag: bool = False,
    ushort2float_flag: bool = False,
    verbose_flag: bool = False,
    gamma: float | None = None,
    ncolors: float | None = None,
    xtwarns_flag: bool = False,
    quit_on_err_flag: bool = False,
    runner: Runner | None = None,
) -> To3dOutputs:
    """
    to3d
    
    Creates 3D datasets for use with AFNI from 2D image files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input 2D image files.
        type_: Declare images to contain data of a given type.
        statpar: Supply auxiliary statistical parameters.
        prefix: Prefix of the output 3D dataset.
        session: Session directory for output 3D dataset.
        geomparent: Read geometry data from dataset file.
        anatparent: Take anatomy parent from dataset file.
        nosave_flag: Suppress autosave of 3D dataset.
        nowritebrik_flag: Suppress saving of the BRIK file.
        view: Set the dataset's viewing coordinates.
        time_zt: Specify time dependent dataset (z-axis first, then t-axis).
        time_tz: Specify time dependent dataset (t-axis first, then z-axis).
        tr_units: Specify TR units.
        torg: Set time origin of dataset.
        x_fov: Specify size and orientation of the x-axis extent.
        y_fov: Specify size and orientation of the y-axis extent.
        z_fov: Specify size and orientation of the z-axis extent.
        x_slab: Specify x-axis slab.
        y_slab: Specify y-axis slab.
        z_slab: Specify z-axis slab.
        zorigin: Set the center of the first slice offset in z-axis.
        data_type: Set voxel data to be stored as given data type.
        global_scaling_factor: Global scaling factor.
        nofloatscan_flag: Do not scan for illegal floating point values.
        in1_flag: Read and process images one slice at a time.
        orient: Set the orientation of the 3D volumes.
        skip_outliers_flag: Skip the outlier check for 3D+time datasets.
        text_outliers_flag: Only print out the outlier check results in text\
            form.
        save_outliers: Save the outliers count into a 1D file.
        assume_dicom_mosaic_flag: Assume any Siemens DICOM file is a potential\
            MOSAIC image.
        oblique_origin_flag: Assume origin and orientation from oblique\
            transformation matrix.
        reverse_list_flag: Reverse the input file list.
        use_last_elem_flag: Search DICOM images for the last occurrence of each\
            element.
        use_old_mosaic_code_flag: Do not use the Dec 2010 updates to Siemens\
            mosaic code.
        ushort2float_flag: Convert input shorts to float and add 2^16 to any\
            negatives.
        verbose_flag: Show debugging information for reading DICOM files.
        gamma: Gamma correction factor for the monitor.
        ncolors: Number of gray levels for the image displays.
        xtwarns_flag: Turn on display of Xt warning messages.
        quit_on_err_flag: Do not launch interactive to3d mode if input has\
            error.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `To3dOutputs`).
    """
    params = to3d_params(
        input_files=input_files,
        type_=type_,
        statpar=statpar,
        prefix=prefix,
        session=session,
        geomparent=geomparent,
        anatparent=anatparent,
        nosave_flag=nosave_flag,
        nowritebrik_flag=nowritebrik_flag,
        view=view,
        time_zt=time_zt,
        time_tz=time_tz,
        tr_units=tr_units,
        torg=torg,
        x_fov=x_fov,
        y_fov=y_fov,
        z_fov=z_fov,
        x_slab=x_slab,
        y_slab=y_slab,
        z_slab=z_slab,
        zorigin=zorigin,
        data_type=data_type,
        global_scaling_factor=global_scaling_factor,
        nofloatscan_flag=nofloatscan_flag,
        in1_flag=in1_flag,
        orient=orient,
        skip_outliers_flag=skip_outliers_flag,
        text_outliers_flag=text_outliers_flag,
        save_outliers=save_outliers,
        assume_dicom_mosaic_flag=assume_dicom_mosaic_flag,
        oblique_origin_flag=oblique_origin_flag,
        reverse_list_flag=reverse_list_flag,
        use_last_elem_flag=use_last_elem_flag,
        use_old_mosaic_code_flag=use_old_mosaic_code_flag,
        ushort2float_flag=ushort2float_flag,
        verbose_flag=verbose_flag,
        gamma=gamma,
        ncolors=ncolors,
        xtwarns_flag=xtwarns_flag,
        quit_on_err_flag=quit_on_err_flag,
    )
    return to3d_execute(params, runner)


__all__ = [
    "TO3D_METADATA",
    "To3dOutputs",
    "to3d",
    "to3d_execute",
    "to3d_params",
]
