# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

TOKENS_METADATA = Metadata(
    id="8789e51456a92251b79dc05e20a851cdc91189eb.boutiques",
    name="tokens",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


TokensParameters = typing.TypedDict('TokensParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/tokens"]],
    "infile": typing.NotRequired[InputPathType | None],
    "extra_char": typing.NotRequired[list[str] | None],
})
TokensParametersTagged = typing.TypedDict('TokensParametersTagged', {
    "@type": typing.Literal["afni/tokens"],
    "infile": typing.NotRequired[InputPathType | None],
    "extra_char": typing.NotRequired[list[str] | None],
})


class TokensOutputs(typing.NamedTuple):
    """
    Output object returned when calling `TokensParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def tokens_params(
    infile: InputPathType | None = None,
    extra_char: list[str] | None = None,
) -> TokensParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: Specify input file (stdin if none).
        extra_char: Specify extra character to count as valid. Can be used more\
            than once.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/tokens",
    }
    if infile is not None:
        params["infile"] = infile
    if extra_char is not None:
        params["extra_char"] = extra_char
    return params


def tokens_cargs(
    params: TokensParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("tokens")
    if params.get("infile", None) is not None:
        cargs.extend([
            "-infile",
            execution.input_file(params.get("infile", None))
        ])
    if params.get("extra_char", None) is not None:
        cargs.extend([
            "-extra",
            *params.get("extra_char", None)
        ])
    return cargs


def tokens_outputs(
    params: TokensParameters,
    execution: Execution,
) -> TokensOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = TokensOutputs(
        root=execution.output_file("."),
    )
    return ret


def tokens_execute(
    params: TokensParameters,
    runner: Runner | None = None,
) -> TokensOutputs:
    """
    tokens
    
    Token counting tool.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `TokensOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(TOKENS_METADATA)
    params = execution.params(params)
    cargs = tokens_cargs(params, execution)
    ret = tokens_outputs(params, execution)
    execution.run(cargs)
    return ret


def tokens(
    infile: InputPathType | None = None,
    extra_char: list[str] | None = None,
    runner: Runner | None = None,
) -> TokensOutputs:
    """
    tokens
    
    Token counting tool.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Specify input file (stdin if none).
        extra_char: Specify extra character to count as valid. Can be used more\
            than once.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `TokensOutputs`).
    """
    params = tokens_params(
        infile=infile,
        extra_char=extra_char,
    )
    return tokens_execute(params, runner)


__all__ = [
    "TOKENS_METADATA",
    "TokensOutputs",
    "tokens",
    "tokens_execute",
    "tokens_params",
]
