# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

TRR_METADATA = Metadata(
    id="c435bab7378f5e16dad1fc03144f5b28d0a7cf22.boutiques",
    name="TRR",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


TrrParameters = typing.TypedDict('TrrParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/TRR"]],
    "prefix": str,
    "chains": typing.NotRequired[float | None],
    "iterations": typing.NotRequired[float | None],
    "response_var": str,
    "subject_var": str,
    "repetition_var": typing.NotRequired[str | None],
    "condition_var": typing.NotRequired[str | None],
    "data_table": InputPathType,
    "categorical_vars": typing.NotRequired[str | None],
    "quantitative_vars": typing.NotRequired[str | None],
    "response_dist": typing.NotRequired[str | None],
    "model": typing.NotRequired[str | None],
    "plot_size": typing.NotRequired[list[float] | None],
    "standard_error": typing.NotRequired[str | None],
    "t_stat": typing.NotRequired[str | None],
    "within_chain_parallelization": typing.NotRequired[float | None],
    "debug": bool,
    "verbose": typing.NotRequired[float | None],
})
TrrParametersTagged = typing.TypedDict('TrrParametersTagged', {
    "@type": typing.Literal["afni/TRR"],
    "prefix": str,
    "chains": typing.NotRequired[float | None],
    "iterations": typing.NotRequired[float | None],
    "response_var": str,
    "subject_var": str,
    "repetition_var": typing.NotRequired[str | None],
    "condition_var": typing.NotRequired[str | None],
    "data_table": InputPathType,
    "categorical_vars": typing.NotRequired[str | None],
    "quantitative_vars": typing.NotRequired[str | None],
    "response_dist": typing.NotRequired[str | None],
    "model": typing.NotRequired[str | None],
    "plot_size": typing.NotRequired[list[float] | None],
    "standard_error": typing.NotRequired[str | None],
    "t_stat": typing.NotRequired[str | None],
    "within_chain_parallelization": typing.NotRequired[float | None],
    "debug": bool,
    "verbose": typing.NotRequired[float | None],
})


class TrrOutputs(typing.NamedTuple):
    """
    Output object returned when calling `TrrParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file_txt: OutputPathType
    """Main output file containing inference information for effects of
    interest"""
    output_file_pdf: OutputPathType
    """Density plot of the TRR distribution"""
    output_file_rdata: OutputPathType
    """Saved R data in binary format for post hoc processing"""


def trr_params(
    prefix: str,
    response_var: str,
    subject_var: str,
    data_table: InputPathType,
    chains: float | None = None,
    iterations: float | None = None,
    repetition_var: str | None = None,
    condition_var: str | None = None,
    categorical_vars: str | None = None,
    quantitative_vars: str | None = None,
    response_dist: str | None = None,
    model: str | None = None,
    plot_size: list[float] | None = None,
    standard_error: str | None = None,
    t_stat: str | None = None,
    within_chain_parallelization: float | None = None,
    debug: bool = False,
    verbose: float | None = None,
) -> TrrParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix for output file names.
        response_var: Specify the column name for the response variable.
        subject_var: Specify the column name for the subject variable.
        data_table: Specify the path to the data table in pure text format.
        chains: Specify the number of Markov chains.
        iterations: Specify the number of iterations per Markov chain.
        repetition_var: Specify the column name for the repetition variable.
        condition_var: Specify the column name for the condition variable.
        categorical_vars: Identify categorical (qualitative) variables.
        quantitative_vars: Identify quantitative (covariate) variables.
        response_dist: Specify the distribution for the response variable\
            (e.g., 'gaussian', 'student', 'exgaussian').
        model: Specify the effects associated with explanatory variables.
        plot_size: Specify the layout of posterior distribution plot (PDP) with\
            width and height in inches.
        standard_error: Include standard error for the response variable as\
            input.
        t_stat: Specify the column name for the t-statistic values.
        within_chain_parallelization: Invoke within-chain parallelization;\
            specify number of threads per chain.
        debug: Enable R to save the parameters for debugging.
        verbose: Specify verbose level.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/TRR",
        "prefix": prefix,
        "response_var": response_var,
        "subject_var": subject_var,
        "data_table": data_table,
        "debug": debug,
    }
    if chains is not None:
        params["chains"] = chains
    if iterations is not None:
        params["iterations"] = iterations
    if repetition_var is not None:
        params["repetition_var"] = repetition_var
    if condition_var is not None:
        params["condition_var"] = condition_var
    if categorical_vars is not None:
        params["categorical_vars"] = categorical_vars
    if quantitative_vars is not None:
        params["quantitative_vars"] = quantitative_vars
    if response_dist is not None:
        params["response_dist"] = response_dist
    if model is not None:
        params["model"] = model
    if plot_size is not None:
        params["plot_size"] = plot_size
    if standard_error is not None:
        params["standard_error"] = standard_error
    if t_stat is not None:
        params["t_stat"] = t_stat
    if within_chain_parallelization is not None:
        params["within_chain_parallelization"] = within_chain_parallelization
    if verbose is not None:
        params["verbose"] = verbose
    return params


def trr_cargs(
    params: TrrParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("TRR")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("chains", None) is not None:
        cargs.extend([
            "-chains",
            str(params.get("chains", None))
        ])
    if params.get("iterations", None) is not None:
        cargs.extend([
            "-iterations",
            str(params.get("iterations", None))
        ])
    cargs.extend([
        "-Y",
        params.get("response_var", None)
    ])
    cargs.extend([
        "-subject",
        params.get("subject_var", None)
    ])
    if params.get("repetition_var", None) is not None:
        cargs.extend([
            "-repetition",
            params.get("repetition_var", None)
        ])
    if params.get("condition_var", None) is not None:
        cargs.extend([
            "-condition",
            params.get("condition_var", None)
        ])
    cargs.extend([
        "-dataTable",
        execution.input_file(params.get("data_table", None))
    ])
    if params.get("categorical_vars", None) is not None:
        cargs.extend([
            "-cVars",
            params.get("categorical_vars", None)
        ])
    if params.get("quantitative_vars", None) is not None:
        cargs.extend([
            "-qVars",
            params.get("quantitative_vars", None)
        ])
    if params.get("response_dist", None) is not None:
        cargs.extend([
            "-distY",
            params.get("response_dist", None)
        ])
    if params.get("model", None) is not None:
        cargs.extend([
            "-model",
            params.get("model", None)
        ])
    if params.get("plot_size", None) is not None:
        cargs.extend([
            "-PDP",
            *map(str, params.get("plot_size", None))
        ])
    if params.get("standard_error", None) is not None:
        cargs.extend([
            "-se",
            params.get("standard_error", None)
        ])
    if params.get("t_stat", None) is not None:
        cargs.extend([
            "-tstat",
            params.get("t_stat", None)
        ])
    if params.get("within_chain_parallelization", None) is not None:
        cargs.extend([
            "-WCP",
            str(params.get("within_chain_parallelization", None))
        ])
    if params.get("debug", False):
        cargs.append("-dbgArgs")
    if params.get("verbose", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbose", None))
        ])
    return cargs


def trr_outputs(
    params: TrrParameters,
    execution: Execution,
) -> TrrOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = TrrOutputs(
        root=execution.output_file("."),
        output_file_txt=execution.output_file(params.get("prefix", None) + ".txt"),
        output_file_pdf=execution.output_file(params.get("prefix", None) + ".pdf"),
        output_file_rdata=execution.output_file(params.get("prefix", None) + ".RData"),
    )
    return ret


def trr_execute(
    params: TrrParameters,
    runner: Runner | None = None,
) -> TrrOutputs:
    """
    TRR
    
    Test-Retest Reliability Program through Bayesian Multilevel Modeling.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `TrrOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(TRR_METADATA)
    params = execution.params(params)
    cargs = trr_cargs(params, execution)
    ret = trr_outputs(params, execution)
    execution.run(cargs)
    return ret


def trr(
    prefix: str,
    response_var: str,
    subject_var: str,
    data_table: InputPathType,
    chains: float | None = None,
    iterations: float | None = None,
    repetition_var: str | None = None,
    condition_var: str | None = None,
    categorical_vars: str | None = None,
    quantitative_vars: str | None = None,
    response_dist: str | None = None,
    model: str | None = None,
    plot_size: list[float] | None = None,
    standard_error: str | None = None,
    t_stat: str | None = None,
    within_chain_parallelization: float | None = None,
    debug: bool = False,
    verbose: float | None = None,
    runner: Runner | None = None,
) -> TrrOutputs:
    """
    TRR
    
    Test-Retest Reliability Program through Bayesian Multilevel Modeling.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix for output file names.
        response_var: Specify the column name for the response variable.
        subject_var: Specify the column name for the subject variable.
        data_table: Specify the path to the data table in pure text format.
        chains: Specify the number of Markov chains.
        iterations: Specify the number of iterations per Markov chain.
        repetition_var: Specify the column name for the repetition variable.
        condition_var: Specify the column name for the condition variable.
        categorical_vars: Identify categorical (qualitative) variables.
        quantitative_vars: Identify quantitative (covariate) variables.
        response_dist: Specify the distribution for the response variable\
            (e.g., 'gaussian', 'student', 'exgaussian').
        model: Specify the effects associated with explanatory variables.
        plot_size: Specify the layout of posterior distribution plot (PDP) with\
            width and height in inches.
        standard_error: Include standard error for the response variable as\
            input.
        t_stat: Specify the column name for the t-statistic values.
        within_chain_parallelization: Invoke within-chain parallelization;\
            specify number of threads per chain.
        debug: Enable R to save the parameters for debugging.
        verbose: Specify verbose level.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `TrrOutputs`).
    """
    params = trr_params(
        prefix=prefix,
        chains=chains,
        iterations=iterations,
        response_var=response_var,
        subject_var=subject_var,
        repetition_var=repetition_var,
        condition_var=condition_var,
        data_table=data_table,
        categorical_vars=categorical_vars,
        quantitative_vars=quantitative_vars,
        response_dist=response_dist,
        model=model,
        plot_size=plot_size,
        standard_error=standard_error,
        t_stat=t_stat,
        within_chain_parallelization=within_chain_parallelization,
        debug=debug,
        verbose=verbose,
    )
    return trr_execute(params, runner)


__all__ = [
    "TRR_METADATA",
    "TrrOutputs",
    "trr",
    "trr_execute",
    "trr_params",
]
