# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

UBER_PROC_PY_METADATA = Metadata(
    id="8b5bcd3ef76584ffc1c5ae37a1caf9d140efdf4b.boutiques",
    name="uber_proc.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


UberProcPyParameters = typing.TypedDict('UberProcPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/uber_proc.py"]],
    "results_dir": typing.NotRequired[str | None],
})
UberProcPyParametersTagged = typing.TypedDict('UberProcPyParametersTagged', {
    "@type": typing.Literal["afni/uber_proc.py"],
    "results_dir": typing.NotRequired[str | None],
})


class UberProcPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `UberProcPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def uber_proc_py_params(
    results_dir: str | None = None,
) -> UberProcPyParametersTagged:
    """
    Build parameters.
    
    Args:
        results_dir: Directory where results will be placed. Default is a new\
            'uber_results' directory in the current working directory.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/uber_proc.py",
    }
    if results_dir is not None:
        params["results_dir"] = results_dir
    return params


def uber_proc_py_cargs(
    params: UberProcPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("uber_proc.py")
    if params.get("results_dir", None) is not None:
        cargs.append(params.get("results_dir", None))
    return cargs


def uber_proc_py_outputs(
    params: UberProcPyParameters,
    execution: Execution,
) -> UberProcPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = UberProcPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def uber_proc_py_execute(
    params: UberProcPyParameters,
    runner: Runner | None = None,
) -> UberProcPyOutputs:
    """
    uber_proc.py
    
    Uber processing tool - work in progress.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UberProcPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(UBER_PROC_PY_METADATA)
    params = execution.params(params)
    cargs = uber_proc_py_cargs(params, execution)
    ret = uber_proc_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def uber_proc_py(
    results_dir: str | None = None,
    runner: Runner | None = None,
) -> UberProcPyOutputs:
    """
    uber_proc.py
    
    Uber processing tool - work in progress.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        results_dir: Directory where results will be placed. Default is a new\
            'uber_results' directory in the current working directory.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UberProcPyOutputs`).
    """
    params = uber_proc_py_params(
        results_dir=results_dir,
    )
    return uber_proc_py_execute(params, runner)


__all__ = [
    "UBER_PROC_PY_METADATA",
    "UberProcPyOutputs",
    "uber_proc_py",
    "uber_proc_py_execute",
    "uber_proc_py_params",
]
