# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

UBER_SKEL_PY_METADATA = Metadata(
    id="cffaa20c63a073437a32d6e77269be9b2e0c7f94.boutiques",
    name="uber_skel.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


UberSkelPyParameters = typing.TypedDict('UberSkelPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/uber_skel.py"]],
    "qt_options": typing.NotRequired[str | None],
    "no_gui_flag": bool,
    "print_script": bool,
    "save_script": typing.NotRequired[str | None],
    "user_var": typing.NotRequired[list[str] | None],
    "help_howto_program": bool,
    "help": bool,
    "help_gui": bool,
    "history": bool,
    "show_valid_opts": bool,
    "version": bool,
})
UberSkelPyParametersTagged = typing.TypedDict('UberSkelPyParametersTagged', {
    "@type": typing.Literal["afni/uber_skel.py"],
    "qt_options": typing.NotRequired[str | None],
    "no_gui_flag": bool,
    "print_script": bool,
    "save_script": typing.NotRequired[str | None],
    "user_var": typing.NotRequired[list[str] | None],
    "help_howto_program": bool,
    "help": bool,
    "help_gui": bool,
    "history": bool,
    "show_valid_opts": bool,
    "version": bool,
})


class UberSkelPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `UberSkelPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def uber_skel_py_params(
    qt_options: str | None = None,
    no_gui_flag: bool = False,
    print_script: bool = False,
    save_script: str | None = None,
    user_var: list[str] | None = None,
    help_howto_program: bool = False,
    help_: bool = False,
    help_gui: bool = False,
    history: bool = False,
    show_valid_opts: bool = False,
    version: bool = False,
) -> UberSkelPyParametersTagged:
    """
    Build parameters.
    
    Args:
        qt_options: Pass PyQt4 options directly to the GUI.
        no_gui_flag: Run without the GUI.
        print_script: Print the script.
        save_script: Save the script.
        user_var: Initialize user variables. Usage: -uvar <name> <value>.
        help_howto_program: Show programming comments.
        help_: Show help.
        help_gui: Show help for the GUI.
        history: Show history.
        show_valid_opts: Show valid options.
        version: Show version.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/uber_skel.py",
        "no_gui_flag": no_gui_flag,
        "print_script": print_script,
        "help_howto_program": help_howto_program,
        "help": help_,
        "help_gui": help_gui,
        "history": history,
        "show_valid_opts": show_valid_opts,
        "version": version,
    }
    if qt_options is not None:
        params["qt_options"] = qt_options
    if save_script is not None:
        params["save_script"] = save_script
    if user_var is not None:
        params["user_var"] = user_var
    return params


def uber_skel_py_cargs(
    params: UberSkelPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("uber_skel.py")
    if params.get("qt_options", None) is not None:
        cargs.extend([
            "-qt_opts",
            params.get("qt_options", None)
        ])
    if params.get("no_gui_flag", False):
        cargs.append("-no_gui")
    if params.get("print_script", False):
        cargs.append("-print_script")
    if params.get("save_script", None) is not None:
        cargs.extend([
            "-save_script",
            params.get("save_script", None)
        ])
    if params.get("user_var", None) is not None:
        cargs.extend([
            "-uvar",
            *params.get("user_var", None)
        ])
    if params.get("help_howto_program", False):
        cargs.append("-help_howto_program")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("help_gui", False):
        cargs.append("-help_gui")
    if params.get("history", False):
        cargs.append("-hist")
    if params.get("show_valid_opts", False):
        cargs.append("-show_valid_opts")
    if params.get("version", False):
        cargs.append("-ver")
    return cargs


def uber_skel_py_outputs(
    params: UberSkelPyParameters,
    execution: Execution,
) -> UberSkelPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = UberSkelPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def uber_skel_py_execute(
    params: UberSkelPyParameters,
    runner: Runner | None = None,
) -> UberSkelPyOutputs:
    """
    uber_skel.py
    
    Sample uber processing program for initializing user and control variables,
    with options for both GUI and non-GUI modes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UberSkelPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(UBER_SKEL_PY_METADATA)
    params = execution.params(params)
    cargs = uber_skel_py_cargs(params, execution)
    ret = uber_skel_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def uber_skel_py(
    qt_options: str | None = None,
    no_gui_flag: bool = False,
    print_script: bool = False,
    save_script: str | None = None,
    user_var: list[str] | None = None,
    help_howto_program: bool = False,
    help_: bool = False,
    help_gui: bool = False,
    history: bool = False,
    show_valid_opts: bool = False,
    version: bool = False,
    runner: Runner | None = None,
) -> UberSkelPyOutputs:
    """
    uber_skel.py
    
    Sample uber processing program for initializing user and control variables,
    with options for both GUI and non-GUI modes.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        qt_options: Pass PyQt4 options directly to the GUI.
        no_gui_flag: Run without the GUI.
        print_script: Print the script.
        save_script: Save the script.
        user_var: Initialize user variables. Usage: -uvar <name> <value>.
        help_howto_program: Show programming comments.
        help_: Show help.
        help_gui: Show help for the GUI.
        history: Show history.
        show_valid_opts: Show valid options.
        version: Show version.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UberSkelPyOutputs`).
    """
    params = uber_skel_py_params(
        qt_options=qt_options,
        no_gui_flag=no_gui_flag,
        print_script=print_script,
        save_script=save_script,
        user_var=user_var,
        help_howto_program=help_howto_program,
        help_=help_,
        help_gui=help_gui,
        history=history,
        show_valid_opts=show_valid_opts,
        version=version,
    )
    return uber_skel_py_execute(params, runner)


__all__ = [
    "UBER_SKEL_PY_METADATA",
    "UberSkelPyOutputs",
    "uber_skel_py",
    "uber_skel_py_execute",
    "uber_skel_py_params",
]
