# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

UN_WARP_EPI_PY_METADATA = Metadata(
    id="2073ad8540cf4584fe797a4fb911a5cf6c3d80e1.boutiques",
    name="unWarpEPI.py",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


UnWarpEpiPyParameters = typing.TypedDict('UnWarpEpiPyParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/unWarpEPI.py"]],
    "forward": InputPathType,
    "reverse": InputPathType,
    "anat4warp": InputPathType,
    "data": str,
    "subjID": str,
    "giant_move": bool,
})
UnWarpEpiPyParametersTagged = typing.TypedDict('UnWarpEpiPyParametersTagged', {
    "@type": typing.Literal["afni/unWarpEPI.py"],
    "forward": InputPathType,
    "reverse": InputPathType,
    "anat4warp": InputPathType,
    "data": str,
    "subjID": str,
    "giant_move": bool,
})


class UnWarpEpiPyOutputs(typing.NamedTuple):
    """
    Output object returned when calling `UnWarpEpiPyParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def un_warp_epi_py_params(
    forward: InputPathType,
    reverse: InputPathType,
    anat4warp: InputPathType,
    data: str,
    subj_id: str,
    giant_move: bool = False,
) -> UnWarpEpiPyParametersTagged:
    """
    Build parameters.
    
    Args:
        forward: Calibration matching data to be corrected.
        reverse: Calibration with opposing polarity to data to be corrected.
        anat4warp: Reference anatomical dataset.
        data: Data to be corrected (same polarity as forward calibration data).\
            Separate with commas if specifying multiple datasets.
        subj_id: ID of subject to be corrected.
        giant_move: Set giant_move option for align_epi_anat if final align of\
            anatomy to corrected EPI fails if datasets are far apart in space.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/unWarpEPI.py",
        "forward": forward,
        "reverse": reverse,
        "anat4warp": anat4warp,
        "data": data,
        "subjID": subj_id,
        "giant_move": giant_move,
    }
    return params


def un_warp_epi_py_cargs(
    params: UnWarpEpiPyParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("unWarpEPI.py")
    cargs.extend([
        "-f",
        execution.input_file(params.get("forward", None))
    ])
    cargs.extend([
        "-r",
        execution.input_file(params.get("reverse", None))
    ])
    cargs.extend([
        "-a",
        execution.input_file(params.get("anat4warp", None))
    ])
    cargs.extend([
        "-d",
        params.get("data", None)
    ])
    cargs.extend([
        "-s",
        params.get("subjID", None)
    ])
    if params.get("giant_move", False):
        cargs.append("-g")
    return cargs


def un_warp_epi_py_outputs(
    params: UnWarpEpiPyParameters,
    execution: Execution,
) -> UnWarpEpiPyOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = UnWarpEpiPyOutputs(
        root=execution.output_file("."),
    )
    return ret


def un_warp_epi_py_execute(
    params: UnWarpEpiPyParameters,
    runner: Runner | None = None,
) -> UnWarpEpiPyOutputs:
    """
    unWarpEPI.py
    
    Routine to unwarp EPI data set using another data set with opposite
    polarity.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UnWarpEpiPyOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(UN_WARP_EPI_PY_METADATA)
    params = execution.params(params)
    cargs = un_warp_epi_py_cargs(params, execution)
    ret = un_warp_epi_py_outputs(params, execution)
    execution.run(cargs)
    return ret


def un_warp_epi_py(
    forward: InputPathType,
    reverse: InputPathType,
    anat4warp: InputPathType,
    data: str,
    subj_id: str,
    giant_move: bool = False,
    runner: Runner | None = None,
) -> UnWarpEpiPyOutputs:
    """
    unWarpEPI.py
    
    Routine to unwarp EPI data set using another data set with opposite
    polarity.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        forward: Calibration matching data to be corrected.
        reverse: Calibration with opposing polarity to data to be corrected.
        anat4warp: Reference anatomical dataset.
        data: Data to be corrected (same polarity as forward calibration data).\
            Separate with commas if specifying multiple datasets.
        subj_id: ID of subject to be corrected.
        giant_move: Set giant_move option for align_epi_anat if final align of\
            anatomy to corrected EPI fails if datasets are far apart in space.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `UnWarpEpiPyOutputs`).
    """
    params = un_warp_epi_py_params(
        forward=forward,
        reverse=reverse,
        anat4warp=anat4warp,
        data=data,
        subj_id=subj_id,
        giant_move=giant_move,
    )
    return un_warp_epi_py_execute(params, runner)


__all__ = [
    "UN_WARP_EPI_PY_METADATA",
    "UnWarpEpiPyOutputs",
    "un_warp_epi_py",
    "un_warp_epi_py_execute",
    "un_warp_epi_py_params",
]
